/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldapconn;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapAnonConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAnonConnFactory
extends LdapConnFactory {
    public static Logger logger = LoggerFactory.getLogger(LdapAnonConnFactory.class);
    protected String id;
    PKISocketConfig config;
    protected int mMinConns = 5;
    protected int mMaxConns = 1000;
    protected int mMaxResults = 0;
    protected LdapConnInfo mConnInfo = null;
    public static final String PROP_MINCONNS = "minConns";
    public static final String PROP_MAXCONNS = "maxConns";
    public static final String PROP_MAXRESULTS = "maxResults";
    public static final String PROP_ERROR_IF_DOWN = "errorIfDown";
    private int mNumConns = 0;
    private int mTotal = 0;
    private AnonConnection[] mConns = null;
    private boolean mInited = false;
    private boolean mErrorIfDown;
    private boolean mDefErrorIfDown = false;

    public LdapAnonConnFactory(String id) {
        logger.debug("Creating LdapAnonConnFactory(" + id + ")");
        this.id = id;
    }

    public LdapAnonConnFactory(String id, boolean defErrorIfDown) {
        logger.debug("Creating LdapAnonConnFactory(" + id + ")");
        this.id = id;
        this.mDefErrorIfDown = defErrorIfDown;
    }

    public LdapAnonConnFactory(String id, int minConns, int maxConns, LdapConnInfo connInfo) throws ELdapException {
        logger.debug("Creating LdapAnonConnFactory(" + id + ")");
        this.id = id;
        this.mMinConns = minConns;
        this.mMaxConns = maxConns;
        this.mConnInfo = connInfo;
    }

    public LdapAnonConnFactory(String id, int minConns, int maxConns, int maxResults, LdapConnInfo connInfo) throws ELdapException {
        logger.debug("Creating LdapAnonConnFactory(" + id + ")");
        this.id = id;
        this.mMinConns = minConns;
        this.mMaxConns = maxConns;
        this.mMaxResults = maxResults;
        this.mConnInfo = connInfo;
    }

    @Override
    public int totalConn() {
        return this.mTotal;
    }

    @Override
    public int freeConn() {
        return this.mNumConns;
    }

    @Override
    public int maxConn() {
        return this.mMaxConns;
    }

    public void init(PKISocketConfig config) throws ELdapException {
        logger.debug("LdapAnonConnFactory: initialization");
        this.config = config;
        this.init();
    }

    public void init(PKISocketConfig config, LDAPConfig dbConfig) throws EBaseException, ELdapException {
        logger.debug("LdapAnonConnFactory: initialization");
        this.config = config;
        this.mMinConns = dbConfig.getInteger(PROP_MINCONNS, this.mMinConns);
        this.mMaxConns = dbConfig.getInteger(PROP_MAXCONNS, this.mMaxConns);
        this.mMaxResults = dbConfig.getInteger(PROP_MAXRESULTS, this.mMaxResults);
        this.mConnInfo = new LdapConnInfo(dbConfig.getConnectionConfig());
        this.mErrorIfDown = dbConfig.getBoolean(PROP_ERROR_IF_DOWN, this.mDefErrorIfDown);
        this.init();
    }

    protected void init() throws ELdapException {
        if (this.mInited) {
            return;
        }
        if (this.mMinConns <= 0) {
            throw new ELdapException("Invalid minimum number of connections: " + this.mMinConns);
        }
        if (this.mMaxConns <= 0) {
            throw new ELdapException("Invalid maximum number of connections: " + this.mMaxConns);
        }
        if (this.mMinConns > this.mMaxConns) {
            throw new ELdapException("Minimum number of connections is bigger than maximum: " + this.mMinConns + " > " + this.mMaxConns);
        }
        if (this.mMaxResults < 0) {
            throw new ELdapException("Invalid maximum number of results: " + this.mMaxResults);
        }
        if (this.mConnInfo == null) {
            throw new IllegalArgumentException("Missing connection info");
        }
        this.mConns = new AnonConnection[this.mMaxConns];
        logger.debug("LdapAnonConnFactory: mininum: " + this.mMinConns);
        logger.debug("LdapAnonConnFactory: maximum: " + this.mMaxConns);
        logger.debug("LdapAnonConnFactory: host: " + this.mConnInfo.getHost());
        logger.debug("LdapAnonConnFactory: port: " + this.mConnInfo.getPort());
        logger.debug("LdapAnonConnFactory: secure: " + this.mConnInfo.getSecure());
        if (this.mMinConns > 0) {
            this.makeMinimum(this.mErrorIfDown);
        }
        this.mInited = true;
    }

    protected void makeMinimum(boolean errorIfDown) throws ELdapException {
        int realMin = Math.max(this.mMinConns, 1);
        try {
            if (this.mNumConns < realMin && this.mTotal < this.mMaxConns) {
                int increment = Math.min(realMin - this.mNumConns, this.mMaxConns - this.mTotal);
                logger.debug("LdapAnonConnFactory: increasing minimum connections by " + increment);
                PKISocketFactory socketFactory = new PKISocketFactory();
                if (this.engine != null) {
                    socketFactory.setAuditor(this.engine.getAuditor());
                    socketFactory.addSocketListener(this.engine.getClientSocketListener());
                }
                socketFactory.setSecure(this.mConnInfo.getSecure());
                socketFactory.init(this.config);
                for (int i = increment - 1; i >= 0; --i) {
                    this.mConns[i] = new AnonConnection((LDAPSocketFactory)socketFactory, this.mConnInfo);
                }
                this.mTotal += increment;
                this.mNumConns += increment;
                logger.debug("LdapAnonConnFactory: total connections: " + this.mTotal);
                logger.debug("LdapAnonConnFactory: number of connections: " + this.mNumConns);
            }
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                String message = "LDAP server is unavailable: " + this.mConnInfo.getHost() + ":" + this.mConnInfo.getPort();
                logger.error("LdapAnonConnFactory: " + message, (Throwable)e);
                if (errorIfDown) {
                    throw new ELdapServerDownException(message, (Throwable)e);
                }
            }
            String errmsg = e.errorCodeToString();
            if (errmsg == null) {
                errmsg = e.getMessage();
            }
            String message = "Unable to connect to LDAP server: " + errmsg;
            logger.error("LdapAnonConnFactory: " + message, (Throwable)e);
            throw new ELdapException(message, (Throwable)e);
        }
    }

    @Override
    public LDAPConnection getConn() throws ELdapException {
        return this.getConn(true);
    }

    public synchronized LDAPConnection getConn(boolean waitForConn) throws ELdapException {
        AnonConnection conn = null;
        String method = "LdapAnonConnFactory (" + this.id + ").getConn: ";
        logger.debug(method + "initial values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
        logger.debug("LdapAnonConnFactory: getting a connection");
        if (this.mNumConns == 0) {
            this.makeMinimum(true);
        }
        while (this.mNumConns == 0) {
            logger.warn("LdapAnonConnFactory: waiting connections for " + this.mConnInfo.getHost() + ":" + this.mConnInfo.getPort());
            if (!waitForConn) {
                logger.warn("LdapAnonConnFactory: out of LDAP connections");
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.warn("LdapAnonConnFactory: connection wait interrupted");
                return null;
            }
            if (this.mMinConns != 0) continue;
            this.makeMinimum(true);
        }
        --this.mNumConns;
        conn = this.mConns[this.mNumConns];
        this.mConns[this.mNumConns] = null;
        logger.debug("LdapAnonConnFactory: number of connections: " + this.mNumConns);
        if (conn == null || !conn.isConnected()) {
            logger.debug("LdapAnonConnFactory: reestablishing connection");
            conn = null;
            try {
                PKISocketFactory socketFactory = new PKISocketFactory();
                if (this.engine != null) {
                    socketFactory.setAuditor(this.engine.getAuditor());
                    socketFactory.addSocketListener(this.engine.getClientSocketListener());
                }
                socketFactory.setSecure(this.mConnInfo.getSecure());
                socketFactory.init(this.config);
                conn = new AnonConnection((LDAPSocketFactory)socketFactory, this.mConnInfo);
            }
            catch (LDAPException e) {
                --this.mTotal;
                String message = "Unable to reestablish LDAP connection: " + e.getMessage();
                logger.error("LdapAnonConnFactory: " + message, (Throwable)e);
                throw new ELdapException(message, (Throwable)e);
            }
        }
        try {
            conn.setOption(3, this.mMaxResults);
        }
        catch (LDAPException e) {
            throw new ELdapException("Unable to set LDAP size limit: " + e.getMessage(), (Throwable)e);
        }
        logger.debug(method + " final values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
        return conn;
    }

    @Override
    public synchronized void returnConn(LDAPConnection conn) {
        String method = "LdapAnonConnFactory (" + this.id + ").returnConn: ";
        logger.debug(method + "initial values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
        if (conn == null) {
            return;
        }
        AnonConnection anon = null;
        if (!(conn instanceof AnonConnection)) {
            logger.warn("LdapAnonConnFactory: Unable to return connection: not an anonymous connection");
            return;
        }
        anon = (AnonConnection)conn;
        if (anon.getFacId() != this.mConns) {
            logger.warn("LdapAnonConnFactory: Unknown connection");
        }
        for (int i = 0; i < this.mNumConns; ++i) {
            if (this.mConns[i] != anon) continue;
            logger.warn("LdapAnonConnFactory: Connection already returned");
            --this.mTotal;
            this.notifyAll();
            return;
        }
        if (this.mNumConns < this.mMinConns) {
            try {
                anon.connect(this.mConnInfo.getHost(), this.mConnInfo.getPort());
            }
            catch (LDAPException e) {
                logger.warn("LdapAnonConnFactory: Unable to reauthenticate as anonymous");
            }
            this.mConns[this.mNumConns++] = anon;
        } else {
            try {
                anon.disconnect();
            }
            catch (LDAPException e) {
                logger.warn("LdapAnonConnFactory: Unable to disconnect: " + e.getMessage(), (Throwable)e);
            }
            --this.mTotal;
        }
        logger.debug("LdapAnonConnFactory: number of connections: " + this.mNumConns);
        this.notifyAll();
        logger.debug(method + " final values. Total: " + this.mTotal + ", pool: " + this.mNumConns);
    }

    protected void finalize() throws Exception {
        this.reset();
    }

    public LdapConnInfo getConnInfo() {
        return this.mConnInfo;
    }

    @Override
    public synchronized void reset() throws ELdapException {
        logger.debug("Destroying LdapAnonConnFactory(" + this.id + ")");
        if (this.mNumConns == this.mTotal) {
            for (int i = 0; i < this.mNumConns; ++i) {
                try {
                    this.mConns[i].disconnect();
                }
                catch (LDAPException e) {
                    logger.warn("LdapAnonConnFactory: Unable to disconnect: " + e.getMessage(), (Throwable)e);
                }
                this.mConns[i] = null;
            }
        } else {
            String message = "Unable to reset LDAP connection factory due to outstanding connections";
            logger.error("LdapAnonConnFactory: " + message);
            throw new ELdapException(message);
        }
        this.mTotal = 0;
        this.mNumConns = 0;
        this.mConns = new AnonConnection[this.mMaxConns];
    }

    public class AnonConnection
    extends LdapAnonConnection {
        private static final long serialVersionUID = 4813780131074412404L;

        public AnonConnection(LDAPSocketFactory socketFactory, LdapConnInfo connInfo) throws LDAPException {
            super(socketFactory, connInfo);
        }

        public AnonConnection(String host, int port, int version, LDAPSocketFactory fac) throws LDAPException {
            super(host, port, version, fac);
        }

        public AnonConnection(String host, int port, int version) throws LDAPException {
            super(host, port, version);
        }

        public AnonConnection[] getFacId() {
            return LdapAnonConnFactory.this.mConns;
        }
    }
}

