/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringVectorMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(StringVectorMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public StringVectorMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        Vector v = (Vector)obj;
        int s = v.size();
        if (s == 0) {
            return;
        }
        String[] m = new String[s];
        for (int i = 0; i < s; ++i) {
            m[i] = (String)v.elementAt(i);
        }
        logger.debug("StringVectorMapper: Mapping " + name + " to " + this.mLdapName);
        attrs.add(new LDAPAttribute(this.mLdapName, m));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        Enumeration e = attr.getStringValues();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        if (v.size() == 0) {
            return;
        }
        Object[] m = new String[v.size()];
        v.copyInto(m);
        parent.set(name, m);
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return this.mLdapName + op + value;
    }
}

