/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.cert.CertUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(PublicKeyMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public PublicKeyMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        logger.debug("PublicKeyMapper: Mapping " + name + " to " + this.mLdapName);
        attrs.add(new LDAPAttribute(this.mLdapName, (byte[])obj));
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
        if (attr == null) {
            return;
        }
        parent.set(name, attr.getByteValues().nextElement());
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        int i = value.indexOf("#");
        if (i != -1) {
            String val = value.substring(i + 1);
            try {
                if (val.startsWith("\"")) {
                    val = val.substring(1, val.length() - 1);
                }
                X509Certificate cert = CertUtils.mapCert(val);
                PublicKey key = cert.getPublicKey();
                byte[] pub = key.getEncoded();
                return this.mLdapName + op + PublicKeyMapper.escapeBinaryData(pub);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage("CMSCORE_DBS_PUBLICKEY_MAPPER_ERROR", e.toString()), (Throwable)e);
            }
        }
        return this.mLdapName + op + value;
    }

    public static String escapeBinaryData(byte[] data) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int v = 0xFF & data[i];
            result.append("\\" + (v < 16 ? "0" : "") + Integer.toHexString(v));
        }
        return result.toString();
    }
}

