/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStreamMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(ObjectStreamMapper.class);
    private String mLdapName = null;
    private Vector<String> v = new Vector();

    public ObjectStreamMapper(String ldapName) {
        this.mLdapName = ldapName;
        this.v.addElement(this.mLdapName);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return this.v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(obj);
            byte[] data = bos.toByteArray();
            logger.debug("ObjectStreamMapper: Mapping " + name + " to " + this.mLdapName);
            attrs.add(new LDAPAttribute(this.mLdapName, data));
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSCORE_DBS_OBJECTSTREAM_MAPPER_ERROR", e.toString()), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name), (Throwable)e);
        }
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        try {
            LDAPAttribute attr = attrs.getAttribute(this.mLdapName);
            if (attr == null) {
                return;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream((byte[])attr.getByteValues().nextElement());
            ObjectInputStream is = new ObjectInputStream(bis);
            parent.set(name, is.readObject());
        }
        catch (IOException e) {
            throw new EDBException(CMS.getUserMessage("CMS_DBS_DESERIALIZE_FAILED", name));
        }
        catch (ClassNotFoundException e) {
            throw new EDBException(CMS.getUserMessage("CMS_DBS_DESERIALIZE_FAILED", name));
        }
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return this.mLdapName + op + value;
    }
}

