/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.keydb.KeyState;
import com.netscape.cmscore.apps.CMS;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.netscape.security.util.WrappingParams;

public class KeyRecord
implements IDBObj {
    private static final long serialVersionUID = -3765000841161998984L;
    public static final String ATTR_ID = "keySerialNumber";
    public static final String ATTR_STATE = "keyState";
    public static final String ATTR_ALGORITHM = "algorithm";
    public static final String ATTR_KEY_SIZE = "keySize";
    public static final String ATTR_OWNER_NAME = "keyOwnerName";
    public static final String ATTR_PRIVATE_KEY_DATA = "privateKey";
    public static final String ATTR_PUBLIC_KEY_DATA = "publicKey";
    public static final String ATTR_DATE_OF_RECOVERY = "dateOfRecovery";
    public static final String ATTR_CREATE_TIME = "keyCreateTime";
    public static final String ATTR_MODIFY_TIME = "keyModifyTime";
    public static final String ATTR_META_INFO = "keyMetaInfo";
    public static final String ATTR_ARCHIVED_BY = "keyArchivedBy";
    public static final String ATTR_CLIENT_ID = "clientId";
    public static final String ATTR_DATA_TYPE = "dataType";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_REALM = "realm";
    public static final String STATUS_ANY = "ANY";
    public static final String STATUS_VALID = "VALID";
    public static final String STATUS_INVALID = "INVALID";
    private BigInteger mSerialNo = null;
    private KeyState mState = null;
    private MetaInfo mMetaInfo = null;
    private String mAlgorithm = null;
    private byte[] mPrivateKey = null;
    private byte[] mPublicKey = null;
    private Integer mSize = null;
    private String mOwnerName = null;
    private Date[] mDatesOfRecovery = null;
    private Date mCreateTime = null;
    private Date mModifyTime = null;
    private String mArchivedBy = null;
    private String mClientId = null;
    private String mStatus = null;
    private String mDataType = null;
    private String realm = null;
    protected static Vector<String> mNames = new Vector();

    public KeyRecord() {
    }

    public KeyRecord(BigInteger serialNo, byte[] publicData, byte[] privateData, String owner, String algorithm, String agentId) throws EBaseException {
        this.mSerialNo = serialNo;
        this.mPublicKey = publicData;
        this.mPrivateKey = privateData;
        this.mOwnerName = owner;
        this.mAlgorithm = algorithm;
        this.mState = KeyState.VALID;
        this.mCreateTime = new Date();
        this.mModifyTime = new Date();
        this.mArchivedBy = agentId;
    }

    public void set(String name, Object object) throws EBaseException {
        if (name.equalsIgnoreCase(ATTR_STATE)) {
            this.mState = (KeyState)object;
        } else if (name.equalsIgnoreCase(ATTR_ID)) {
            this.mSerialNo = (BigInteger)object;
        } else if (name.equalsIgnoreCase(ATTR_KEY_SIZE)) {
            this.mSize = (Integer)object;
        } else if (name.equalsIgnoreCase(ATTR_OWNER_NAME)) {
            this.mOwnerName = (String)object;
        } else if (name.equalsIgnoreCase(ATTR_ALGORITHM)) {
            this.mAlgorithm = (String)object;
        } else if (name.equalsIgnoreCase(ATTR_PRIVATE_KEY_DATA)) {
            this.mPrivateKey = (byte[])object;
        } else if (name.equalsIgnoreCase(ATTR_PUBLIC_KEY_DATA)) {
            this.mPublicKey = (byte[])object;
        } else if (name.equalsIgnoreCase(ATTR_DATE_OF_RECOVERY)) {
            this.mDatesOfRecovery = (Date[])object;
        } else if (name.equalsIgnoreCase(ATTR_META_INFO)) {
            this.mMetaInfo = (MetaInfo)object;
        } else if (name.equalsIgnoreCase(ATTR_CREATE_TIME)) {
            this.mCreateTime = (Date)object;
        } else if (name.equalsIgnoreCase(ATTR_MODIFY_TIME)) {
            this.mModifyTime = (Date)object;
        } else if (name.equalsIgnoreCase(ATTR_ARCHIVED_BY)) {
            this.mArchivedBy = (String)object;
        } else if (name.equalsIgnoreCase(ATTR_CLIENT_ID)) {
            this.mClientId = (String)object;
        } else if (name.equalsIgnoreCase(ATTR_DATA_TYPE)) {
            this.mDataType = (String)object;
        } else if (name.equalsIgnoreCase(ATTR_STATUS)) {
            this.mStatus = (String)object;
        } else if (name.equalsIgnoreCase(ATTR_REALM)) {
            this.realm = (String)object;
        } else {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", name));
        }
    }

    public Object get(String name) throws EBaseException {
        if (name.equalsIgnoreCase(ATTR_STATE)) {
            return this.mState;
        }
        if (name.equalsIgnoreCase(ATTR_ID)) {
            return this.mSerialNo;
        }
        if (name.equalsIgnoreCase(ATTR_KEY_SIZE)) {
            return this.mSize;
        }
        if (name.equalsIgnoreCase(ATTR_OWNER_NAME)) {
            return this.mOwnerName;
        }
        if (name.equalsIgnoreCase(ATTR_ALGORITHM)) {
            return this.mAlgorithm;
        }
        if (name.equalsIgnoreCase(ATTR_PRIVATE_KEY_DATA)) {
            return this.mPrivateKey;
        }
        if (name.equalsIgnoreCase(ATTR_PUBLIC_KEY_DATA)) {
            return this.mPublicKey;
        }
        if (name.equalsIgnoreCase(ATTR_DATE_OF_RECOVERY)) {
            return this.mDatesOfRecovery;
        }
        if (name.equalsIgnoreCase(ATTR_CREATE_TIME)) {
            return this.mCreateTime;
        }
        if (name.equalsIgnoreCase(ATTR_MODIFY_TIME)) {
            return this.mModifyTime;
        }
        if (name.equalsIgnoreCase(ATTR_META_INFO)) {
            return this.mMetaInfo;
        }
        if (name.equalsIgnoreCase(ATTR_ARCHIVED_BY)) {
            return this.mArchivedBy;
        }
        if (name.equalsIgnoreCase(ATTR_CLIENT_ID)) {
            return this.mClientId;
        }
        if (name.equalsIgnoreCase(ATTR_DATA_TYPE)) {
            return this.mDataType;
        }
        if (name.equalsIgnoreCase(ATTR_STATUS)) {
            return this.mStatus;
        }
        if (name.equalsIgnoreCase(ATTR_REALM)) {
            return this.realm;
        }
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", name));
    }

    public void delete(String name) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", name));
    }

    public Enumeration<String> getElements() {
        return mNames.elements();
    }

    @Override
    public Enumeration<String> getSerializableAttrNames() {
        return mNames.elements();
    }

    public BigInteger getSerialNumber() throws EBaseException {
        return this.mSerialNo;
    }

    public void setSerialNumber(BigInteger serialno) throws EBaseException {
        this.mSerialNo = serialno;
    }

    public KeyState getState() throws EBaseException {
        return this.mState;
    }

    public void setState(KeyState state) throws EBaseException {
        this.mState = state;
    }

    public String getArchivedBy() {
        return this.mArchivedBy;
    }

    public byte[] getPrivateKeyData() throws EBaseException {
        return this.mPrivateKey;
    }

    public void setPrivateKeyData(byte[] keydata) throws EBaseException {
        this.mPrivateKey = keydata;
    }

    public Integer getKeySize() throws EBaseException {
        return this.mSize;
    }

    public MetaInfo getMetaInfo() {
        return this.mMetaInfo;
    }

    public void setKeySize(Integer keySize) throws EBaseException {
        this.mSize = keySize;
    }

    public String getOwnerName() throws EBaseException {
        return this.mOwnerName;
    }

    public void setOwnerName(String name) throws EBaseException {
        this.mOwnerName = name;
    }

    public byte[] getPublicKeyData() throws EBaseException {
        return this.mPublicKey;
    }

    public void setPublicKeyData(byte[] key) throws EBaseException {
        this.mPublicKey = key;
    }

    public Date[] getDateOfRevocation() throws EBaseException {
        return this.mDatesOfRecovery;
    }

    public void setDateOfRevocation(Date[] dates) throws EBaseException {
        this.mDatesOfRecovery = dates;
    }

    public String getAlgorithm() {
        return this.mAlgorithm;
    }

    public Date getCreateTime() {
        return this.mCreateTime;
    }

    public Date getModifyTime() {
        return this.mModifyTime;
    }

    public String getClientId() throws EBaseException {
        return this.mClientId;
    }

    public String getKeyStatus() throws EBaseException {
        return this.mStatus;
    }

    public String getDataType() throws EBaseException {
        return this.mDataType;
    }

    public String getRealm() throws EBaseException {
        return this.realm;
    }

    public void setWrappingParams(WrappingParams params, boolean doEncrypt) throws Exception {
        if (this.mMetaInfo == null) {
            this.mMetaInfo = new MetaInfo();
        }
        this.mMetaInfo.set("sessionKeyLength", (Object)String.valueOf(params.getSkLength()));
        if (params.getSkType() != null) {
            this.mMetaInfo.set("sessionKeyType", (Object)params.getSkType().toString());
        }
        if (params.getSkKeyGenAlgorithm() != null) {
            this.mMetaInfo.set("sessionKeyKeyGenAlgorithm", (Object)params.getSkKeyGenAlgorithm().toString());
        }
        if (params.getSkWrapAlgorithm() != null) {
            this.mMetaInfo.set("sessionKeyWrapAlgorithm", (Object)params.getSkWrapAlgorithm().toString());
        }
        if (params.getPayloadEncryptionAlgorithm() != null) {
            EncryptionAlgorithm encrypt = params.getPayloadEncryptionAlgorithm();
            try {
                OBJECT_IDENTIFIER oid = encrypt.toOID();
                this.mMetaInfo.set("payloadEncryptionOID", (Object)oid.toDottedString());
            }
            catch (NoSuchAlgorithmException e) {
                this.mMetaInfo.set("payloadEncryptionAlgorithm", (Object)encrypt.getAlg().toString());
                this.mMetaInfo.set("payloadEncryptionMode", (Object)encrypt.getMode().toString());
                this.mMetaInfo.set("payloadEncryptionPadding", (Object)encrypt.getPadding().toString());
            }
        }
        if (params.getPayloadWrapAlgorithm() != null) {
            this.mMetaInfo.set("payloadWrapAlgorithm", (Object)params.getPayloadWrapAlgorithm().toString());
        }
        if (params.getPayloadWrappingIV() != null) {
            this.mMetaInfo.set("payloadWrapIV", (Object)Base64.encodeBase64String((byte[])params.getPayloadWrappingIV().getIV()));
        }
        if (params.getPayloadEncryptionIV() != null) {
            this.mMetaInfo.set("payloadEncryptionIV", (Object)Base64.encodeBase64String((byte[])params.getPayloadEncryptionIV().getIV()));
        }
        this.mMetaInfo.set("payloadEncrypted", (Object)Boolean.toString(doEncrypt));
    }

    public WrappingParams getWrappingParams(WrappingParams oldParams) throws Exception {
        byte[] iv;
        if (this.mMetaInfo == null || this.mMetaInfo.get("sessionKeyType") == null) {
            return oldParams;
        }
        WrappingParams params = new WrappingParams();
        params.setSkType(this.mMetaInfo.get("sessionKeyType").toString());
        params.setSkLength(Integer.parseInt(this.mMetaInfo.get("sessionKeyLength").toString()));
        Object data = this.mMetaInfo.get("sessionKeyWrapAlgorithm");
        if (data != null) {
            params.setSkWrapAlgorithm(data.toString());
        }
        if ((data = this.mMetaInfo.get("sessionKeyKeyGenAlgorithm")) != null) {
            params.setSkKeyGenAlgorithm(data.toString());
        }
        if ((data = this.mMetaInfo.get("payloadWrapAlgorithm")) != null) {
            params.setPayloadWrapAlgorithm(data.toString());
        }
        if (this.mMetaInfo.get("payloadEncryptionOID") != null) {
            String oidString = this.mMetaInfo.get("payloadEncryptionOID").toString();
            params.setPayloadEncryptionAlgorithm(EncryptionAlgorithm.fromOID((OBJECT_IDENTIFIER)new OBJECT_IDENTIFIER(oidString)));
        } else {
            params.setPayloadEncryptionAlgorithm(this.mMetaInfo.get("payloadEncryptionAlgorithm").toString(), this.mMetaInfo.get("payloadEncryptionMode").toString(), this.mMetaInfo.get("payloadEncryptionPadding").toString(), Integer.parseInt(this.mMetaInfo.get("sessionKeyLength").toString()));
        }
        data = this.mMetaInfo.get("payloadEncryptionIV");
        if (data != null) {
            iv = Base64.decodeBase64((String)data.toString());
            params.setPayloadEncryptionIV(new IVParameterSpec(iv));
        }
        if ((data = this.mMetaInfo.get("payloadWrapIV")) != null) {
            iv = Base64.decodeBase64((String)data.toString());
            params.setPayloadWrappingIV(new IVParameterSpec(iv));
        }
        return params;
    }

    public Boolean isEncrypted() throws EBaseException {
        if (this.mMetaInfo == null) {
            return null;
        }
        String encrypted = (String)this.mMetaInfo.get("payloadEncrypted");
        if (encrypted == null) {
            return null;
        }
        return Boolean.valueOf(encrypted);
    }

    static {
        mNames.addElement(ATTR_STATE);
        mNames.addElement(ATTR_ID);
        mNames.addElement(ATTR_OWNER_NAME);
        mNames.addElement(ATTR_KEY_SIZE);
        mNames.addElement(ATTR_ALGORITHM);
        mNames.addElement(ATTR_PRIVATE_KEY_DATA);
        mNames.addElement(ATTR_PUBLIC_KEY_DATA);
        mNames.addElement(ATTR_DATE_OF_RECOVERY);
        mNames.addElement(ATTR_META_INFO);
        mNames.addElement(ATTR_CREATE_TIME);
        mNames.addElement(ATTR_MODIFY_TIME);
        mNames.addElement(ATTR_ARCHIVED_BY);
        mNames.addElement(ATTR_CLIENT_ID);
        mNames.addElement(ATTR_STATUS);
        mNames.addElement(ATTR_DATA_TYPE);
        mNames.addElement(ATTR_REALM);
    }
}

