/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Hashtable;

public class RemoteAuthority {
    String mHost = null;
    int mPort = -1;
    String mURI = null;
    Hashtable<String, String> mURIs = new Hashtable();
    String mContentType = null;
    int mTimeout = 0;

    public RemoteAuthority(String host, int port, String uri, int timeout) {
        this.mHost = host;
        this.mPort = port;
        this.mURI = uri;
        this.mTimeout = timeout;
    }

    public RemoteAuthority(String host, int port, Hashtable<String, String> uris, int timeout) {
        this.mHost = host;
        this.mPort = port;
        this.mURIs = uris;
        this.mTimeout = timeout;
    }

    public RemoteAuthority(String host, int port, Hashtable<String, String> uris, int timeout, String contentType) {
        this.mHost = host;
        this.mPort = port;
        this.mURIs = uris;
        this.mTimeout = timeout;
        this.mContentType = contentType.equals("") ? null : contentType;
    }

    public RemoteAuthority() {
    }

    public void init(ConfigStore c) throws EBaseException {
        this.mHost = c.getString("host");
        this.mPort = c.getInteger("port");
        this.mURI = c.getString("uri");
        this.mTimeout = c.getInteger("timeout");
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getURI() {
        return this.mURI;
    }

    public String getURI(String name) {
        return this.mURIs.get(name);
    }

    public Hashtable<String, String> getURIs() {
        return this.mURIs;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public String getContentType() {
        return this.mContentType;
    }
}

