/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.usrgrp.CertUserLocator;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.usrgrp.ExactMatchCertUserLocator;
import com.netscape.cmscore.usrgrp.User;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import netscape.ldap.LDAPException;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.authentication.RevocationCheckingConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUserDBAuthentication
extends AuthManager {
    public static Logger logger = LoggerFactory.getLogger(CertUserDBAuthentication.class);
    public static final String TOKEN_USERDN = "user";
    public static final String TOKEN_USER_DN = "userdn";
    public static final String TOKEN_USERID = "userid";
    public static final String TOKEN_UID = "uid";
    public static final String CRED_CERT = "sslClientCert";
    protected String[] mRequiredCreds = new String[]{"sslClientCert"};
    private CertUserLocator mCULocator = null;
    private boolean mRevocationCheckingEnabled = false;
    private RevocationCheckingConfig mRevocationChecking;

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        if (authenticationConfig != null) {
            this.mRevocationChecking = authenticationConfig.getRevocationCheckingConfig();
        }
        if (this.mRevocationChecking != null) {
            this.mRevocationCheckingEnabled = this.mRevocationChecking.isEnabled();
            if (this.mRevocationCheckingEnabled) {
                int size = this.mRevocationChecking.getBufferSize();
                long interval = this.mRevocationChecking.getValidityInterval();
                long unknownStateInterval = this.mRevocationChecking.getUnknownStateInterval();
                if (size > 0) {
                    this.engine.setListOfVerifiedCerts(size, interval, unknownStateInterval);
                }
            }
        }
        this.mCULocator = new ExactMatchCertUserLocator();
        this.mCULocator.setCMSEngine(this.engine);
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getText(Locale locale) {
        return null;
    }

    @Override
    public Enumeration<String> getValueNames() {
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    @Override
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        logger.debug("CertUserDBAuth: started");
        AuthToken authToken = new AuthToken(this);
        logger.debug("CertUserDBAuth: Retrieving client certificate");
        X509Certificate[] x509Certs = (X509Certificate[])authCred.get(CRED_CERT);
        if (x509Certs == null) {
            logger.error("CertUserDBAuthentication: " + CMS.getLogMessage("CMSCORE_AUTH_MISSING_CERT", new Object[0]));
            throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_CERT));
        }
        logger.debug("CertUserDBAuth: Got client certificate");
        if (this.mRevocationCheckingEnabled) {
            X509CertImpl cert0 = (X509CertImpl)x509Certs[0];
            if (cert0 == null) {
                logger.error("CertUserDBAuthentication: " + CMS.getLogMessage("CMSCORE_AUTH_NO_CERT", new Object[0]));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_NO_CERT", new String[0]));
            }
            if (this.engine.isRevoked(x509Certs)) {
                logger.error("CertUserDBAuthentication: " + CMS.getLogMessage("CMSCORE_AUTH_REVOKED_CERT", new Object[0]));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
        }
        logger.debug("Authentication: client certificate found");
        User user = null;
        Certificates certs = new Certificates(x509Certs);
        try {
            user = this.mCULocator.locateUser(certs);
        }
        catch (EUsrGrpException e) {
            logger.error("CertUserDBAuthentication: cannot map certificate to any user: " + e.getMessage(), (Throwable)e);
            logger.error("CertUserDBAuthentication: " + CMS.getLogMessage("CMSCORE_AUTH_AGENT_AUTH_FAILED", x509Certs[0].getSerialNumber().toString(16), x509Certs[0].getSubjectDN().toString(), e.toString()));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        catch (LDAPException e) {
            logger.error("CertUserDBAuthentication: " + CMS.getLogMessage("CMSCORE_AUTH_CANNOT_AGENT_AUTH", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", e.toString()));
        }
        if (user == null) {
            logger.error("CertUserDBAuthentication: cannot map certificate to any user");
            logger.error("CertUserDBAuthentication: " + CMS.getLogMessage("CMSCORE_AUTH_AGENT_USER_NOT_FOUND", new Object[0]));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        logger.debug("Authentication: mapped certificate to user");
        authToken.set(TOKEN_USERDN, user.getUserDN());
        authToken.set(TOKEN_USER_DN, user.getUserDN());
        authToken.set(TOKEN_USERID, user.getUserID());
        authToken.set(TOKEN_UID, user.getUserID());
        authToken.set(CRED_CERT, certs);
        logger.info("CertUserDBAuthentication: " + CMS.getLogMessage("CMS_AUTH_AUTHENTICATED", user.getUserID()));
        return authToken;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    @Override
    public String[] getRequiredCreds() {
        return this.mRequiredCreds;
    }

    @Override
    public void shutdown() {
    }
}

