/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.request.ReqParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchReqs
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(SearchReqs.class);
    protected static final String TPL_FILE = "queryReq.template";
    protected static final String PROP_MAX_SEARCH_RETURNS = "maxSearchReqReturns";
    protected static final String PROP_PARSER = "parser";
    protected static final String CURRENT_TIME = "currentTime";
    protected static final String OUT_TOTALCOUNT = "totalRecordCount";
    protected static final String OUT_CURRENTCOUNT = "currentRecordCount";
    protected static final int MAX_RESULTS = 1000;
    protected RequestRepository requestRepository;
    protected ReqParser mParser;
    protected String mFormPath;
    protected int mMaxReturns = 1000;
    protected int mTimeLimits = 30;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CMSEngine engine = this.getCMSEngine();
        IAuthority sub = this.mAuthority;
        ConfigStore authConfig = sub.getConfigStore();
        if (authConfig != null) {
            try {
                this.mMaxReturns = authConfig.getInteger(PROP_MAX_SEARCH_RETURNS, 1000);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
        }
        this.requestRepository = engine.getRequestRepository();
        this.mFormPath = "/" + this.mAuthority.getId() + "/queryReq.template";
        try {
            int maxResults = Integer.parseInt(sc.getInitParameter("maxResults"));
            if (maxResults < this.mMaxReturns) {
                this.mMaxReturns = maxResults;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mTimeLimits = Integer.parseInt(sc.getInitParameter("timeLimits"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mTemplates.remove(CMSRequest.ERROR);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        EBaseException error = null;
        int maxResults = -1;
        int timeLimit = -1;
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_GET_TEMPLATE", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
        try {
            String timeLimitStr;
            String maxResultsStr = req.getParameter("maxResults");
            if (maxResultsStr != null && maxResultsStr.length() > 0) {
                maxResults = Integer.parseInt(maxResultsStr);
            }
            if ((timeLimitStr = req.getParameter("timeLimit")) != null && timeLimitStr.length() > 0) {
                timeLimit = Integer.parseInt(timeLimitStr);
            }
            this.process(argSet, header, req.getParameter("queryRequestFilter"), authToken, maxResults, timeLimit, req, resp, locale[0]);
        }
        catch (NumberFormatException e) {
            logger.warn(CMS.getLogMessage("BASE_INVALID_NUMBER_FORMAT", new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage(this.getLocale(req), "CMS_BASE_INVALID_NUMBER_FORMAT", new String[0]), (Throwable)e);
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_OUT_STREAM_TEMPLATE", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, String filter, AuthToken token, int maxResults, int timeLimit, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws EBaseException {
        try {
            long startTime = new Date().getTime();
            if (filter.indexOf(CURRENT_TIME, 0) > -1) {
                filter = this.insertCurrentTime(filter);
            }
            String owner = req.getParameter("owner");
            Object requestowner_filter = "";
            Object newfilter = "";
            if (owner.length() == 0) {
                newfilter = filter;
            } else {
                if (owner.equals("self")) {
                    String self_uid = token.getInString("userid");
                    requestowner_filter = "(requestowner=" + self_uid + ")";
                } else {
                    String uid = req.getParameter("uid");
                    requestowner_filter = "(requestowner=" + uid + ")";
                }
                newfilter = "(&" + (String)requestowner_filter + filter.substring(2);
            }
            if (maxResults == -1 || maxResults > this.mMaxReturns) {
                logger.debug("Resetting maximum of returned results from " + maxResults + " to " + this.mMaxReturns);
                maxResults = this.mMaxReturns;
            }
            if (timeLimit == -1 || timeLimit > this.mTimeLimits) {
                logger.debug("Resetting timelimit from " + timeLimit + " to " + this.mTimeLimits);
                timeLimit = this.mTimeLimits;
            }
            RequestList list = timeLimit > 0 ? this.requestRepository.listRequestsByFilter((String)newfilter, maxResults, timeLimit) : this.requestRepository.listRequestsByFilter((String)newfilter, maxResults);
            int count = 0;
            while (list != null && list.hasMoreElements()) {
                Request request = list.nextRequestObject();
                if (request == null) continue;
                ArgBlock rarg = new ArgBlock();
                this.mParser.fillRequestIntoArg(locale, request, argSet, rarg);
                argSet.addRepeatRecord(rarg);
                long endTime = new Date().getTime();
                header.addIntegerValue(OUT_CURRENTCOUNT, ++count);
                header.addStringValue("time", Long.toString(endTime - startTime));
            }
            header.addIntegerValue(OUT_TOTALCOUNT, count);
        }
        catch (EBaseException e) {
            CMS.getLogMessage("CMSGW_ERROR_LISTCERTS", e.toString());
            throw e;
        }
    }

    private String insertCurrentTime(String filter) {
        Date now = null;
        StringBuffer newFilter = new StringBuffer();
        int k = 0;
        int i = filter.indexOf(CURRENT_TIME, k);
        while (i > -1) {
            if (now == null) {
                now = new Date();
            }
            newFilter.append(filter.substring(k, i));
            newFilter.append(now.getTime());
            k = i + CURRENT_TIME.length();
            i = filter.indexOf(CURRENT_TIME, k);
        }
        if (k > 0) {
            newFilter.append(filter.substring(k, filter.length()));
        }
        return newFilter.toString();
    }
}

