/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateNumberRange
extends CMSServlet {
    public static final Logger logger = LoggerFactory.getLogger(UpdateNumberRange.class);
    private static final String SUCCESS = "0";
    private static final String AUTH_FAILURE = "2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        logger.info("UpdateNumberRange: Authenticating request");
        AuthToken authToken = this.authenticate(cmsReq);
        if (authToken == null) {
            logger.error("UpdateNumberRange: Authentication failed");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Authentication failed", null);
            return;
        }
        logger.info("UpdateNumberRange: Authorizing request");
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "modify");
        }
        catch (Exception e) {
            logger.error("UpdateNumberRange: Authorization failed: " + e.getMessage(), (Throwable)e);
            this.outputError(httpResp, "Error: Authorization failed");
            return;
        }
        if (authzToken == null) {
            logger.error("UpdateNumberRange: Authorization failed");
            this.outputError(httpResp, "Error: Authorization failed");
            return;
        }
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        Object auditParams = "source;;updateNumberRange";
        try {
            String type = httpReq.getParameter("type");
            logger.info("UpdateNumberRange: Type: " + type);
            EngineConfig cs = engine.getConfig();
            DatabaseConfig dbConfig = cs.getDatabaseConfig();
            String cstype = cs.getType();
            auditParams = (String)auditParams + "+type;;" + type;
            logger.info("UpdateNumberRange: Getting " + type + " repository");
            Repository repo = this.getRepository(type);
            if (type.equals("replicaId")) {
                logger.debug("UpdateNumberRange: Checking replica number ranges");
                repo.checkRanges();
            }
            int radix = 10;
            String endNumConfig = null;
            String cloneNumConfig = null;
            String nextEndConfig = null;
            if (type.equals("request")) {
                radix = 10;
                endNumConfig = "endRequestNumber";
                cloneNumConfig = "requestCloneTransferNumber";
                nextEndConfig = "nextEndRequestNumber";
            } else if (type.equals("serialNo")) {
                radix = 16;
                endNumConfig = "endSerialNumber";
                cloneNumConfig = "serialCloneTransferNumber";
                nextEndConfig = "nextEndSerialNumber";
            } else if (type.equals("replicaId")) {
                radix = 10;
                endNumConfig = "endReplicaNumber";
                cloneNumConfig = "replicaCloneTransferNumber";
                nextEndConfig = "nextEndReplicaNumber";
            }
            String endNumStr = dbConfig.getString(endNumConfig);
            BigInteger endNum = new BigInteger(endNumStr, radix);
            logger.info("UpdateNumberRange: dbs." + endNumConfig + ": " + endNum);
            String transferSizeStr = dbConfig.getString(cloneNumConfig, "");
            BigInteger transferSize = new BigInteger(transferSizeStr, radix);
            logger.info("UpdateNumberRange: dbs." + cloneNumConfig + ": " + transferSize);
            BigInteger beginNum = endNum.subtract(transferSize).add(BigInteger.ONE);
            logger.info("UpdateNumberRange: Begin number: " + beginNum);
            Repository repository = repo;
            synchronized (repository) {
                BigInteger nextSerial = repo.peekNextSerialNumber();
                if (nextSerial == null) {
                    String msg = "Current range depleted but no next range available.";
                    logger.error(msg);
                    throw new RuntimeException(msg);
                }
                logger.info("Configured transfer size: " + transferSize);
                logger.info("UpdateNumberRange: Current range: " + nextSerial + ".." + endNum);
                logger.info("UpdateNumberRange: Size: " + endNum.subtract(nextSerial).add(BigInteger.ONE));
                if (beginNum.compareTo(nextSerial) < 0) {
                    endNum = new BigInteger(dbConfig.getString(nextEndConfig, ""), radix);
                    BigInteger newEndNum = endNum.subtract(transferSize);
                    logger.info("UpdateNumberRange: Transferring from the end of next range");
                    logger.info("UpdateNumberRange:   Next range current end: " + endNum);
                    logger.info("UpdateNumberRange:   Next range new end: " + newEndNum);
                    repo.setNextMaxSerial(newEndNum);
                    dbConfig.putString(nextEndConfig, newEndNum.toString(radix));
                    beginNum = newEndNum.add(BigInteger.ONE);
                } else {
                    logger.info("UpdateNumberRange: Transferring from the end of the current range");
                    BigInteger newEndNum = beginNum.subtract(BigInteger.ONE);
                    repo.setMaxSerial(newEndNum);
                    String newValStr = newEndNum.toString(radix);
                    dbConfig.putString(endNumConfig, newValStr);
                    logger.info("UpdateNumberRange: New current range: " + nextSerial + ".." + newEndNum);
                }
                logger.info("UpdateNumberRange: Transferring range: " + beginNum + ".." + endNum);
            }
            if (beginNum == null) {
                logger.error("UpdateNumberRange: Missing begin number");
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_SERIAL_NUMBER_1", auditSubjectID, "Failure", auditParams);
                auditor.log(auditMessage);
                return;
            }
            if (type.equals("replicaId")) {
                repo.setEnableSerialMgmt(true);
            }
            logger.debug("UpdateNumberRange: Sending response");
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            responseNode.put("Status", SUCCESS);
            responseNode.put("beginNumber", beginNum.toString(radix));
            responseNode.put("endNumber", endNum.toString(radix));
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
            cs.commit(false);
            auditParams = (String)auditParams + "+beginNumber;;" + beginNum.toString(radix) + "+endNumber;;" + endNum.toString(radix);
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_SERIAL_NUMBER_1", auditSubjectID, "Success", auditParams);
            auditor.log(auditMessage);
        }
        catch (Exception e) {
            logger.error("UpdateNumberRange: Unable to update number range: " + e.getMessage(), (Throwable)e);
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_SERIAL_NUMBER_1", auditSubjectID, "Failure", auditParams);
            auditor.log(auditMessage);
            this.outputError(httpResp, "Error: Unable to update number range: " + e.getMessage());
        }
    }

    public abstract Repository getRepository(String var1) throws EBaseException;

    @Override
    protected void setDefaultTemplates(ServletConfig sc) {
    }

    @Override
    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

