/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckIdentity
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(CheckIdentity.class);
    private static final long serialVersionUID = 1647682040815275807L;
    private static final String SUCCESS = "0";

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        logger.debug("CheckIdentity init");
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        try {
            this.authenticate(cmsReq);
        }
        catch (Exception e) {
            logger.warn("CheckIdentity authentication failed: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage("CMSGW_ERR_BAD_SERV_OUT_STREAM", "", e.toString()));
            this.outputError(httpResp, "Error: Not authenticated");
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            responseNode.put("Status", SUCCESS);
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("Failed to send the output: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }
}

