/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.cms.servlet.base.ProxyWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    public static Logger logger = LoggerFactory.getLogger(ProxyServlet.class);
    private static final long serialVersionUID = -2535349161521094539L;
    private String mDest = null;
    private String mDestContext = null;
    private String mSrcContext = null;
    private String mAppendPathInfo = null;
    private Vector<String> mMatchStrings = new Vector();
    private String mDestServletOnNoMatch = null;
    private String mAppendPathInfoOnNoMatch = null;
    private Map<String, String> mParamMap = new HashMap<String, String>();
    private Map<String, String[]> mParamValue = new HashMap<String, String[]>();

    private void parseParamTable(String s) {
        if (s == null) {
            return;
        }
        String[] params = s.split(",");
        for (int i = 0; i < params.length; ++i) {
            String p = params[i];
            if (p == null) continue;
            String[] paramNames = p.split("->");
            if (paramNames.length != 2) {
                // empty if block
            }
            String from = paramNames[0];
            String to = paramNames[1];
            if (from == null || to == null) continue;
            String[] splitTo = to.split("=");
            String toName = splitTo[0];
            if (from.length() > 0) {
                this.mParamMap.put(from, toName);
            }
            if (splitTo.length != 2) continue;
            String toValue = splitTo[1];
            String[] toValues = new String[]{toValue};
            this.mParamValue.put(toName, toValues);
        }
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        String mMatchStrs = sc.getInitParameter("matchURIStrings");
        if (mMatchStrs != null && !mMatchStrs.equals("")) {
            StringTokenizer st = new StringTokenizer(mMatchStrs, ",");
            while (st.hasMoreTokens()) {
                this.mMatchStrings.addElement(st.nextToken());
            }
        }
        this.mDestServletOnNoMatch = sc.getInitParameter("destServletOnNoMatch");
        this.mDestContext = sc.getInitParameter("destContext");
        this.mDest = sc.getInitParameter("destServlet");
        this.mSrcContext = sc.getInitParameter("srcContext");
        this.mAppendPathInfo = sc.getInitParameter("appendPathInfo");
        this.mAppendPathInfoOnNoMatch = sc.getInitParameter("appendPathInfoOnNoMatch");
        String map = sc.getInitParameter("parameterMap");
        if (map != null) {
            this.parseParamTable(map);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        RequestDispatcher dispatcher = null;
        Object dest = this.mDest;
        String uri = req.getRequestURI();
        if (this.mMatchStrings.size() != 0) {
            boolean matched = false;
            for (int i = 0; i < this.mMatchStrings.size(); ++i) {
                String t = this.mMatchStrings.elementAt(i);
                if (uri.indexOf(t) == -1) continue;
                matched = true;
            }
            if (!matched) {
                dest = this.mDestServletOnNoMatch;
                if (this.mAppendPathInfoOnNoMatch != null && !this.mAppendPathInfoOnNoMatch.equals("")) {
                    dest = (String)dest + uri.replace(this.mAppendPathInfoOnNoMatch, "");
                }
            }
        }
        if (dest == null || ((String)dest).equals("")) {
            dest = uri;
            dest = ((String)dest).replaceFirst(this.mSrcContext, "");
        }
        if (this.mAppendPathInfo != null && !this.mAppendPathInfo.equals("")) {
            dest = (String)dest + uri.replace(this.mAppendPathInfo, "");
        }
        dispatcher = this.mDestContext != null && !this.mDestContext.equals("") ? this.getServletContext().getContext(this.mDestContext).getRequestDispatcher((String)dest) : req.getRequestDispatcher((String)dest);
        if (this.mParamMap != null && !this.mParamMap.isEmpty()) {
            ProxyWrapper r = new ProxyWrapper((HttpServletRequest)req);
            r.setParameterMapAndValue(this.mParamMap, this.mParamValue);
            req = r;
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }
}

