/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.realm;

import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.realm.RealmCommon;
import com.netscape.cmscore.usrgrp.User;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.catalina.LifecycleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIInMemoryRealm
extends RealmCommon {
    public static final Logger logger = LoggerFactory.getLogger(PKIInMemoryRealm.class);
    String username;
    String password;
    User user;
    List<String> roles;

    public void initInternal() throws LifecycleException {
        this.username = this.config.getParameter("username");
        this.password = this.config.getParameter("password");
        String roleList = this.config.getParameter("roles");
        this.user = new User();
        this.user.setUserID(this.username);
        this.user.setFullName("Administrator");
        if (roleList == null) {
            this.roles = new ArrayList<String>();
            this.roles.add("Administrators");
        } else {
            this.roles = Stream.of(roleList.split(",")).map(String::trim).collect(Collectors.toList());
        }
    }

    @Override
    public Principal authenticate(String username, String password) {
        logger.info("Authenticating user " + username + " with password");
        if (!this.username.equals(username)) {
            logger.warn("Unable to authenticate user " + username + ": User not found");
            return null;
        }
        if (!this.password.equals(password)) {
            logger.warn("Unable to authenticate user " + username + ": Invalid password");
            return null;
        }
        logger.info("User " + username + " authenticated");
        return new PKIPrincipal(this.user, null, this.roles);
    }
}

