/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.logging;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.ELogException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.cms.logging.LogFile;
import com.netscape.cms.logging.fileFilter;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.logging.LoggerConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletException;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingLogFile
extends LogFile {
    public static Logger logger = LoggerFactory.getLogger(RollingLogFile.class);
    static final int MAX_FILE_SIZE = 100;
    static final String ROLLOVER_INTERVAL = "2592000";
    static final String EXPIRATION_TIME = "0";
    protected int mMaxFileSize = 0;
    protected long mRolloverInterval = 0L;
    private Thread mRolloverThread = null;
    protected long mExpirationTime = 0L;
    private Thread mExpirationThread = null;
    private Object mExpLock = new Object();

    @Override
    public void init(LoggerConfig config) throws IOException, EBaseException {
        super.init(config);
        this.rl_init(config.getInteger("maxFileSize", 100), config.getString("rolloverInterval", ROLLOVER_INTERVAL), config.getString("expirationTime", EXPIRATION_TIME));
    }

    protected void rl_init(int maxFileSize, String rolloverInterval, String expirationTime) {
        this.mMaxFileSize = maxFileSize * 1024;
        this.setRolloverTime(rolloverInterval);
        this.setExpirationTime(expirationTime);
    }

    @Override
    public void startup() throws EBaseException {
        super.startup();
    }

    @Override
    public synchronized void shutdown() {
        logger.debug("Destroying RollingLogFile(" + this.mFileName + ")");
        this.setRolloverTime(EXPIRATION_TIME);
        this.setExpirationTime(EXPIRATION_TIME);
        super.shutdown();
    }

    public synchronized void setRolloverTime(String rolloverSeconds) {
        this.mRolloverInterval = Long.valueOf(rolloverSeconds) * 1000L;
        if (this.mRolloverThread == null && this.mRolloverInterval > 0L) {
            this.mRolloverThread = new RolloverThread();
            this.mRolloverThread.setDaemon(true);
            this.mRolloverThread.start();
        } else if (this.mRolloverThread != null && this.mRolloverInterval == 0L) {
            this.mRolloverThread.interrupt();
        }
        this.notify();
    }

    public synchronized int getRolloverTime() {
        return (int)(this.mRolloverInterval / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpirationTime(String expirationSeconds) {
        Object object = this.mExpLock;
        synchronized (object) {
            this.mExpirationTime = Long.valueOf(expirationSeconds) * 1000L;
            if (this.mExpirationThread == null) {
                if (this.mExpirationTime > 0L) {
                    this.mExpirationThread = new ExpirationThread();
                    this.mExpirationThread.setDaemon(true);
                    this.mExpirationThread.start();
                }
            } else if (this.mExpirationThread != null && this.mExpirationTime == 0L) {
                this.mExpirationThread.interrupt();
            } else {
                this.mExpLock.notify();
            }
        }
    }

    public int getExpirationTime() {
        return (int)(this.mExpirationTime / 1000L);
    }

    public synchronized void rotate() throws IOException {
        block9: {
            File backupFile = new File(this.mFileName + "." + this.mLogFileDateFormat.format(this.mDate));
            super.close();
            try {
                if (Utils.isNT()) {
                    Utils.exec((String)("copy " + this.mFile.getCanonicalPath().replace('/', '\\') + " " + backupFile.getCanonicalPath().replace('/', '\\')));
                } else {
                    Utils.exec((String)("cp -p " + this.mFile.getCanonicalPath() + " " + backupFile.getCanonicalPath()));
                }
                if (backupFile.exists()) {
                    if (!Utils.isNT()) {
                        Utils.exec((String)("chmod 00640 " + backupFile.getCanonicalPath()));
                    }
                    try {
                        PrintWriter pw = new PrintWriter(this.mFile);
                        pw.close();
                        if (!Utils.isNT()) {
                            Utils.exec((String)("chmod 00640 " + this.mFile.getCanonicalPath()));
                        }
                        break block9;
                    }
                    catch (FileNotFoundException e) {
                        logger.warn("Unable to zeroize " + this.mFile + ": " + e.getMessage(), (Throwable)e);
                    }
                    break block9;
                }
                logger.warn("Unable to backup " + this.mFile + " to " + backupFile);
            }
            catch (Exception e) {
                logger.warn("Unable to backup " + this.mFile + " to " + backupFile + ": " + e.getMessage(), (Throwable)e);
            }
        }
        super.open();
    }

    public long expire(long expirationSeconds) throws ELogException {
        long currentTime;
        String auditMessage = null;
        if (expirationSeconds <= 0L) {
            throw new ELogException(CMS.getUserMessage("CMS_LOG_EXPIRATION_TIME_ZERO", new String[0]));
        }
        long expirationTime = expirationSeconds * 1000L;
        long oldestFile = currentTime = System.currentTimeMillis();
        String dirName = this.mFile.getParent();
        if (dirName == null) {
            dirName = ".";
        }
        File dir = new File(dirName);
        String fileName = this.mFile.getName();
        String baseName = null;
        String pathName = null;
        int index = fileName.lastIndexOf("/");
        if (index != -1) {
            pathName = fileName.substring(0, index);
            baseName = fileName.substring(index + 1);
            dirName = dirName.concat("/" + pathName);
        } else {
            baseName = fileName;
        }
        fileFilter ff = new fileFilter(baseName + ".");
        String[] filelist = dir.list(ff);
        if (filelist == null) {
            throw new ELogException(CMS.getUserMessage("CMS_LOG_DIRECTORY_LIST_FAILED", dirName, ff.toString()));
        }
        Auditor auditor = this.engine.getAuditor();
        for (int i = 0; i < filelist.length; ++i) {
            filelist[i] = pathName != null ? pathName + "/" + filelist[i] : dirName + "/" + filelist[i];
            String fullname = dirName + File.separatorChar + filelist[i];
            File file = new File(fullname);
            long fileTime = file.lastModified();
            if (currentTime - fileTime > expirationTime) {
                file.delete();
                auditMessage = file.exists() ? CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_DELETE_3", "$System$", "Failure", fullname) : CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_DELETE_3", "$System$", "Success", fullname);
                auditor.log(auditMessage);
                continue;
            }
            if (fileTime >= oldestFile) continue;
            oldestFile = fileTime;
        }
        return oldestFile + expirationTime;
    }

    @Override
    public synchronized void log(LogEvent ev) throws ELogException {
        super.log(ev);
        if (0 != this.mMaxFileSize && this.mBytesWritten > this.mMaxFileSize) {
            this.flush();
            try {
                this.rotate();
            }
            catch (IOException e) {
                throw new ELogException(CMS.getUserMessage("CMS_LOG_ROTATE_LOG_FAILED", this.mFile.getName(), e.toString()));
            }
        }
    }

    @Override
    public synchronized NameValuePairs retrieveLogList(Hashtable<String, String> req) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String[] files = null;
        files = this.fileList();
        for (int i = 0; i < files.length; ++i) {
            params.put((Object)files[i], (Object)"");
        }
        return params;
    }

    protected String[] fileList() {
        String pathName = null;
        String baseName = null;
        String dirName = this.mFile.getParent();
        String fileName = this.mFile.getName();
        int index = fileName.lastIndexOf("/");
        if (index != -1) {
            pathName = fileName.substring(0, index);
            baseName = fileName.substring(index + 1);
            dirName = dirName == null ? pathName : dirName.concat("/" + pathName);
        } else {
            baseName = fileName;
        }
        File dir = new File(dirName);
        fileFilter ff = new fileFilter(baseName + ".");
        String[] filelist = dir.list(ff);
        for (int i = 0; i < filelist.length; ++i) {
            filelist[i] = pathName != null ? pathName + "/" + filelist[i] : dirName + "/" + filelist[i];
        }
        return filelist;
    }

    @Override
    public String getImplName() {
        return "RollingLogFile";
    }

    @Override
    public String getDescription() {
        return "RollingLogFile";
    }

    @Override
    public Vector<String> getDefaultParams() {
        Vector<String> v = super.getDefaultParams();
        v.addElement("maxFileSize=");
        v.addElement("rolloverInterval=");
        return v;
    }

    @Override
    public Vector<String> getInstanceParams() {
        Vector<String> v = super.getInstanceParams();
        try {
            v.addElement("maxFileSize=" + this.mMaxFileSize / 1024);
            if (this.mRolloverInterval / 1000L <= 3600L) {
                v.addElement("rolloverInterval=Hourly");
            } else if (this.mRolloverInterval / 1000L <= 86400L) {
                v.addElement("rolloverInterval=Daily");
            } else if (this.mRolloverInterval / 1000L <= 604800L) {
                v.addElement("rolloverInterval=Weekly");
            } else if (this.mRolloverInterval / 1000L <= 2592000L) {
                v.addElement("rolloverInterval=Monthly");
            } else if (this.mRolloverInterval / 1000L <= 31622400L) {
                v.addElement("rolloverInterval=Yearly");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    @Override
    public String[] getExtendedPluginInfo() {
        String[] p = super.getExtendedPluginInfo();
        Vector<String> info = new Vector<String>();
        for (int i = 0; i < p.length; ++i) {
            if (p[i].startsWith("HELP_TOKEN") || p[i].startsWith("HELP_TEXT")) continue;
            info.addElement(p[i]);
        }
        info.addElement("maxFileSize;integer;If the current log file size if bigger than this parameter in kilobytes(KB), the file will be rotated.");
        info.addElement("rolloverInterval;choice(Hourly,Daily,Weekly,Monthly,Yearly);The frequency of the log being rotated.");
        info.addElement("expirationTime;integer;The amount of time before a backed up log is removed in seconds");
        info.addElement("HELP_TOKEN;configuration-adminbasics");
        info.addElement("HELP_TEXT;Write the log messages to a file which will be rotated automatically.");
        Object[] params = new String[info.size()];
        info.copyInto(params);
        return params;
    }

    final class RolloverThread
    extends Thread {
        public RolloverThread() {
            super.setName(RollingLogFile.this.mFileName + ".rollover-" + (Thread.activeCount() + 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (RollingLogFile.this.mRolloverInterval > 0L) {
                RollingLogFile rollingLogFile = RollingLogFile.this;
                synchronized (rollingLogFile) {
                    try {
                        RollingLogFile.this.wait(RollingLogFile.this.mRolloverInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (RollingLogFile.this.mRolloverInterval == 0L) break;
                if (RollingLogFile.this.mBytesWritten <= 0) continue;
                try {
                    RollingLogFile.this.rotate();
                }
                catch (IOException e) {
                    System.err.println(CMS.getUserMessage("CMS_LOG_ROTATE_LOG_FAILED", RollingLogFile.this.mFile.getName(), e.toString()));
                    break;
                }
            }
            RollingLogFile.this.mRolloverThread = null;
        }
    }

    final class ExpirationThread
    extends Thread {
        public ExpirationThread() {
            super.setName(RollingLogFile.this.mFileName + ".expiration-" + (Thread.activeCount() + 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RollingLogFile.this.mExpLock;
            synchronized (object) {
                while (RollingLogFile.this.mExpirationTime > 0L) {
                    long wakeupTime = 0L;
                    long sleepTime = 0L;
                    try {
                        wakeupTime = RollingLogFile.this.expire(RollingLogFile.this.mExpirationTime / 1000L);
                    }
                    catch (SecurityException e) {
                        System.err.println(CMS.getUserMessage("CMS_LOG_EXPIRE_LOG_FAILED", e.toString()));
                        break;
                    }
                    catch (ELogException e) {
                        System.err.println(CMS.getUserMessage("CMS_LOG_EXPIRE_LOG_FAILED", e.toString()));
                        break;
                    }
                    sleepTime = wakeupTime - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        try {
                            RollingLogFile.this.mExpLock.wait(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (RollingLogFile.this.mExpirationTime != 0L) continue;
                    break;
                }
            }
            RollingLogFile.this.mExpirationThread = null;
        }
    }
}

