/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authentication.ECompSyntaxErr;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.LdapV3DNStrConverter;

class AVAPattern {
    public static final String TYPE_ATTR = "$attr";
    public static final String TYPE_DN = "$dn";
    public static final String TYPE_RDN = "$rdn";
    public static final String TYPE_CONSTANT = "constant";
    private static final LdapV3DNStrConverter mLdapDNStrConverter = new LdapV3DNStrConverter();
    protected String[] mLdapAttrs = null;
    protected String mType = null;
    protected String mAttr = null;
    protected String mValue = null;
    protected int mElement = 0;
    protected String mTestDN = null;

    public AVAPattern(String component) throws EAuthException {
        if (component == null || component.length() == 0) {
            throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", component));
        }
        this.parse(new PushbackReader(new StringReader(component)));
    }

    public AVAPattern(PushbackReader in) throws EAuthException {
        this.parse(in);
    }

    private void parse(PushbackReader in) throws EAuthException {
        int c;
        try {
            while ((c = in.read()) == 32 || c == 9) {
            }
        }
        catch (IOException e) {
            throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "All blank"));
        }
        if (c == -1) {
            throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "All blank"));
        }
        if (c == 36) {
            this.mType = TYPE_RDN;
            try {
                if (in.read() != 114 || in.read() != 100 || in.read() != 110 || in.read() != 46) {
                    throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "Invalid $ syntax, expecting $rdn"));
                }
            }
            catch (IOException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "Invalid $ syntax, expecting $rdn"));
            }
            StringBuffer rdnNumberBuf = new StringBuffer();
            try {
                while ((c = in.read()) != 44 && c != -1 && c != 43) {
                    rdnNumberBuf.append((char)c);
                }
                if (c != -1) {
                    in.unread(c);
                }
            }
            catch (IOException e) {
                throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
            }
            String rdnNumber = rdnNumberBuf.toString().trim();
            if (rdnNumber.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "$rdn number not set in ava pattern"));
            }
            try {
                this.mElement = Integer.parseInt(rdnNumber) - 1;
            }
            catch (NumberFormatException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "Invalid $rdn number in ava pattern"));
            }
            return;
        }
        StringBuffer attrBuf = new StringBuffer();
        try {
            while (c != 61 && c != -1 && c != 44 && c != 43) {
                attrBuf.append((char)c);
                c = in.read();
            }
            if (c == 44 || c == 43) {
                in.unread(c);
            }
        }
        catch (IOException e) {
            throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
        }
        if (c != 61) {
            throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "Missing \"=\" in ava pattern"));
        }
        try {
            while ((c = in.read()) == 32 || c == 9) {
            }
        }
        catch (IOException e) {
            throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
        }
        if (c == -1) {
            throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "no value after = in ava pattern"));
        }
        if (c == 36) {
            try {
                c = in.read();
            }
            catch (IOException e) {
                throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
            }
            if (c == -1) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "expecting $dn or $attr in ava pattern"));
            }
            if (c == 97) {
                try {
                    if (in.read() != 116 || in.read() != 116 || in.read() != 114 || in.read() != 46) {
                        throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "expecting $attr in ava pattern"));
                    }
                }
                catch (IOException e) {
                    throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
                }
                this.mType = TYPE_ATTR;
            } else if (c == 100) {
                try {
                    if (in.read() != 110 || in.read() != 46) {
                        throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "expecting $dn in ava pattern"));
                    }
                }
                catch (IOException e) {
                    throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
                }
                this.mType = TYPE_DN;
            } else {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "unknown keyword. expecting $dn or $attr."));
            }
            String attrName = attrBuf.toString().trim();
            if (attrName.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "attribute name expected"));
            }
            try {
                ObjectIdentifier attrOid = mLdapDNStrConverter.parseAVAKeyword(attrName);
                this.mAttr = mLdapDNStrConverter.encodeOID(attrOid);
            }
            catch (IOException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", e.getMessage()));
            }
            StringBuffer valueBuf = new StringBuffer();
            try {
                while ((c = in.read()) != 44 && c != -1 && c != 46 && c != 43) {
                    valueBuf.append((char)c);
                }
                if (c == 43 || c == 44) {
                    in.unread(c);
                }
            }
            catch (IOException e) {
                throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
            }
            this.mValue = valueBuf.toString().trim();
            if (this.mValue.length() == 0) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "$dn or $attr attribute name expected"));
            }
            if (c == 46) {
                StringBuffer attrNumberBuf = new StringBuffer();
                try {
                    while ((c = in.read()) != 44 && c != -1 && c != 43) {
                        attrNumberBuf.append((char)c);
                    }
                    if (c != -1) {
                        in.unread(c);
                    }
                }
                catch (IOException e) {
                    throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
                }
                String attrNumber = attrNumberBuf.toString().trim();
                if (attrNumber.length() == 0) {
                    throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "nth element $dn or $attr expected"));
                }
                try {
                    this.mElement = Integer.parseInt(attrNumber) - 1;
                }
                catch (NumberFormatException e) {
                    throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", "Invalid format in nth element $dn or $attr"));
                }
            }
        } else {
            this.mType = TYPE_CONSTANT;
            StringBuffer valueBuf = new StringBuffer();
            valueBuf.append((char)c);
            try {
                while ((c = in.read()) != 44 && c != -1) {
                    valueBuf.append((char)c);
                }
                if (c == 43 || c == 44) {
                    in.unread(c);
                }
            }
            catch (IOException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", e.getMessage()));
            }
            try {
                AVA ava = mLdapDNStrConverter.parseAVA(attrBuf + "=" + valueBuf);
                this.mValue = ava.toLdapDNString();
            }
            catch (IOException e) {
                throw new ECompSyntaxErr(CMS.getUserMessage("CMS_AUTHENTICATION_COMPONENT_SYNTAX", e.getMessage()));
            }
        }
    }

    public String formAVA(LDAPEntry entry) throws EAuthException {
        if (this.mType == TYPE_CONSTANT) {
            return this.mValue;
        }
        if (this.mType == TYPE_RDN) {
            String[] rdns;
            String dn = entry.getDN();
            if (this.mTestDN != null) {
                dn = this.mTestDN;
            }
            if (this.mElement >= (rdns = LDAPDN.explodeDN((String)dn, (boolean)false)).length) {
                return null;
            }
            return rdns[this.mElement];
        }
        if (this.mType == TYPE_DN) {
            String dn = entry.getDN();
            if (this.mTestDN != null) {
                dn = this.mTestDN;
            }
            String[] rdns = LDAPDN.explodeDN((String)dn, (boolean)false);
            String value = null;
            int nFound = -1;
            block0: for (int i = 0; i < rdns.length; ++i) {
                String[] avas = AVAPattern.explodeRDN(rdns[i]);
                for (int j = 0; j < avas.length; ++j) {
                    String[] exploded = AVAPattern.explodeAVA(avas[j]);
                    if (!exploded[0].equalsIgnoreCase(this.mValue) || ++nFound != this.mElement) continue;
                    value = exploded[1];
                    continue block0;
                }
            }
            if (value == null) {
                return null;
            }
            return this.mAttr + "=" + value;
        }
        if (this.mType == TYPE_ATTR) {
            LDAPAttribute ldapAttr = entry.getAttribute(this.mValue);
            if (ldapAttr == null) {
                return null;
            }
            String value = null;
            Enumeration ldapValues = ldapAttr.getStringValues();
            int i = 0;
            while (ldapValues.hasMoreElements()) {
                String val = (String)ldapValues.nextElement();
                if (i == this.mElement) {
                    value = val;
                    break;
                }
                ++i;
            }
            if (value == null) {
                return null;
            }
            String v = this.escapeLdapString(value);
            return this.mAttr + "=" + v;
        }
        return null;
    }

    private String escapeLdapString(String value) {
        int len = value.length();
        char[] c = new char[len];
        char[] newc = new char[len * 2];
        value.getChars(0, len, c, 0);
        int j = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ',' || c[i] == '=' || c[i] == '+' || c[i] == '<' || c[i] == '>' || c[i] == '#' || c[i] == ';') {
                if (i != 0 && c[i - 1] == '\\') continue;
                newc[j++] = 92;
                newc[j++] = c[i];
                continue;
            }
            if (c[i] == '\\') {
                int k = i + 1;
                if (i != len - 1 && c[k] != ',' && c[k] != '=' && c[k] != '+' && c[k] != '<' && c[k] != '>' && c[k] != '#' && c[k] != ';') continue;
                newc[j++] = 92;
                newc[j++] = c[i];
                continue;
            }
            if (c[i] == '\"') {
                if (!(i == 0 && c[len - 1] != '\"' || i == len - 1 && c[0] != '\"') && (i <= 0 || i >= len - 1)) continue;
                newc[j++] = 92;
                newc[j++] = c[i];
                continue;
            }
            newc[j++] = c[i];
        }
        return new String(newc, 0, j);
    }

    public String getLdapAttr() {
        return this.mType == TYPE_ATTR ? this.mValue : null;
    }

    public static String[] explodeRDN(String rdn) {
        int plus = rdn.indexOf(43);
        if (plus == -1) {
            return new String[]{rdn};
        }
        Vector<String> avas = new Vector<String>();
        StringTokenizer token = new StringTokenizer(rdn, "+");
        while (token.hasMoreTokens()) {
            avas.addElement(token.nextToken());
        }
        Object[] theAvas = new String[avas.size()];
        avas.copyInto(theAvas);
        return theAvas;
    }

    public static String[] explodeAVA(String ava) {
        int equals = ava.indexOf(61);
        if (equals == -1) {
            return null;
        }
        return new String[]{ava.substring(0, equals).trim(), ava.substring(equals + 1).trim()};
    }
}

