/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.SimpleProperties;
import com.netscape.cmsutil.crypto.CryptoUtil;

public class SigningUnitConfig
extends ConfigStore {
    public SigningUnitConfig(ConfigStorage storage) {
        super(storage);
    }

    public SigningUnitConfig(String name, SimpleProperties source) {
        super(name, source);
    }

    public String getCertNickname() throws EBaseException {
        return this.getString("certnickname");
    }

    public void setCertNickname(String nickname) {
        this.putString("certnickname", nickname);
    }

    @Deprecated(since="11.3.0", forRemoval=true)
    public String getCACertNickname() throws EBaseException {
        return this.getString("cacertnickname");
    }

    @Deprecated(since="11.3.0", forRemoval=true)
    public void setCACertNickname(String nickname) {
        this.putString("cacertnickname", nickname);
    }

    public String getNewNickname() throws EBaseException {
        return this.getString("newNickname", "");
    }

    public void setNewNickname(String nickname) {
        this.putString("newNickname", nickname);
    }

    public String getTokenName() throws EBaseException {
        return this.getString("tokenname");
    }

    public void setTokenName(String tokenName) {
        this.putString("tokenname", tokenName);
    }

    public String getFullName() throws EBaseException {
        String nickname;
        try {
            nickname = this.getCertNickname();
        }
        catch (EPropertyNotFound e) {
            nickname = this.getCACertNickname();
        }
        String tokenName = this.getTokenName();
        Object fullName = CryptoUtil.isInternalToken((String)tokenName) ? nickname : tokenName + ":" + nickname;
        return fullName;
    }

    public boolean getTestSignatureFailure() throws EBaseException {
        return this.getBoolean("testSignatureFailure", false);
    }

    public String getDefaultSigningAlgorithm() throws EBaseException {
        return this.getString("defaultSigningAlgorithm");
    }

    public void setDefaultSigningAlgorithm(String algorithm) {
        this.putString("defaultSigningAlgorithm", algorithm);
    }
}

