/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tks.servlet;

import com.netscape.certsrv.base.EBaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDF {
    public static Logger logger = LoggerFactory.getLogger(KDF.class);
    static final int[] parityTable = new int[]{1, 2, 4, 7, 8, 11, 13, 14, 16, 19, 21, 22, 25, 26, 28, 31, 32, 35, 37, 38, 41, 42, 44, 47, 49, 50, 52, 55, 56, 59, 61, 62, 64, 67, 69, 70, 73, 74, 76, 79, 81, 82, 84, 87, 88, 91, 93, 94, 97, 98, 100, 103, 104, 107, 109, 110, 112, 115, 117, 118, 121, 122, 124, 127, 128, 131, 133, 134, 137, 138, 140, 143, 145, 146, 148, 151, 152, 155, 157, 158, 161, 162, 164, 167, 168, 171, 173, 174, 176, 179, 181, 182, 185, 186, 188, 191, 193, 194, 196, 199, 200, 203, 205, 206, 208, 211, 213, 214, 217, 218, 220, 223, 224, 227, 229, 230, 233, 234, 236, 239, 241, 242, 244, 247, 248, 251, 253, 254};

    public static byte[] getDiversificationData_EMV(byte[] context, String type) throws EBaseException {
        String method = "KDF.getDiversificationData_EMV:";
        logger.debug(method + " entering ...");
        if (context == null || type == null) {
            throw new EBaseException(method + "Invalid input parameters!");
        }
        byte[] KDC = new byte[]{context[4], context[5], context[6], context[7], context[8], context[9], -16, 1, context[4], context[5], context[6], context[7], context[8], context[9], 15, 1};
        if (type.equals("enc")) {
            return KDC;
        }
        KDC[7] = 2;
        KDC[15] = 2;
        if (type.equals("mac")) {
            return KDC;
        }
        KDC[7] = 3;
        KDC[15] = 3;
        if (type.equals("kek")) {
            return KDC;
        }
        KDC[7] = 4;
        KDC[15] = 4;
        if (type.equals("rmac")) {
            return KDC;
        }
        return KDC;
    }

    public static byte[] getDiversificationData_VISA2(byte[] context, String type) throws EBaseException {
        String method = "KDF.getDiversificationData_VISA2:";
        logger.debug(method + " entering ...");
        if (context == null || type == null) {
            throw new EBaseException(method + "Invalid input parameters!");
        }
        byte[] KDC = new byte[]{context[0], context[1], context[4], context[5], context[6], context[7], -16, 1, context[0], context[1], context[4], context[5], context[6], context[7], 15, 1};
        if (type.equals("enc")) {
            return KDC;
        }
        KDC[6] = -16;
        KDC[7] = 2;
        KDC[14] = 15;
        KDC[15] = 2;
        if (type.equals("mac")) {
            return KDC;
        }
        KDC[6] = -16;
        KDC[7] = 3;
        KDC[14] = 15;
        KDC[15] = 3;
        if (type.equals("kek")) {
            return KDC;
        }
        return KDC;
    }

    public static byte[] getDesParity(byte[] key) throws EBaseException {
        String method = "KDF.getDesParity";
        if (key == null || key.length != 16 && key.length != 8 && key.length != 24) {
            throw new EBaseException(method + " Incorrect input key !");
        }
        byte[] desKey = new byte[key.length];
        for (int i = 0; i < key.length; ++i) {
            byte val;
            int index = key[i] & 0xFF;
            int finalIndex = index >> 1;
            desKey[i] = val = (byte)parityTable[finalIndex];
        }
        logger.debug(method + "desKey: len: " + desKey.length);
        return desKey;
    }
}

