/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.selftests.tks;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.dogtagpki.server.tks.TKSEngine;
import org.dogtagpki.server.tks.TKSEngineConfig;
import org.dogtagpki.server.tks.TPSConnectorConfig;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.symkey.SessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSKnownSessionKey
extends SelfTest {
    public static Logger logger = LoggerFactory.getLogger(TKSKnownSessionKey.class);
    public static final String PROP_TKS_SUB_ID = "TksSubId";
    private String mTksSubId = null;
    private String mToken = null;
    private String mUseSoftToken = null;
    private String mKeyName = null;
    private byte[] mKeyInfo = null;
    private byte[] mCardChallenge = null;
    private byte[] mHostChallenge = null;
    private byte[] mCUID = null;
    private byte[] mMacKey = null;
    private byte[] mSessionKey = null;
    private byte mNistSP800_108KdfOnKeyVersion = 0;
    private boolean mNistSP800_108KdfUseCuidAsKdd = false;
    private byte[] mKDD = null;

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        block15: {
            ConfigStore tksConfig;
            short nistSP800_108KdfOnKeyVersion_short;
            super.initSelfTest(subsystem, instanceName, parameters);
            TKSEngine engine = TKSEngine.getInstance();
            this.mTksSubId = this.getConfigString(PROP_TKS_SUB_ID);
            this.mToken = this.getConfigString("token");
            this.mKeyName = this.getConfigString("keyName");
            this.mCardChallenge = this.getConfigByteArray("cardChallenge", 8);
            this.mHostChallenge = this.getConfigByteArray("hostChallenge", 8);
            this.mKeyInfo = this.getConfigByteArray("keyName", 2);
            this.mCUID = this.getConfigByteArray("CUID", 10);
            this.mMacKey = this.getConfigByteArray("macKey", 16);
            this.mUseSoftToken = this.getConfigString("useSoftToken");
            this.mKDD = this.getConfigByteArray("CUID", 10);
            String nistSP800_108KdfOnKeyVersion_str = this.getConfigString("nistSP800-108KdfOnKeyVersion");
            try {
                nistSP800_108KdfOnKeyVersion_short = Short.parseShort(nistSP800_108KdfOnKeyVersion_str, 16);
                if (nistSP800_108KdfOnKeyVersion_short < 0 || nistSP800_108KdfOnKeyVersion_short > 255) {
                    throw new Exception("Out of range.");
                }
            }
            catch (Throwable t) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".nistSP800-108KdfOnKeyVersion"}));
                throw new EMissingSelfTestException("nistSP800-108KdfOnKeyVersion");
            }
            this.mNistSP800_108KdfOnKeyVersion = (byte)nistSP800_108KdfOnKeyVersion_short;
            String nistSP800_108KdfUseCuidAsKdd_str = this.getConfigString("nistSP800-108KdfUseCuidAsKdd");
            try {
                this.mNistSP800_108KdfUseCuidAsKdd = Boolean.parseBoolean(nistSP800_108KdfUseCuidAsKdd_str);
            }
            catch (Throwable t) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".nistSP800-108KdfUseCuidAsKdd"}));
                throw new EMissingSelfTestException("nistSP800-108KdfUseCuidAsKdd");
            }
            String defKeySetMacKey = null;
            Subsystem tks = engine.getSubsystem(this.mTksSubId);
            if (tks != null && (tksConfig = tks.getConfigStore()) != null) {
                try {
                    defKeySetMacKey = tksConfig.getString("defKeySet.mac_key");
                    byte[] defMacKey = Utils.SpecialDecode((String)defKeySetMacKey);
                    if (!Arrays.equals(this.mMacKey, defMacKey)) {
                        defKeySetMacKey = null;
                    }
                }
                catch (EBaseException e) {
                    defKeySetMacKey = null;
                }
            }
            if (defKeySetMacKey == null) {
                logger.error("TKSKnownSessionKey: invalid mac key");
                logger.error("TKSKnownSessionKey self test FAILED");
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_INVALID_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".macKey"}));
                throw new EInvalidSelfTestException(this.mPrefix, "macKey", null);
            }
            try {
                this.mSessionKey = this.getConfigByteArray("sessionKey", 16);
            }
            catch (EMissingSelfTestException e) {
                if (this.mSessionKey != null) break block15;
                this.mSessionKey = SessionKey.ComputeSessionKey((String)this.mToken, (String)this.mKeyName, (byte[])this.mCardChallenge, (byte[])this.mHostChallenge, (byte[])this.mKeyInfo, (byte)this.mNistSP800_108KdfOnKeyVersion, (boolean)this.mNistSP800_108KdfUseCuidAsKdd, (byte[])this.mCUID, (byte[])this.mKDD, (byte[])this.mMacKey, (String)this.mUseSoftToken, null, null);
                if (this.mSessionKey == null || this.mSessionKey.length != 16) {
                    this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".sessionKey"}));
                    throw new EMissingSelfTestException("sessionKey");
                }
                String sessionKey = this.SpecialEncode(this.mSessionKey);
                this.mConfig.putString("sessionKey", sessionKey);
                try {
                    engine.getConfigStore().commit(true);
                }
                catch (EBaseException be) {
                    this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".sessionKey"}));
                    throw new EMissingSelfTestException("sessionKey");
                }
            }
        }
    }

    private String SpecialEncode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append("#");
            if ((data[i] & 0xFF) < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(data[i] & 0xFF));
        }
        return sb.toString();
    }

    private String getConfigString(String name) throws EMissingSelfTestException {
        String value = null;
        try {
            value = this.mConfig.getString(name);
            if (value == null) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + "." + name}));
                throw new EMissingSelfTestException(name);
            }
            value = value.trim();
        }
        catch (EBaseException e) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + "." + name}));
            throw new EMissingSelfTestException(this.mPrefix, name, null);
        }
        return value;
    }

    private byte[] getConfigByteArray(String name, int size) throws EMissingSelfTestException, EInvalidSelfTestException {
        String stringValue = this.getConfigString(name);
        byte[] byteValue = Utils.SpecialDecode((String)stringValue);
        if (byteValue == null) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + "." + name}));
            throw new EMissingSelfTestException(name);
        }
        if (byteValue.length != size) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_INVALID_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + "." + name}));
            throw new EInvalidSelfTestException(this.mPrefix, name, stringValue);
        }
        return byteValue;
    }

    public void startupSelfTest() throws ESelfTestException {
    }

    public void shutdownSelfTest() {
    }

    public String getSelfTestName() {
        return super.getSelfTestName();
    }

    public ConfigStore getSelfTestConfigStore() {
        return super.getSelfTestConfigStore();
    }

    public String getSelfTestDescription(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_SELFTESTS_TKS_PRESENCE_DESCRIPTION", (String[])new String[0]);
    }

    public void runSelfTest(LogEventListener listener) throws Exception {
        TKSEngine engine = TKSEngine.getInstance();
        TKSEngineConfig cs = engine.getConfig();
        try {
            boolean useNewNames = cs.getBoolean("tks.useNewSharedSecretNames", false);
            if (useNewNames) {
                Collection<String> tpsList = cs.getTPSConnectorIDs();
                if (tpsList.isEmpty()) {
                    logger.warn("TKSKnownSessionKey: no shared secrets configured, exiting");
                    return;
                }
                for (String tpsID : tpsList) {
                    TPSConnectorConfig tpsConfig = cs.getTPSConnectorConfig(tpsID);
                    String sharedSecretName = tpsConfig.getNickname();
                    if (sharedSecretName.isEmpty()) continue;
                    logger.debug("TKSKnownSessionKey: testing with key " + sharedSecretName);
                    this.generateSessionKey(sharedSecretName);
                }
            } else {
                String sharedSecretName = cs.getString("tks.tksSharedSymKeyName", "sharedSecret");
                this.generateSessionKey(sharedSecretName);
            }
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TKS_SUCCEEDED", (Object[])new Object[]{this.getSelfTestName(), this.getSelfTestName()});
            this.mSelfTestSubsystem.log(listener, logMessage);
            logger.debug("TKSKnownSessionKey self test SUCCEEDED");
        }
        catch (Exception e) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TKS_FAILED", (Object[])new Object[]{this.getSelfTestName(), this.getSelfTestName()});
            this.mSelfTestSubsystem.log(listener, logMessage);
            throw e;
        }
    }

    private void generateSessionKey(String sharedSecretName) throws Exception {
        String keySet = "defKeySet";
        byte[] sessionKey = SessionKey.ComputeSessionKey((String)this.mToken, (String)this.mKeyName, (byte[])this.mCardChallenge, (byte[])this.mHostChallenge, (byte[])this.mKeyInfo, (byte)this.mNistSP800_108KdfOnKeyVersion, (boolean)this.mNistSP800_108KdfUseCuidAsKdd, (byte[])this.mCUID, (byte[])this.mKDD, (byte[])this.mMacKey, (String)this.mUseSoftToken, (String)keySet, (String)sharedSecretName);
        if (sessionKey == null) {
            logger.error("TKSKnownSessionKey: generated no session key");
            throw new Exception("No session key generated");
        }
    }
}

