/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.request.CMSRequestInfos;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestNotFoundException;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.cert.CertRequestInfoFactory;
import com.netscape.cms.servlet.cert.CertReviewResponseFactory;
import com.netscape.cms.servlet.cert.EnrollmentProcessor;
import com.netscape.cms.servlet.cert.RenewalProcessor;
import com.netscape.cms.servlet.cert.RequestProcessor;
import com.netscape.cms.servlet.request.CMSRequestDAO;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRequestDAO
extends CMSRequestDAO {
    public static Logger logger = LoggerFactory.getLogger(CertRequestDAO.class);
    ProfileSubsystem ps;
    private SecureRandom random = null;
    public static final String ATTR_SERIALNO = "serialNumber";

    public CertRequestDAO() {
        CAEngine engine = CAEngine.getInstance();
        this.requestRepository = engine.getRequestRepository();
        this.queue = engine.getRequestQueue();
        if (engine.getEnableNonces()) {
            JssSubsystem jssSubsystem = engine.getJSSSubsystem();
            this.random = jssSubsystem.getRandomNumberGenerator();
        }
        this.ps = engine.getProfileSubsystem();
    }

    public CertRequestInfos listRequests(String filter, RequestId start, int pageSize, int maxResults, int maxTime, UriInfo uriInfo) throws EBaseException {
        CertRequestInfos ret = new CertRequestInfos();
        CMSRequestInfos cmsInfos = this.listCMSRequests(filter, start, pageSize, maxResults, maxTime, uriInfo);
        ret.setTotal(cmsInfos.getTotal());
        Collection cmsList = cmsInfos.getEntries();
        List list = (List)cmsList;
        ret.setEntries((Collection)list);
        return ret;
    }

    public CertRequestInfo getRequest(RequestId id, UriInfo uriInfo) throws EBaseException {
        Request request = this.requestRepository.readRequest(id);
        if (request == null) {
            return null;
        }
        CertRequestInfo info = this.createCMSRequestInfo(request, uriInfo);
        return info;
    }

    public CertReviewResponse reviewRequest(HttpServletRequest servletRequest, RequestId id, UriInfo uriInfo, Locale locale) throws EBaseException {
        Request request = this.requestRepository.readRequest(id);
        if (request == null) {
            return null;
        }
        String profileId = request.getExtDataInString("profileId");
        CAEngine engine = CAEngine.getInstance();
        Profile profile = this.ps.getProfile(profileId);
        CertReviewResponse info = CertReviewResponseFactory.create(request, profile, uriInfo, locale);
        if (engine.getEnableNonces()) {
            long n = this.random.nextLong();
            logger.info("CertRequestDAO: Nonce: " + n);
            Map<Object, Long> nonces = engine.getNonces(servletRequest, "cert-request");
            nonces.put(info.getRequestId().toBigInteger(), n);
            info.setNonce(Long.toString(n));
        }
        return info;
    }

    public CertRequestInfos submitRequest(AuthorityID aid, CertEnrollmentRequest data, HttpServletRequest request, UriInfo uriInfo, Locale locale) throws Exception {
        Request[] reqs;
        String password;
        CertRequestInfos ret = new CertRequestInfos();
        AuthCredentials credentials = new AuthCredentials();
        String uid = data.getAttribute("uid");
        if (uid != null) {
            credentials.set("uid", (Object)uid);
        }
        if ((password = data.getAttribute("pwd")) != null) {
            credentials.set("pwd", (Object)password);
        }
        CAEngine engine = CAEngine.getInstance();
        HashMap<String, Object> results = null;
        if (data.isRenewal()) {
            processor = new RenewalProcessor("caProfileSubmit", locale);
            processor.setCMSEngine(engine);
            processor.init();
            results = ((RenewalProcessor)processor).processRenewal(data, request, credentials);
        } else {
            processor = new EnrollmentProcessor("caProfileSubmit", locale);
            processor.setCMSEngine(engine);
            processor.init();
            results = ((EnrollmentProcessor)processor).processEnrollment(data, request, aid, credentials);
        }
        for (Request req : reqs = (Request[])results.get("requests")) {
            try {
                CertRequestInfo info = CertRequestInfoFactory.create(req, uriInfo);
                ret.addEntry((Object)info);
            }
            catch (NoSuchMethodException e) {
                logger.warn("Error in creating certrequestinfo - no such method: " + e.getMessage(), (Throwable)e);
            }
        }
        ret.setTotal(ret.getEntries().size());
        return ret;
    }

    public void changeRequestState(RequestId id, HttpServletRequest request, CertReviewResponse data, Locale locale, String op) throws EBaseException {
        Request ireq = this.requestRepository.readRequest(id);
        if (ireq == null) {
            throw new RequestNotFoundException(id);
        }
        CAEngine engine = CAEngine.getInstance();
        RequestProcessor processor = new RequestProcessor("caProfileProcess", locale);
        processor.setCMSEngine(engine);
        processor.init();
        AuthToken authToken = null;
        Principal principal = request.getUserPrincipal();
        if (principal instanceof PKIPrincipal) {
            logger.debug("CertRequestDAO: getting auth token from user principal");
            authToken = ((PKIPrincipal)principal).getAuthToken();
        }
        String authMgr = processor.getAuthenticationManager();
        if (authToken == null && authMgr != null) {
            logger.debug("CertRequestDAO: getting auth token from " + authMgr);
            authToken = processor.authenticate(request);
        }
        logger.debug("CertRequestDAO: auth token: " + authToken);
        processor.processRequest(request, authToken, data, ireq, op);
    }

    public CertRequestInfo createCMSRequestInfo(Request request, UriInfo uriInfo) {
        try {
            return CertRequestInfoFactory.create(request, uriInfo);
        }
        catch (NoSuchMethodException e) {
            logger.warn("Error in creating certrequestinfo - no such method: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

