/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.job;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.jobs.Job;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestRepository;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class PruningJob
extends Job
implements IExtendedPluginInfo {
    int certRetentionTime;
    int certRetentionUnit;
    int certSearchSizeLimit;
    int certSearchTimeLimit;
    int requestRetentionTime;
    int requestRetentionUnit;
    int requestSearchSizeLimit;
    int requestSearchTimeLimit;
    CertificateRepository certRepository;
    RequestRepository requestRepository;

    public String[] getConfigParams() {
        return new String[]{"enabled", "cron", "certRetentionTime", "certRetentionUnit", "certSearchSizeLimit", "certSearchTimeLimit", "requestRetentionTime", "requestRetentionUnit", "requestSearchSizeLimit", "requestSearchTimeLimit"};
    }

    public String[] getExtendedPluginInfo() {
        return new String[]{"HELP_TEXT; A job that removes expired certificates and incomplete requests after the retention period", "cron;string;Format: minute hour dayOfMonth month dayOfWeek. Use '*' for 'every'. For dayOfWeek, 0 is Sunday", "enabled;boolean;Enable this plugin", "certRetentionTime;integer;Certificate retention time (default: 30)", "certRetentionUnit;integer;Certificate retention unit: year, month, day (default), hour, minute", "certSearchSizeLimit;integer;Certificate search size limit (default: 1000)", "certSearchTimeLimit;integer;Certificate search time limit in seconds (default: 0)", "requestRetentionTime;integer;Request retention time (default: 30)", "requestRetentionUnit;integer;Request retention unit: year, month, day (default), hour, minute", "requestSearchSizeLimit;integer;Request search size limit (default: 1000)", "requestSearchTimeLimit;integer;Request search time limit in seconds (default: 0)", "HELP_TOKEN;configuration-jobrules-pruningjobs"};
    }

    int parseRetentionUnit(String unit) throws EBaseException {
        if (unit.equals("year")) {
            return 1;
        }
        if (unit.equals("month")) {
            return 2;
        }
        if (unit.equals("day") || unit.equals("")) {
            return 6;
        }
        if (unit.equals("hour")) {
            return 11;
        }
        if (unit.equals("minute")) {
            return 12;
        }
        throw new EBaseException("Invalid retention unit: " + unit);
    }

    public void init(JobsScheduler scheduler, String id, String implName, JobConfig config) throws EBaseException {
        super.init(scheduler, id, implName, config);
        CAEngine caEngine = (CAEngine)this.engine;
        this.requestRepository = caEngine.getRequestRepository();
        this.certRepository = caEngine.getCertificateRepository();
        this.certRetentionTime = config.getInteger("certRetentionTime", 30);
        logger.info("PruningJob: - cert retention time: " + this.certRetentionTime);
        String certRetentionUnitStr = config.getString("certRetentionUnit", "day");
        logger.info("PruningJob: - cert retention unit: " + certRetentionUnitStr);
        this.certRetentionUnit = this.parseRetentionUnit(certRetentionUnitStr);
        this.certSearchSizeLimit = config.getInteger("certSearchSizeLimit", 1000);
        logger.info("PruningJob: - cert search size limit: " + this.certSearchSizeLimit);
        this.certSearchTimeLimit = config.getInteger("certSearchTimeLimit", 0);
        logger.info("PruningJob: - cert search time limit: " + this.certSearchTimeLimit);
        this.requestRetentionTime = config.getInteger("requestRetentionTime", 30);
        logger.info("PruningJob: - request retention time: " + this.requestRetentionTime);
        String requestRetentionUnitStr = config.getString("requestRetentionUnit", "day");
        logger.info("PruningJob: - request retention unit: " + requestRetentionUnitStr);
        this.requestRetentionUnit = this.parseRetentionUnit(requestRetentionUnitStr);
        this.requestSearchSizeLimit = config.getInteger("requestSearchSizeLimit", 1000);
        logger.info("PruningJob: - request search size limit: " + this.requestSearchSizeLimit);
        this.requestSearchTimeLimit = config.getInteger("requestSearchTimeLimit", 0);
        logger.info("PruningJob: - request search time limit: " + this.requestSearchTimeLimit);
    }

    public void pruneCertRecord(CertRecord certRecord) throws Exception {
        X509CertImpl cert = certRecord.getCertificate();
        CertId certID = new CertId(cert.getSerialNumber());
        logger.info("PruningJob: Removing cert " + certID.toHexString());
        this.certRepository.deleteCertificateRecord(cert.getSerialNumber());
        MetaInfo metaInfo = (MetaInfo)certRecord.get("certMetaInfo");
        if (metaInfo == null) {
            logger.info("PruningJob: Cert " + certID.toHexString() + " has no metadata");
            return;
        }
        String requestIDString = (String)metaInfo.get("requestId");
        if (requestIDString == null) {
            logger.info("PruningJob: Cert " + certID.toHexString() + " has no request");
            return;
        }
        RequestId requestID = new RequestId(requestIDString);
        logger.info("PruningJob: Removing request " + requestID.toHexString() + " for cert " + certID.toHexString());
        this.requestRepository.removeRequest(requestID);
    }

    public void pruneCertRecords(Calendar calendar) throws EBaseException {
        Calendar pruningCalendar = (Calendar)calendar.clone();
        pruningCalendar.add(this.certRetentionUnit, -this.certRetentionTime);
        Date pruningTime = pruningCalendar.getTime();
        logger.info("PruningJob: Pruning certs expired before " + pruningTime);
        long time = pruningTime.getTime();
        String filter = "(&(x509Cert.notAfter<=" + time + ")(!(x509Cert.notAfter=" + time + ")))";
        logger.info("PruningJob: - filter: " + filter);
        Enumeration<CertRecord> certRecords = this.certRepository.searchCertificates(filter, this.certSearchSizeLimit, this.certSearchTimeLimit);
        while (certRecords.hasMoreElements()) {
            CertRecord certRecord = certRecords.nextElement();
            CertId certID = new CertId(certRecord.getSerialNumber());
            logger.info("PruningJob: Pruning cert " + certID.toHexString());
            logger.info("PruningJob: - expired: " + certRecord.getNotAfter());
            try {
                this.pruneCertRecord(certRecord);
            }
            catch (Exception e) {
                logger.warn("Unable to prune cert " + certID.toHexString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void pruneRequestRecords(Calendar calendar) throws EBaseException {
        Calendar pruningCalendar = (Calendar)calendar.clone();
        pruningCalendar.add(this.requestRetentionUnit, -this.requestRetentionTime);
        Date pruningTime = pruningCalendar.getTime();
        logger.info("PruningJob: Pruning incomplete requests last modified before " + pruningTime);
        long time = pruningTime.getTime();
        String filter = "(&(!(requestState=" + RequestStatus.COMPLETE + "))(requestModifyTime<=" + time + ")(!(requestModifyTime=" + time + ")))";
        logger.info("PruningJob: - filter: " + filter);
        RequestList requestRecords = this.requestRepository.listRequestsByFilter(filter, this.requestSearchSizeLimit, this.requestSearchTimeLimit);
        while (requestRecords.hasMoreElements()) {
            RequestId requestID = requestRecords.nextElement();
            logger.info("PruningJob: Pruning request " + requestID.toHexString());
            Request request = this.requestRepository.readRequest(requestID);
            logger.info("PruningJob: - status: " + request.getRequestStatus());
            logger.info("PruningJob: - last modified: " + request.getModificationTime());
            try {
                this.requestRepository.removeRequest(requestID);
            }
            catch (EBaseException e) {
                logger.warn("Unable to prune cert " + requestID.toHexString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void run() {
        Calendar calendar = Calendar.getInstance();
        Date time = calendar.getTime();
        logger.info("PruningJob: Running " + this.mId + " job at " + time);
        Repository.IDGenerator requestIDGenerator = this.requestRepository.getIDGenerator();
        if (requestIDGenerator != Repository.IDGenerator.RANDOM) {
            String message = "Unsupported request ID generator for pruning: " + requestIDGenerator;
            logger.error(message);
            throw new RuntimeException(message);
        }
        Repository.IDGenerator certIDGenerator = this.certRepository.getIDGenerator();
        if (certIDGenerator != Repository.IDGenerator.RANDOM) {
            String message = "Unsupported certificate ID generator for pruning: " + certIDGenerator;
            logger.error(message);
            throw new RuntimeException(message);
        }
        try {
            this.pruneCertRecords(calendar);
        }
        catch (EBaseException e) {
            logger.warn("PruningJob: Unable to prune certificates: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.pruneRequestRecords(calendar);
        }
        catch (EBaseException e) {
            logger.warn("PruningJob: Unable to prune requests: " + e.getMessage(), (Throwable)e);
        }
    }
}

