/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca;

import com.netscape.ca.AuthorityMonitor;
import com.netscape.ca.CANotify;
import com.netscape.ca.CAService;
import com.netscape.ca.CRLConfig;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CRLIssuingPointConfig;
import com.netscape.ca.CertificateAuthority;
import com.netscape.ca.KeyRetriever;
import com.netscape.ca.KeyRetrieverRunner;
import com.netscape.certsrv.authentication.ISharedToken;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Nonces;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.ca.CATypeException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.ca.IssuerUnavailableException;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.publish.CRLPublisher;
import com.netscape.certsrv.request.IPolicy;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.certsrv.util.AsyncLoader;
import com.netscape.cms.authentication.CAAuthSubsystem;
import com.netscape.cms.request.RequestScheduler;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.cert.CrossCertPairSubsystem;
import com.netscape.cmscore.dbs.CRLRepository;
import com.netscape.cmscore.dbs.CertStatusUpdateTask;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.ReplicaIDRepository;
import com.netscape.cmscore.dbs.RetrieveModificationsTask;
import com.netscape.cmscore.dbs.SerialNumberUpdateTask;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.LdapRequestListener;
import com.netscape.cmscore.ldap.PublishingConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.listeners.ListenerPlugin;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.RequestNotifier;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.ldap.LDAPPostReadControl;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.apache.commons.lang3.StringUtils;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.legacy.ca.CAPolicy;
import org.dogtagpki.legacy.ca.CAPolicyConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class CAEngine
extends CMSEngine {
    static CAEngine instance;
    protected CertificateRepository certificateRepository;
    protected CRLRepository crlRepository;
    protected ReplicaIDRepository replicaIDRepository;
    protected CAPolicy caPolicy;
    protected CAService caService;
    protected CertificateVersion defaultCertVersion;
    protected long defaultCertValidity;
    protected boolean enablePastCATime;
    protected boolean enablePastCATime_caCert;
    protected boolean enableOCSP;
    protected int fastSigning = 0;
    protected boolean allowExtCASignedAgentCerts = false;
    protected boolean enableNonces = true;
    protected int maxNonces = 100;
    protected Hashtable<String, ListenerPlugin> listenerPlugins = new Hashtable();
    protected boolean ocspResponderByName = true;
    protected CRLPublisher crlPublisher;
    protected CAPublisherProcessor publisherProcessor;
    protected Map<String, CRLIssuingPoint> crlIssuingPoints = new HashMap<String, CRLIssuingPoint>();
    protected X509Certificate issuanceProtectionCert;
    protected PublicKey issuanceProtectionPublicKey;
    protected PrivateKey issuanceProtectionPrivateKey;
    public RequestListener certIssuedListener;
    public RequestListener certRevokedListener;
    public RequestListener requestInQueueListener;
    public RetrieveModificationsTask retrieveModificationsTask;
    public CertStatusUpdateTask certStatusUpdateTask;
    public SerialNumberUpdateTask serialNumberUpdateTask;
    protected LdapBoundConnFactory connectionFactory;
    public static Map<AuthorityID, CertificateAuthority> authorities;
    public Map<AuthorityID, Thread> keyRetrievers = Collections.synchronizedSortedMap(new TreeMap());
    public static TreeMap<AuthorityID, BigInteger> entryUSNs;
    public static TreeMap<AuthorityID, String> nsUniqueIds;
    public static TreeSet<String> deletedNsUniqueIds;
    protected AsyncLoader loader = new AsyncLoader(10);
    protected boolean foundHostCA;
    protected AuthorityMonitor authorityMonitor;
    protected boolean enableAuthorityMonitor = true;

    public CAEngine() {
        super("CA");
        instance = this;
    }

    public static CAEngine getInstance() {
        return instance;
    }

    public CAEngineConfig createConfig(ConfigStorage storage) throws Exception {
        return new CAEngineConfig(storage);
    }

    public CAEngineConfig getConfig() {
        return (CAEngineConfig)this.mConfig;
    }

    public void initDatabase() throws Exception {
        this.connectionFactory = new LdapBoundConnFactory("CertificateAuthority");
        this.connectionFactory.setCMSEngine((CMSEngine)this);
        CAEngineConfig config = this.getConfig();
        PKISocketConfig socketConfig = config.getSocketConfig();
        LDAPConfig ldapConfig = config.getInternalDBConfig();
        this.connectionFactory.init(socketConfig, ldapConfig, this.getPasswordStore());
    }

    public CertRequestRepository getCertRequestRepository() {
        return (CertRequestRepository)this.requestRepository;
    }

    public CertificateRepository getCertificateRepository() {
        return this.certificateRepository;
    }

    public CRLRepository getCRLRepository() {
        return this.crlRepository;
    }

    public ReplicaIDRepository getReplicaIDRepository() {
        return this.replicaIDRepository;
    }

    public CAPolicy getCAPolicy() {
        return this.caPolicy;
    }

    public CAService getCAService() {
        return this.caService;
    }

    public CertificateVersion getDefaultCertVersion() {
        return this.defaultCertVersion;
    }

    public long getDefaultCertValidity() {
        return this.defaultCertValidity;
    }

    public boolean getEnablePastCATime() {
        return this.enablePastCATime;
    }

    public boolean getEnablePastCATime_caCert() {
        return this.enablePastCATime_caCert;
    }

    public boolean getEnableOCSP() {
        return this.enableOCSP;
    }

    public void setEnablePastCATime(String enablePastCATime) {
        this.enablePastCATime = enablePastCATime.equals("true");
    }

    public int getFastSigning() {
        return this.fastSigning;
    }

    public boolean getAllowExtCASignedAgentCerts() {
        return this.allowExtCASignedAgentCerts;
    }

    public boolean getEnableNonces() {
        return this.enableNonces;
    }

    public int getMaxNonces() {
        return this.maxNonces;
    }

    public boolean getOCSPResponderByName() {
        return this.ocspResponderByName;
    }

    public CRLPublisher getCRLPublisher() {
        return this.crlPublisher;
    }

    public CAPublisherProcessor getPublisherProcessor() {
        return this.publisherProcessor;
    }

    public Collection<CRLIssuingPoint> getCRLIssuingPoints() {
        return this.crlIssuingPoints.values();
    }

    public CRLIssuingPoint getMasterCRLIssuingPoint() {
        return this.crlIssuingPoints.get("MasterCRL");
    }

    public CRLIssuingPoint getCRLIssuingPoint(String id) {
        return this.crlIssuingPoints.get(id);
    }

    public void addCRLIssuingPoint(String id, CRLIssuingPoint crlIssuingPoint) {
        this.crlIssuingPoints.put(id, crlIssuingPoint);
    }

    public CRLIssuingPoint removeCRLIssuingPoint(String id) {
        return this.crlIssuingPoints.remove(id);
    }

    public X509Certificate getIssuanceProtectionCert() {
        return this.issuanceProtectionCert;
    }

    public PublicKey getIssuanceProtectionPublicKey() {
        return this.issuanceProtectionPublicKey;
    }

    public PrivateKey getIssuanceProtectionPrivateKey() {
        return this.issuanceProtectionPrivateKey;
    }

    public RequestListener getCertIssuedListener() {
        return this.certIssuedListener;
    }

    public RequestListener getCertRevokedListener() {
        return this.certRevokedListener;
    }

    public RequestListener getRequestInQueueListener() {
        return this.requestInQueueListener;
    }

    public AsyncLoader getLoader() {
        return this.loader;
    }

    public LdapBoundConnFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void initAuthSubsystem() throws Exception {
        AuthenticationConfig authConfig = this.config.getAuthenticationConfig();
        this.authSubsystem = new CAAuthSubsystem();
        this.authSubsystem.setCMSEngine((CMSEngine)this);
        this.authSubsystem.init((ConfigStore)authConfig);
        this.authSubsystem.startup();
    }

    public void initListeners() throws Exception {
        logger.info("CAEngine: Initializing CA listeners");
        CertificateAuthority hostCA = this.getCA();
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        ConfigStore listenersConfig = caConfig.getSubStore("listener", ConfigStore.class);
        if (listenersConfig == null) {
            return;
        }
        logger.info("CAEngine: Loading listener plugins");
        ConfigStore pluginsConfig = listenersConfig.getSubStore("impl", ConfigStore.class);
        Enumeration pluginNames = pluginsConfig.getSubStoreNames().elements();
        while (pluginNames.hasMoreElements()) {
            String id = (String)pluginNames.nextElement();
            String listenerClassName = pluginsConfig.getString(id + ".class");
            logger.info("CAEngine: - " + id + ": " + listenerClassName);
            ListenerPlugin plugin = new ListenerPlugin(id, listenerClassName);
            this.listenerPlugins.put(id, plugin);
        }
        logger.info("CAEngine: Creating listener instances");
        ConfigStore instancesConfig = listenersConfig.getSubStore("instance", ConfigStore.class);
        Enumeration instanceNames = instancesConfig.getSubStoreNames().elements();
        while (instanceNames.hasMoreElements()) {
            String id = (String)instanceNames.nextElement();
            ConfigStore instanceConfig = instancesConfig.getSubStore(id, ConfigStore.class);
            String pluginName = instancesConfig.getString(id + ".plugin");
            logger.info("CAEngine: - " + id + ": " + pluginName);
            ListenerPlugin plugin = this.listenerPlugins.get(pluginName);
            if (plugin == null) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_ERROR_LISTENER", (Object[])new Object[]{pluginName}));
                throw new Exception("Invalid plugin name for " + id + " listener: " + pluginName);
            }
            String className = plugin.getClassPath();
            RequestListener listener = (RequestListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            listener.setCMSEngine((CMSEngine)this);
            listener.init((Subsystem)hostCA, instanceConfig);
        }
    }

    public void initCRLPublisher() throws Exception {
        logger.info("CAEngine: Initializing CRL publisher");
        CertificateAuthority hostCA = this.getCA();
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        ConfigStore crlPublisherConfig = caConfig.getSubStore("crlPublisher", ConfigStore.class);
        if (crlPublisherConfig == null || crlPublisherConfig.size() == 0) {
            return;
        }
        String className = crlPublisherConfig.getString("class");
        if (className == null) {
            return;
        }
        logger.info("CAEngine: - class: " + className);
        Class<?> publisherClass = Class.forName(className);
        this.crlPublisher = (CRLPublisher)publisherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.crlPublisher.init(hostCA, crlPublisherConfig);
    }

    public void initPublisherProcessor() throws Exception {
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        PublishingConfig publishingConfig = caConfig.getPublishingConfig();
        if (publishingConfig == null || publishingConfig.size() == 0) {
            logger.info("CAEngine: Publisher processor disabled");
            return;
        }
        logger.info("CAEngine: Initializing publisher processor");
        CertificateAuthority hostCA = this.getCA();
        this.publisherProcessor = new CAPublisherProcessor("capp");
        if (publishingConfig.isEnabled()) {
            LdapRequestListener listener = new LdapRequestListener();
            listener.setPublisherProcessor(this.publisherProcessor);
            this.publisherProcessor.setRequestListener(listener);
        }
        this.publisherProcessor.init(hostCA, publishingConfig);
    }

    public void initCRLIssuingPoints() throws Exception {
        logger.info("CAEngine: Initializing CRL issuing points");
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        CRLConfig crlConfig = caConfig.getCRLConfig();
        if (crlConfig == null || crlConfig.size() <= 0) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_NO_MASTER_CRL", (Object[])new Object[0]));
            return;
        }
        Enumeration ipIDs = crlConfig.getSubStoreNames().elements();
        if (ipIDs == null || !ipIDs.hasMoreElements()) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CA_NO_MASTER_CRL_SUBSTORE", (Object[])new Object[0]));
            return;
        }
        CertificateAuthority hostCA = this.getCA();
        while (ipIDs.hasMoreElements()) {
            String id = (String)ipIDs.nextElement();
            CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(id);
            String className = ipConfig.getClassName();
            Class<?> clazz = Class.forName(className);
            CRLIssuingPoint issuingPoint = (CRLIssuingPoint)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            issuingPoint.init(hostCA, id, ipConfig);
            this.crlIssuingPoints.put(id, issuingPoint);
        }
    }

    public void initIssuanceProtectionCert() throws Exception {
        logger.info("CAEngine: Initializing CA issuance protection cert");
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        String certNickName = caConfig.getString("cert.issuance_protection.nickname", null);
        logger.info("CAEngine: - cert.issuance_protection.nickname: " + certNickName);
        if (certNickName == null) {
            certNickName = caConfig.getString("cert.subsystem.nickname");
            logger.info("CAEngine: - cert.subsystem.nickname: " + certNickName);
        }
        CryptoManager cm = CryptoManager.getInstance();
        this.issuanceProtectionCert = cm.findCertByNickname(certNickName);
        logger.info("CAEngine: Loading public and private keys for " + certNickName);
        this.issuanceProtectionPublicKey = this.issuanceProtectionCert.getPublicKey();
        this.issuanceProtectionPrivateKey = cm.findPrivKeyByCert(this.issuanceProtectionCert);
    }

    public void initAuthorityMonitor() throws Exception {
        if (!this.enableAuthorityMonitor || !this.haveAuthorityContainer()) {
            return;
        }
        CertificateAuthority hostCA = this.getCA();
        this.authorityMonitor = new AuthorityMonitor();
        new Thread((Runnable)this.authorityMonitor, "AuthorityMonitor").start();
        try {
            logger.info("CAEngine: Waiting for authorities to load");
            this.loader.awaitLoadDone();
        }
        catch (InterruptedException e) {
            logger.warn("CAEngine: Caught InterruptedException while waiting for initial load of authorities.");
            logger.warn("CAEngine: You may have replication conflict entries or extraneous data under " + this.getAuthorityBaseDN());
        }
        if (!this.foundHostCA) {
            logger.debug("CAEngine: No entry for host authority");
            logger.debug("CAEngine: Adding entry for host authority");
            this.addCA(this.addHostAuthorityEntry(), hostCA);
        }
    }

    public void initCertIssuedListener() throws Exception {
        logger.info("CAEngine: Initializing certificate issued listener");
        CertificateAuthority hostCA = this.getCA();
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        ConfigStore listenerConfig = caConfig.getSubStore("notification", ConfigStore.class);
        if (listenerConfig == null || listenerConfig.size() == 0) {
            return;
        }
        String className = listenerConfig.getString("certificateIssuedListenerClassName", "com.netscape.cms.listeners.CertificateIssuedListener");
        this.certIssuedListener = (RequestListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.certIssuedListener.setCMSEngine((CMSEngine)this);
        this.certIssuedListener.init((Subsystem)hostCA, listenerConfig);
    }

    public void initCertRevokedListener() throws Exception {
        logger.info("CAEngine: Initializing cert revoked listener");
        CertificateAuthority hostCA = this.getCA();
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        ConfigStore listenerConfig = caConfig.getSubStore("notification", ConfigStore.class);
        if (listenerConfig == null || listenerConfig.size() == 0) {
            return;
        }
        String className = listenerConfig.getString("certificateIssuedListenerClassName", "com.netscape.cms.listeners.CertificateRevokedListener");
        this.certRevokedListener = (RequestListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.certRevokedListener.setCMSEngine((CMSEngine)this);
        this.certRevokedListener.init((Subsystem)hostCA, listenerConfig);
    }

    public void initRequestInQueueListener() throws Exception {
        logger.info("CAEngine: Initializing request in queue listener");
        CertificateAuthority hostCA = this.getCA();
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        ConfigStore listenerConfig = caConfig.getSubStore("notification", ConfigStore.class);
        if (listenerConfig == null || listenerConfig.size() == 0) {
            return;
        }
        String className = listenerConfig.getString("certificateIssuedListenerClassName", "com.netscape.cms.listeners.RequestInQListener");
        this.requestInQueueListener = (RequestListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.requestInQueueListener.setCMSEngine((CMSEngine)this);
        this.requestInQueueListener.init((Subsystem)hostCA, listenerConfig);
    }

    public void startCertStatusUpdate() throws Exception {
        logger.info("CAEngine: Cert status update task:");
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        int interval = caConfig.getInteger("certStatusUpdateInterval", 600);
        logger.info("CAEngine: - interval: " + interval + " seconds");
        boolean listenToCloneModifications = caConfig.getBoolean("listenToCloneModifications", false);
        logger.info("CAEngine: - listen to clone modification: " + listenToCloneModifications);
        int pageSize = caConfig.getInteger("transitRecordPageSize", 200);
        logger.info("CAEngine: - page size: " + pageSize);
        int maxRecords = caConfig.getInteger("transitMaxRecords", 1000000);
        logger.info("CAEngine: - max records: " + maxRecords);
        if (this.certStatusUpdateTask != null) {
            this.certStatusUpdateTask.stop();
        }
        if (this.retrieveModificationsTask != null) {
            this.retrieveModificationsTask.stop();
        }
        if (interval == 0) {
            logger.info("CAEngine: Cert status update task is disabled");
            return;
        }
        if (listenToCloneModifications) {
            logger.info("CAEngine: Starting retrieve modifications task");
            this.retrieveModificationsTask = new RetrieveModificationsTask(this.certificateRepository);
            this.retrieveModificationsTask.start();
        }
        logger.info("CAEngine: Starting cert status update task");
        this.certStatusUpdateTask = new CertStatusUpdateTask(this.certificateRepository, interval, pageSize, maxRecords);
        this.certStatusUpdateTask.start();
    }

    public void startSerialNumberUpdateTask() throws Exception {
        logger.info("CAEngine: Serial number update task:");
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        int interval = caConfig.getInteger("serialNumberUpdateInterval", 600);
        logger.info("CAEngine: - interval: " + interval + " seconds");
        if (this.serialNumberUpdateTask != null) {
            this.serialNumberUpdateTask.stop();
        }
        if (interval <= 0) {
            logger.info("CAEngine: Serial number update task is disabled");
            return;
        }
        logger.info("CAEngine: Starting serial number update task");
        this.serialNumberUpdateTask = new SerialNumberUpdateTask(this.certificateRepository, this.requestRepository, interval);
        this.serialNumberUpdateTask.start();
    }

    public void initSubsystems() throws Exception {
        CertificateAuthority hostCA = this.getCA();
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        logger.info("CAEngine: Loading CA configuration");
        int certVersion = caConfig.getInteger("X509CertVersion", 2);
        if (certVersion != 0 && certVersion != 2) {
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_X509CERT_VERSION_NOT_SUPPORTED", (String[])new String[0]));
        }
        this.defaultCertVersion = new CertificateVersion(certVersion - 1);
        logger.info("CAEngine: - default cert version: " + this.defaultCertVersion);
        int certValidity = caConfig.getInteger("DefaultIssueValidity", 730);
        this.defaultCertValidity = (long)certValidity * 86400000L;
        logger.info("CAEngine: - default cert validity (days): " + certValidity);
        this.enablePastCATime = caConfig.getBoolean("enablePastCATime", false);
        logger.info("CAEngine: - enable past CA time: " + this.enablePastCATime);
        this.enablePastCATime_caCert = caConfig.getBoolean("enablePastCATime_caCert", false);
        logger.info("CAEngine: - enable past CA time for CA certs: " + this.enablePastCATime_caCert);
        this.enableOCSP = caConfig.getBoolean("ocsp", true);
        String fastSigning = caConfig.getString("fastSigning", "");
        logger.info("CAEngine: - fast signing: " + fastSigning);
        this.fastSigning = fastSigning.equals("enabled") || fastSigning.equals("enable") ? 1 : 0;
        this.allowExtCASignedAgentCerts = caConfig.getBoolean("allowExtCASignedAgentCerts", false);
        logger.info("CAEngine: - allowExtCASignedAgentCerts: " + this.allowExtCASignedAgentCerts);
        this.enableNonces = caConfig.getBoolean("enableNonces", true);
        logger.info("CAEngine: - enable nonces: " + this.enableNonces);
        this.maxNonces = caConfig.getInteger("maxNumberOfNonces", 100);
        logger.info("CAEngine: - max nonces: " + this.maxNonces);
        logger.info("CAEngine: Initializing CA policy");
        CAPolicyConfig caPolicyConfig = caConfig.getPolicyConfig();
        this.caPolicy = new CAPolicy();
        this.caPolicy.init(hostCA, caPolicyConfig);
        logger.info("CAEngine: Initializing CA service");
        this.caService = new CAService(hostCA);
        logger.info("CAEngine: Initializing CA request notifier");
        this.requestNotifier = new CANotify();
        this.requestNotifier.setCMSEngine((CMSEngine)this);
        logger.info("CAEngine: Initializing CA pending request notifier");
        this.pendingNotifier = new RequestNotifier();
        this.pendingNotifier.setCMSEngine((CMSEngine)this);
        logger.info("CAEngine: Initializing CA request queue");
        int increment = caConfig.getInteger("reqdbInc", 5);
        logger.info("CAEngine: - increment: " + increment);
        String schedulerClass = caConfig.getString("requestSchedulerClass", null);
        logger.info("CAEngine: - scheduler: " + schedulerClass);
        this.enableAuthorityMonitor = caConfig.getBoolean("authorityMonitor.enable", this.enableAuthorityMonitor);
        logger.info("CAEngine: - enable AuthorityMonitor: " + this.enableAuthorityMonitor);
        SecureRandom secureRandom = this.getJSSSubsystem().getRandomNumberGenerator();
        this.requestRepository = new CertRequestRepository(secureRandom, this.dbSubsystem);
        this.requestRepository.setCMSEngine((CMSEngine)this);
        this.requestRepository.init();
        this.requestQueue = new RequestQueue(this.dbSubsystem, this.requestRepository, (IPolicy)this.caPolicy, (IService)this.caService, this.requestNotifier, this.pendingNotifier);
        if (schedulerClass != null) {
            RequestScheduler scheduler = (RequestScheduler)Class.forName(schedulerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.requestQueue.setRequestScheduler(scheduler);
        }
        if (!this.isPreOpMode()) {
            logger.info("CAEngine: Starting CA services");
            this.startCertStatusUpdate();
            boolean consistencyCheck = caConfig.getBoolean("ConsistencyCheck", false);
            logger.info("CAEngine: - consistency check: " + consistencyCheck);
            this.certificateRepository.setConsistencyCheck(consistencyCheck);
            this.startSerialNumberUpdateTask();
            ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
            this.caService.init(connectorsConfig);
            this.initListeners();
            logger.info("CAEngine: Configuring OCSP responder");
            this.ocspResponderByName = caConfig.getBoolean("byName", true);
            logger.info("CAEngine: - by name: " + this.ocspResponderByName);
            this.initCRLPublisher();
            this.initPublisherProcessor();
        }
        super.initSubsystems();
    }

    public void initSubsystem(Subsystem subsystem, ConfigStore subsystemConfig) throws Exception {
        if ((subsystem instanceof CertificateAuthority || subsystem instanceof CrossCertPairSubsystem) && this.isPreOpMode()) {
            return;
        }
        super.initSubsystem(subsystem, subsystemConfig);
        if (subsystem instanceof CertificateAuthority) {
            this.initCRLIssuingPoints();
            this.initIssuanceProtectionCert();
            this.initAuthorityMonitor();
        }
    }

    public java.security.cert.X509Certificate[] getCertChain(java.security.cert.X509Certificate cert) throws Exception {
        CertificateAuthority ca = this.getCA();
        CertificateChain caChain = ca.getCACertChain();
        java.security.cert.X509Certificate[] caCerts = caChain.getChain();
        if (CertUtils.certInCertChain((java.security.cert.X509Certificate[])caCerts, (java.security.cert.X509Certificate)cert)) {
            return Arrays.copyOf(caCerts, caCerts.length);
        }
        java.security.cert.X509Certificate[] certChain = new java.security.cert.X509Certificate[caCerts.length + 1];
        certChain[0] = cert;
        System.arraycopy(caCerts, 0, certChain, 1, caCerts.length);
        return certChain;
    }

    public void startPublisherProcessor() throws Exception {
        if (!this.publisherProcessor.isCertPublishingEnabled()) {
            logger.info("CertificateAuthority: Publisher processor disabled");
            return;
        }
        logger.info("CertificateAuthority: Starting publisher processor");
        CertificateAuthority hostCA = this.getCA();
        this.publisherProcessor.publishCACert((java.security.cert.X509Certificate)hostCA.getCACert());
    }

    public void startupSubsystems() throws Exception {
        if (!this.isPreOpMode()) {
            this.caService.startup();
            this.recoverRequestQueue();
            this.startPublisherProcessor();
            this.initCertIssuedListener();
            this.initCertRevokedListener();
            this.initRequestInQueueListener();
        }
        super.startupSubsystems();
        if (!this.isPreOpMode()) {
            logger.debug("CAEngine: Checking cert request serial number ranges");
            this.requestRepository.checkRanges();
            logger.debug("CAEngine: Checking cert serial number ranges");
            this.certificateRepository.checkRanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveAuthorityContainer() throws EBaseException {
        LdapBoundConnection conn = null;
        try {
            conn = this.connectionFactory.getConn(true);
            LDAPSearchResults results = conn.search(this.getAuthorityBaseDN(), 0, null, null, false);
            boolean bl = results != null;
            return bl;
        }
        catch (LDAPException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionFactory.returnConn((LDAPConnection)conn);
        }
    }

    public CertificateAuthority getCA() {
        return (CertificateAuthority)this.getSubsystem("ca");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CertificateAuthority> getCAs() {
        ArrayList<CertificateAuthority> list = new ArrayList<CertificateAuthority>();
        Map<AuthorityID, CertificateAuthority> map = authorities;
        synchronized (map) {
            list.addAll(authorities.values());
        }
        return list;
    }

    public CertificateAuthority getCA(AuthorityID aid) {
        return aid == null ? this.getCA() : authorities.get(aid);
    }

    public CertificateAuthority getCA(X500Name dn) {
        for (CertificateAuthority ca : this.getCAs()) {
            if (!ca.getX500Name().equals((Object)dn)) continue;
            return ca;
        }
        return null;
    }

    public void addCA(AuthorityID aid, CertificateAuthority ca) {
        authorities.put(aid, ca);
    }

    public void removeCA(AuthorityID aid) {
        authorities.remove(aid);
        entryUSNs.remove(aid);
        nsUniqueIds.remove(aid);
    }

    public void ensureAuthorityDNAvailable(X500Name dn) throws IssuerUnavailableException {
        for (CertificateAuthority ca : this.getCAs()) {
            if (!ca.getX500Name().equals((Object)dn)) continue;
            throw new IssuerUnavailableException("DN '" + dn + "' is used by an existing authority");
        }
    }

    public CertificateAuthority createCA(CertificateAuthority parentCA, AuthToken authToken, String subjectDN, String description) throws Exception {
        parentCA.ensureReady();
        X500Name subjectX500Name = new X500Name(subjectDN);
        this.ensureAuthorityDNAvailable(subjectX500Name);
        AuthorityID aid = new AuthorityID();
        String aidString = aid.toString();
        logger.info("CAEngine: Creating authority " + aidString);
        CertificateAuthority hostCA = this.getCA();
        String nickname = hostCA.getNickname() + " " + aidString;
        logger.info("CAEngine: - nickname: " + nickname);
        String dn = "cn=" + aidString + "," + this.getAuthorityBaseDN();
        logger.info("CAEngine: - authority record: " + dn);
        String parentDNString = parentCA.getX500Name().toLdapDNString();
        String keyHost = this.mConfig.getHostname() + ":" + this.getEESSLPort();
        logger.info("CAEngine: - key host: " + keyHost);
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("objectclass", "authority"), new LDAPAttribute("cn", aidString), new LDAPAttribute("authorityID", aidString), new LDAPAttribute("authorityKeyNickname", nickname), new LDAPAttribute("authorityKeyHost", keyHost), new LDAPAttribute("authorityEnabled", "TRUE"), new LDAPAttribute("authorityDN", subjectDN), new LDAPAttribute("authorityParentDN", parentDNString)};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        if (parentCA.getAuthorityID() != null) {
            attrSet.add(new LDAPAttribute("authorityParentID", parentCA.getAuthorityID().toString()));
        }
        if (description != null) {
            logger.info("CAEngine: - description: " + description);
            attrSet.add(new LDAPAttribute("description", description));
        }
        LDAPEntry ldapEntry = new LDAPEntry(dn, attrSet);
        this.addAuthorityEntry(aid, ldapEntry);
        X509CertImpl cert = null;
        try {
            logger.info("CAEngine: Generating signing certificate");
            cert = parentCA.generateSigningCert(subjectX500Name, authToken);
            logger.info("CAEngine: Importing signing certificate into NSS database");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            cryptoManager.importCertPackage(cert.getEncoded(), nickname);
        }
        catch (Exception e) {
            logger.error("Unable to generate signing certificate: " + e.getMessage(), (Throwable)e);
            this.deleteAuthorityEntry(aid);
            throw e;
        }
        CertificateAuthority ca = new CertificateAuthority(subjectX500Name, aid, parentCA.getAuthorityID(), cert.getSerialNumber(), nickname, Collections.singleton(keyHost), description, true);
        CAEngineConfig engineConfig = this.getConfig();
        CAConfig caConfig = engineConfig.getCAConfig();
        ca.setCMSEngine(this);
        ca.init(caConfig);
        this.updateAuthoritySerialNumber(aid, cert.getSerialNumber());
        return ca;
    }

    public CertificateAuthority createCA(AuthorityID parentAID, AuthToken authToken, String subjectDN, String description) throws Exception {
        CertificateAuthority parentCA = this.getCA(parentAID);
        if (parentCA == null) {
            throw new CANotFoundException("Parent CA \"" + parentAID + "\" does not exist");
        }
        CertificateAuthority ca = this.createCA(parentCA, authToken, subjectDN, description);
        authorities.put(ca.getAuthorityID(), ca);
        return ca;
    }

    public void startKeyRetriever(CertificateAuthority ca) throws EBaseException {
        KeyRetriever keyRetriever;
        AuthorityID authorityID = ca.getAuthorityID();
        if (authorityID == null) {
            logger.info("CertificateAuthority: Do not start KeyRetriever for host CA");
            return;
        }
        if (this.keyRetrievers.containsKey(authorityID)) {
            logger.info("CertificateAuthority: KeyRetriever already running for authority " + authorityID);
            return;
        }
        logger.info("CertificateAuthority: Starting KeyRetriever for authority " + authorityID);
        CAEngineConfig engineConfig = this.getConfig();
        String className = engineConfig.getString("features.authority.keyRetrieverClass", null);
        if (className == null) {
            logger.info("CertificateAuthority: Key retriever not configured");
            return;
        }
        ConfigStore keyRetrieverConfig = engineConfig.getSubStore("features.authority.keyRetrieverConfig", ConfigStore.class);
        try {
            Class<KeyRetriever> clazz = Class.forName(className).asSubclass(KeyRetriever.class);
            try {
                keyRetriever = clazz.getDeclaredConstructor(ConfigStore.class).newInstance(keyRetrieverConfig);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
                keyRetriever = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Unable to create key retriever: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        KeyRetrieverRunner runner = new KeyRetrieverRunner(keyRetriever, ca);
        Thread thread = new Thread((Runnable)runner, "KeyRetriever-" + authorityID);
        thread.start();
        this.keyRetrievers.put(authorityID, thread);
    }

    public void removeKeyRetriever(AuthorityID aid) {
        this.keyRetrievers.remove(aid);
    }

    public String getAuthorityBaseDN() {
        return "ou=authorities,ou=" + this.id + "," + this.dbSubsystem.getBaseDN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryUSNPluginEnabled() throws Exception {
        LDAPConnection conn = this.connectionFactory.getConn();
        try {
            LDAPSearchResults results = conn.search("cn=usn,cn=plugins,cn=config", 0, "(nsslapd-pluginEnabled=on)", null, false);
            boolean bl = results != null && results.hasMoreElements();
            return bl;
        }
        catch (LDAPException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionFactory.returnConn(conn);
        }
    }

    public LDAPConstraints getUpdateConstraints() {
        String[] attrs = new String[]{"entryUSN", "nsUniqueId"};
        LDAPConstraints cons = new LDAPConstraints();
        LDAPPostReadControl control = new LDAPPostReadControl(true, attrs);
        cons.setServerControls((LDAPControl)control);
        return cons;
    }

    public synchronized void trackUpdate(AuthorityID aid, LDAPControl[] responseControls) {
        LDAPPostReadControl control = (LDAPPostReadControl)LDAPUtil.getControl(LDAPPostReadControl.class, (LDAPControl[])responseControls);
        LDAPEntry entry = control.getEntry();
        LDAPAttribute attr = entry.getAttribute("entryUSN");
        if (attr != null) {
            BigInteger entryUSN = new BigInteger(attr.getStringValueArray()[0]);
            logger.debug("CAEngine: tracking entryUSN: " + entryUSN);
            entryUSNs.put(aid, entryUSN);
        }
        if ((attr = entry.getAttribute("nsUniqueId")) != null) {
            String nsUniqueId = attr.getStringValueArray()[0];
            logger.info("CAEngine: tracking nsUniqueId: " + nsUniqueId);
            nsUniqueIds.put(aid, nsUniqueId);
        }
    }

    public synchronized void addAuthorityEntry(AuthorityID aid, LDAPEntry entry) throws EBaseException {
        LDAPControl[] responseControls;
        LDAPConnection conn = this.connectionFactory.getConn();
        try {
            conn.add(entry, this.getUpdateConstraints());
            responseControls = conn.getResponseControls();
        }
        catch (LDAPException e) {
            throw new ELdapException("Unable to add authority: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.connectionFactory.returnConn(conn);
        }
        this.trackUpdate(aid, responseControls);
    }

    public synchronized void modifyAuthorityEntry(AuthorityID aid, LDAPModificationSet mods) throws EBaseException {
        LDAPControl[] responseControls;
        String dn = "cn=" + aid + "," + this.getAuthorityBaseDN();
        LDAPConnection conn = this.connectionFactory.getConn();
        try {
            conn.modify(dn, mods, this.getUpdateConstraints());
            responseControls = conn.getResponseControls();
        }
        catch (LDAPException e) {
            throw new ELdapException("Unable to modify authority: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.connectionFactory.returnConn(conn);
        }
        this.trackUpdate(aid, responseControls);
    }

    public synchronized void deleteAuthorityEntry(AuthorityID aid) throws EBaseException {
        String dn = "cn=" + aid + "," + this.getAuthorityBaseDN();
        LDAPConnection conn = this.connectionFactory.getConn();
        try {
            conn.delete(dn);
        }
        catch (LDAPException e) {
            throw new ELdapException("Unable to delete authority: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.connectionFactory.returnConn(conn);
        }
        String nsUniqueId = nsUniqueIds.get(aid);
        if (nsUniqueId != null) {
            deletedNsUniqueIds.add(nsUniqueId);
        }
        this.removeCA(aid);
    }

    public synchronized void readAuthority(LDAPEntry entry) throws Exception {
        List<String> keyHosts;
        CertificateAuthority hostCA = this.getCA();
        String nsUniqueId = entry.getAttribute("nsUniqueId").getStringValueArray()[0];
        if (deletedNsUniqueIds.contains(nsUniqueId)) {
            logger.warn("CAEngine: ignoring entry with nsUniqueId '" + nsUniqueId + "' due to deletion");
            return;
        }
        logger.info("CAEngine: Loading authority record " + entry.getDN());
        LDAPAttribute aidAttr = entry.getAttribute("authorityID");
        LDAPAttribute nickAttr = entry.getAttribute("authorityKeyNickname");
        LDAPAttribute keyHostsAttr = entry.getAttribute("authorityKeyHost");
        LDAPAttribute dnAttr = entry.getAttribute("authorityDN");
        LDAPAttribute parentAIDAttr = entry.getAttribute("authorityParentID");
        LDAPAttribute parentDNAttr = entry.getAttribute("authorityParentDN");
        LDAPAttribute serialAttr = entry.getAttribute("authoritySerial");
        if (aidAttr == null || nickAttr == null || dnAttr == null) {
            logger.warn("Malformed authority object; required attribute(s) missing: " + entry.getDN());
            return;
        }
        AuthorityID aid = new AuthorityID((String)aidAttr.getStringValues().nextElement());
        X500Name dn = null;
        try {
            dn = new X500Name((String)dnAttr.getStringValues().nextElement());
        }
        catch (IOException e) {
            logger.warn("Malformed authority object; invalid authorityDN: " + entry.getDN() + ": " + e.getMessage(), (Throwable)e);
        }
        String desc = null;
        LDAPAttribute descAttr = entry.getAttribute("description");
        if (descAttr != null) {
            desc = (String)descAttr.getStringValues().nextElement();
        }
        if (dn.toString().equals(hostCA.getX500Name().toString())) {
            logger.info("CAEngine: Updating host CA");
            this.foundHostCA = true;
            logger.info("CAEngine: - ID: " + aid);
            hostCA.setAuthorityID(aid);
            logger.info("CAEngine: - description: " + desc);
            hostCA.setAuthorityDescription(desc);
            this.addCA(aid, hostCA);
            return;
        }
        BigInteger newEntryUSN = null;
        LDAPAttribute entryUSNAttr = entry.getAttribute("entryUSN");
        if (entryUSNAttr == null) {
            logger.debug("CAEngine: no entryUSN");
            if (!this.entryUSNPluginEnabled()) {
                logger.warn("CAEngine: dirsrv USN plugin is not enabled; skipping entry");
                logger.warn("Lightweight authority entry has no entryUSN attribute and USN plugin not enabled; skipping.  Enable dirsrv USN plugin.");
                return;
            }
            logger.debug("CAEngine: dirsrv USN plugin is enabled; continuing");
        } else {
            newEntryUSN = new BigInteger(entryUSNAttr.getStringValueArray()[0]);
            logger.debug("CAEngine: new entryUSN: " + newEntryUSN);
        }
        BigInteger knownEntryUSN = entryUSNs.get(aid);
        if (newEntryUSN != null && knownEntryUSN != null) {
            logger.debug("CAEngine: known entryUSN: " + knownEntryUSN);
            if (newEntryUSN.compareTo(knownEntryUSN) <= 0) {
                logger.debug("CAEngine: data is current");
                return;
            }
        }
        X500Name parentDN = null;
        if (parentDNAttr != null) {
            try {
                parentDN = new X500Name((String)parentDNAttr.getStringValues().nextElement());
            }
            catch (IOException e) {
                logger.warn("Malformed authority object; invalid authorityParentDN: " + entry.getDN() + ": " + e.getMessage(), (Throwable)e);
                return;
            }
        }
        String keyNick = (String)nickAttr.getStringValues().nextElement();
        if (keyHostsAttr == null) {
            keyHosts = Collections.emptyList();
        } else {
            Enumeration keyHostsEnum = keyHostsAttr.getStringValues();
            keyHosts = Collections.list(keyHostsEnum);
        }
        AuthorityID parentAID = null;
        if (parentAIDAttr != null) {
            parentAID = new AuthorityID((String)parentAIDAttr.getStringValues().nextElement());
        }
        BigInteger serial = null;
        if (serialAttr != null) {
            serial = new BigInteger(serialAttr.getStringValueArray()[0]);
        }
        boolean enabled = true;
        LDAPAttribute enabledAttr = entry.getAttribute("authorityEnabled");
        if (enabledAttr != null) {
            String enabledString = (String)enabledAttr.getStringValues().nextElement();
            enabled = enabledString.equalsIgnoreCase("TRUE");
        }
        try {
            CertificateAuthority ca = new CertificateAuthority(dn, aid, parentAID, serial, keyNick, keyHosts, desc, enabled);
            CAEngineConfig engineConfig = this.getConfig();
            CAConfig caConfig = engineConfig.getCAConfig();
            ca.setCMSEngine(this);
            ca.init(caConfig);
            this.addCA(aid, ca);
            entryUSNs.put(aid, newEntryUSN);
            nsUniqueIds.put(aid, nsUniqueId);
        }
        catch (Exception e) {
            logger.warn("CAEngine: Error initializing lightweight CA: " + e.getMessage(), (Throwable)e);
        }
    }

    public AuthorityID addHostAuthorityEntry() throws EBaseException {
        CertificateAuthority hostCA = this.getCA();
        AuthorityID aid = new AuthorityID();
        String aidString = aid.toString();
        String dn = "cn=" + aidString + "," + this.getAuthorityBaseDN();
        String dnString = null;
        try {
            dnString = hostCA.getX500Name().toLdapDNString();
        }
        catch (IOException e) {
            throw new EBaseException("Unable to convert issuer DN to string: " + e.getMessage(), (Throwable)e);
        }
        String desc = "Host authority";
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("objectclass", "authority"), new LDAPAttribute("cn", aidString), new LDAPAttribute("authorityID", aidString), new LDAPAttribute("authorityKeyNickname", hostCA.getNickname()), new LDAPAttribute("authorityEnabled", "TRUE"), new LDAPAttribute("authorityDN", dnString), new LDAPAttribute("description", desc)};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        LDAPEntry ldapEntry = new LDAPEntry(dn, attrSet);
        this.addAuthorityEntry(aid, ldapEntry);
        hostCA.setAuthorityID(aid);
        hostCA.setAuthorityDescription(desc);
        return aid;
    }

    public void updateAuthoritySerialNumber(AuthorityID aid, BigInteger serialNumber) throws Exception {
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(2, new LDAPAttribute("authoritySerial", serialNumber.toString()));
        this.modifyAuthorityEntry(aid, mods);
    }

    public void modifyAuthority(CertificateAuthority ca, Boolean enabled, String desc) throws EBaseException {
        CertificateAuthority hostCA = this.getCA();
        if (ca == hostCA && enabled != null && !enabled.booleanValue()) {
            throw new CATypeException("Cannot disable the host CA");
        }
        LDAPModificationSet mods = new LDAPModificationSet();
        boolean nextEnabled = ca.getAuthorityEnabled();
        if (enabled != null && enabled.booleanValue() != ca.getAuthorityEnabled()) {
            mods.add(2, new LDAPAttribute("authorityEnabled", enabled != false ? "TRUE" : "FALSE"));
            nextEnabled = enabled;
        }
        String nextDesc = ca.getAuthorityDescription();
        if (desc != null) {
            if (!desc.isEmpty() && ca.getAuthorityDescription() != null && !desc.equals(ca.getAuthorityDescription())) {
                mods.add(2, new LDAPAttribute("description", desc));
                nextDesc = desc;
            } else if (desc.isEmpty() && ca.getAuthorityDescription() != null) {
                mods.add(1, new LDAPAttribute("description", ca.getAuthorityDescription()));
                nextDesc = null;
            } else if (!desc.isEmpty() && ca.getAuthorityDescription() == null) {
                mods.add(0, new LDAPAttribute("description", desc));
                nextDesc = desc;
            }
        }
        if (mods.size() > 0) {
            this.modifyAuthorityEntry(ca.getAuthorityID(), mods);
            ca.setAuthorityEnabled(nextEnabled);
            ca.setAuthorityDescription(nextDesc);
        }
    }

    public void addAuthorityKeyHost(CertificateAuthority ca, String host) throws Exception {
        if (ca.getAuthorityKeyHosts().contains(host)) {
            return;
        }
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(0, new LDAPAttribute("authorityKeyHost", host));
        this.modifyAuthorityEntry(ca.getAuthorityID(), mods);
        ca.getAuthorityKeyHosts().add(host);
    }

    public ProfileSubsystem getProfileSubsystem() {
        return (ProfileSubsystem)this.getSubsystem("profile");
    }

    public ProfileSubsystem getProfileSubsystem(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "profile";
        }
        return (ProfileSubsystem)this.getSubsystem(name);
    }

    public void initCertificateRepository() throws Exception {
        logger.info("CAEngine: Initializing cert repository");
        ConfigStore caConfig = this.mConfig.getSubStore("ca", ConfigStore.class);
        int increment = caConfig.getInteger("certdbInc", 5);
        logger.info("CAEngine: - increment: " + increment);
        SecureRandom secureRandom = this.jssSubsystem.getRandomNumberGenerator();
        this.certificateRepository = new CertificateRepository(secureRandom, this.dbSubsystem);
        this.certificateRepository.setCMSEngine(this);
        this.certificateRepository.init();
    }

    public void initCrlDatabase() throws Exception {
        logger.info("CAEngine: Initializing CRL repository");
        this.crlRepository = new CRLRepository(this.dbSubsystem);
        this.crlRepository.setCMSEngine(this);
        this.crlRepository.init();
    }

    public void initReplicaIDRepository() throws Exception {
        logger.info("CAEngine: Initializing replica ID repository");
        this.replicaIDRepository = new ReplicaIDRepository(this.dbSubsystem);
        this.replicaIDRepository.setCMSEngine((CMSEngine)this);
        this.replicaIDRepository.init();
    }

    public void init() throws Exception {
        this.initCertificateRepository();
        this.initCrlDatabase();
        this.initReplicaIDRepository();
        super.init();
    }

    public boolean isRevoked(java.security.cert.X509Certificate[] certificates) {
        if (certificates == null) {
            return false;
        }
        X509CertImpl cert = (X509CertImpl)certificates[0];
        int result = 0;
        if (this.mVCList != null) {
            result = this.mVCList.check(cert);
        }
        if (result == 1) {
            return true;
        }
        if (result == 2 || result == 4) {
            return false;
        }
        boolean revoked = false;
        try {
            if (this.certificateRepository.isCertificateRevoked(cert) != null) {
                revoked = true;
                if (this.mVCList != null) {
                    this.mVCList.update(cert, 1);
                }
            } else if (this.mVCList != null) {
                this.mVCList.update(cert, 2);
            }
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_AUTH_AGENT_REVO_STATUS", (Object[])new Object[0]), (Throwable)e);
        }
        return revoked;
    }

    public ISharedToken createSharedTokenPlugin() {
        String className;
        String configName = "cmc.sharedSecret.class";
        try {
            className = this.mConfig.getString(configName);
        }
        catch (Exception e) {
            logger.error("Unable to get " + configName + ": " + e.getMessage(), (Throwable)e);
            return null;
        }
        logger.debug("CAEngine: shared secret plugin class:" + className);
        try {
            return (ISharedToken)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("Unable to create shared secret plugin: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getStartSerial() {
        try {
            BigInteger serial = this.certificateRepository.peekNextSerialNumber();
            if (serial == null) {
                return "";
            }
            return serial.toString(16);
        }
        catch (EBaseException e) {
            return "";
        }
    }

    public void setStartSerial(String serial) throws EBaseException {
        this.certificateRepository.setTheSerialNumber(new BigInteger(serial));
    }

    public String getMaxSerial() {
        BigInteger serial = this.certificateRepository.getMaxSerial();
        if (serial != null) {
            return serial.toString(this.certificateRepository.getRadix());
        }
        return "";
    }

    public void setMaxSerial(String serial) throws EBaseException {
        BigInteger maxSerial = new BigInteger(serial, this.certificateRepository.getRadix());
        this.certificateRepository.setMaxSerial(maxSerial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Long> getNonces(HttpServletRequest request, String name) {
        String lock;
        HttpSession session = request.getSession(true);
        if (session == null) {
            throw new PKIException("Unable to create session.");
        }
        String string = lock = request.getSession().getId().intern();
        synchronized (string) {
            Map nonces = (Map)session.getAttribute("nonces-" + name);
            if (nonces == null) {
                nonces = Collections.synchronizedMap(new Nonces(this.getMaxNonces()));
                session.setAttribute("nonces-" + name, nonces);
            }
            return nonces;
        }
    }

    public PKCS10 parsePKCS10(Locale locale, String certreq) throws Exception {
        PKCS10 tokenName2;
        block9: {
            boolean sigver;
            CryptoToken savedToken;
            CryptoManager cm;
            byte[] data;
            block7: {
                PKCS10 pKCS10;
                block8: {
                    logger.debug("CAEngine: Parsing PKCS #10 request");
                    if (certreq == null) {
                        logger.error("CAEngine: Missing PKCS #10 request");
                        throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]));
                    }
                    logger.debug(certreq);
                    data = CertUtil.parseCSR((String)certreq);
                    cm = CryptoManager.getInstance();
                    savedToken = null;
                    sigver = true;
                    sigver = this.config.getBoolean("ca.requestVerify.enabled", true);
                    if (!sigver) break block7;
                    logger.debug("CAEngine: signature verification enabled");
                    String tokenName2 = this.config.getString("ca.requestVerify.token", "internal");
                    savedToken = cm.getThreadToken();
                    CryptoToken signToken = CryptoUtil.getCryptoToken((String)tokenName2);
                    logger.debug("CAEngine: setting thread token");
                    cm.setThreadToken(signToken);
                    pKCS10 = new PKCS10(data);
                    if (!sigver) break block8;
                    logger.debug("CAEngine: restoring thread token");
                    cm.setThreadToken(savedToken);
                }
                return pKCS10;
            }
            try {
                logger.debug("CAEngine: signature verification disabled");
                tokenName2 = new PKCS10(data, sigver);
                if (!sigver) break block9;
            }
            catch (Exception e) {
                try {
                    logger.error("Unable to parse PKCS #10 request: " + e.getMessage(), (Throwable)e);
                    throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INVALID_REQUEST", (String[])new String[0]), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (sigver) {
                        logger.debug("CAEngine: restoring thread token");
                        cm.setThreadToken(savedToken);
                    }
                    throw throwable;
                }
            }
            logger.debug("CAEngine: restoring thread token");
            cm.setThreadToken(savedToken);
        }
        return tokenName2;
    }

    public void shutdownDatabase() {
        if (this.connectionFactory == null) {
            return;
        }
        try {
            this.connectionFactory.shutdown();
        }
        catch (Exception e) {
            logger.warn("CAEngine: Unable to shut down connection factory: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void shutdownSubsystems() {
        super.shutdownSubsystems();
        for (CRLIssuingPoint crlIssuingPoint : this.crlIssuingPoints.values()) {
            crlIssuingPoint.shutdown();
        }
        this.crlIssuingPoints.clear();
        CRLIssuingPoint masterCRLIssuingPoint = this.getMasterCRLIssuingPoint();
        if (masterCRLIssuingPoint != null) {
            masterCRLIssuingPoint.shutdown();
        }
        if (this.serialNumberUpdateTask != null) {
            this.serialNumberUpdateTask.stop();
        }
        if (this.certStatusUpdateTask != null) {
            this.certStatusUpdateTask.stop();
        }
        if (this.retrieveModificationsTask != null) {
            this.retrieveModificationsTask.stop();
        }
        if (this.certificateRepository != null) {
            this.certificateRepository.shutdown();
        }
        if (this.publisherProcessor != null) {
            this.publisherProcessor.shutdown();
        }
    }

    public void shutdownAuthorityMonitor() {
        if (this.authorityMonitor != null) {
            this.authorityMonitor.shutdown();
        }
        this.loader.shutdown();
    }

    public void shutdown() {
        this.shutdownAuthorityMonitor();
        super.shutdown();
    }

    static {
        authorities = Collections.synchronizedSortedMap(new TreeMap());
        entryUSNs = new TreeMap();
        nsUniqueIds = new TreeMap();
        deletedNsUniqueIds = new TreeSet();
    }
}

