/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.GeneralNameAsConstraintsConfig;
import org.dogtagpki.legacy.core.policy.GeneralNameConfig;
import org.dogtagpki.legacy.policy.IGeneralNameAsConstraintsConfig;
import org.mozilla.jss.netscape.security.x509.GeneralSubtree;

class Subtree {
    protected static final String PROP_BASE = "base";
    protected static final String PROP_MIN = "min";
    protected static final String PROP_MAX = "max";
    protected static final int DEF_MIN = 0;
    protected static final int DEF_MAX = -1;
    protected static final String MINMAX_INFO = "number;See RFC 2459 section 4.2.1.11";
    String mName = null;
    ConfigStore mConfig;
    int mMin = 0;
    int mMax = -1;
    IGeneralNameAsConstraintsConfig mBase = null;
    GeneralSubtree mGeneralSubtree = null;
    String mNameDot = null;
    String mNameDotMin = null;
    String mNameDotMax = null;

    public Subtree(String subtreeName, ConfigStore config, boolean policyEnabled) throws EBaseException {
        this.mName = subtreeName;
        this.mConfig = config;
        if (this.mName != null) {
            this.mNameDot = this.mName + ".";
            this.mNameDotMin = this.mNameDot + PROP_MIN;
            this.mNameDotMax = this.mNameDot + PROP_MAX;
        } else {
            this.mNameDot = "";
            this.mNameDotMin = PROP_MIN;
            this.mNameDotMax = PROP_MAX;
        }
        if (this.mConfig.size() == 0) {
            this.mConfig.putInteger(this.mNameDotMin, this.mMin);
            this.mConfig.putInteger(this.mNameDotMax, this.mMax);
        }
        this.mMin = this.mConfig.getInteger(PROP_MIN, 0);
        this.mMax = this.mConfig.getInteger(PROP_MAX, -1);
        if (this.mMax < -1) {
            this.mMax = -1;
        }
        this.mBase = new GeneralNameAsConstraintsConfig(this.mNameDot + PROP_BASE, this.mConfig.getSubStore(PROP_BASE, ConfigStore.class), true, policyEnabled);
        if (policyEnabled) {
            this.mGeneralSubtree = new GeneralSubtree(this.mBase.getGeneralName(), this.mMin, this.mMax);
        }
    }

    void getInstanceParams(Vector<String> instanceParams) {
        this.mBase.getInstanceParams(instanceParams);
        instanceParams.addElement(this.mNameDotMin + "=" + this.mMin);
        instanceParams.addElement(this.mNameDotMax + "=" + this.mMax);
    }

    static void getDefaultParams(String name, Vector<String> params) {
        Object nameDot = "";
        if (name != null && name.length() >= 0) {
            nameDot = name + ".";
        }
        GeneralNameConfig.getDefaultParams((String)((String)nameDot + PROP_BASE), (boolean)true, params);
        params.addElement((String)nameDot + "min=0");
        params.addElement((String)nameDot + "max=-1");
    }

    static void getExtendedPluginInfo(String name, Vector<String> info) {
        Object nameDot = "";
        if (name != null && name.length() > 0) {
            nameDot = name + ".";
        }
        GeneralNameConfig.getExtendedPluginInfo((String)((String)nameDot + PROP_BASE), (boolean)true, info);
        info.addElement((String)nameDot + "min;number;See RFC 2459 section 4.2.1.11");
        info.addElement((String)nameDot + "max;number;See RFC 2459 section 4.2.1.11");
    }
}

