/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveBasicConstraintsExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(RemoveBasicConstraintsExt.class);

    public RemoveBasicConstraintsExt() {
        this.NAME = "RemoveBasicConstraintsExt";
        this.DESC = "Remove Basic Constraints extension";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        X509CertInfo certInfo = null;
        if (ci == null || (certInfo = ci[0]) == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certResult = this.applyCert(req, certInfo);
            if (certResult != PolicyResult.REJECTED) continue;
            return certResult;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions != null) {
                try {
                    extensions.delete("BasicConstraints");
                    logger.debug("PolicyRule RemoveBasicConstraintsExt: removed the extension from request " + req.getRequestId().toString());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return PolicyResult.ACCEPTED;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        return defParams;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"HELP_TOKEN;configuration-policyrules-removebasicconstraints", "HELP_TEXT;Removes the Basic Constraints extension."};
        return params;
    }
}

