/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PolicyMap {
    public static Logger logger = LoggerFactory.getLogger(PolicyMap.class);
    protected static String PROP_ISSUER_DOMAIN_POLICY = "issuerDomainPolicy";
    protected static String PROP_SUBJECT_DOMAIN_POLICY = "subjectDomainPolicy";
    protected String mName = null;
    protected String mNameDot = null;
    protected ConfigStore mConfig;
    protected String mIssuerDomainPolicy = null;
    protected String mSubjectDomainPolicy = null;
    protected CertificatePolicyMap mCertificatePolicyMap = null;

    protected PolicyMap(String name, ConfigStore config, boolean enabled) throws EBaseException {
        this.mName = name;
        this.mConfig = config.getSubStore(this.mName, ConfigStore.class);
        this.mNameDot = this.mName + ".";
        if (this.mConfig == null) {
            logger.warn("PolicyMappingsExt::PolicyMap - mConfig is null!");
            return;
        }
        if (this.mConfig.size() == 0) {
            config.putString(this.mNameDot + PROP_ISSUER_DOMAIN_POLICY, "");
            config.putString(this.mNameDot + PROP_SUBJECT_DOMAIN_POLICY, "");
            this.mConfig = config.getSubStore(this.mName, ConfigStore.class);
            if (this.mConfig == null || this.mConfig.size() == 0) {
                logger.warn("PolicyMappingsExt::PolicyMap - mConfig is null or empty!");
                return;
            }
        }
        this.mIssuerDomainPolicy = this.mConfig.getString(PROP_ISSUER_DOMAIN_POLICY, null);
        this.mSubjectDomainPolicy = this.mConfig.getString(PROP_SUBJECT_DOMAIN_POLICY, null);
        if (this.mIssuerDomainPolicy != null && (this.mIssuerDomainPolicy.length() == 0 || this.mIssuerDomainPolicy.equals("null"))) {
            this.mIssuerDomainPolicy = null;
        }
        if (this.mSubjectDomainPolicy != null && (this.mSubjectDomainPolicy.length() == 0 || this.mSubjectDomainPolicy.equals("null"))) {
            this.mSubjectDomainPolicy = null;
        }
        String msg = "value cannot be null.";
        if (this.mIssuerDomainPolicy == null && enabled) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mNameDot + PROP_ISSUER_DOMAIN_POLICY, msg}));
        }
        if (this.mSubjectDomainPolicy == null && enabled) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mNameDot + PROP_SUBJECT_DOMAIN_POLICY, msg}));
        }
        ObjectIdentifier issuerPolicyId = null;
        ObjectIdentifier subjectPolicyId = null;
        if (this.mIssuerDomainPolicy != null) {
            issuerPolicyId = CertUtils.checkOID((String)(this.mNameDot + PROP_ISSUER_DOMAIN_POLICY), (String)this.mIssuerDomainPolicy);
        }
        if (this.mSubjectDomainPolicy != null) {
            subjectPolicyId = CertUtils.checkOID((String)(this.mNameDot + PROP_SUBJECT_DOMAIN_POLICY), (String)this.mSubjectDomainPolicy);
        }
        if (enabled) {
            this.mCertificatePolicyMap = new CertificatePolicyMap(new CertificatePolicyId(issuerPolicyId), new CertificatePolicyId(subjectPolicyId));
        }
    }

    protected void getInstanceParams(Vector<String> instanceParams) {
        instanceParams.addElement(this.mNameDot + PROP_ISSUER_DOMAIN_POLICY + "=" + (this.mIssuerDomainPolicy == null ? "" : this.mIssuerDomainPolicy));
        instanceParams.addElement(this.mNameDot + PROP_SUBJECT_DOMAIN_POLICY + "=" + (this.mSubjectDomainPolicy == null ? "" : this.mSubjectDomainPolicy));
    }
}

