/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.GeneralNamesConfig;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IGeneralNamesConfig;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.IssuerAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class IssuerAltNameExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static final String PROP_CRITICAL = "critical";
    public static final boolean DEFAULT_CRITICALITY = false;
    private static Vector<String> defaultParams = new Vector();
    private static String[] mInfo = null;
    private Vector<String> mParams = new Vector();
    private ConfigStore mConfig;
    private boolean mCritical = false;
    private boolean mEnabled = false;
    IGeneralNamesConfig mGNs = null;
    IssuerAlternativeNameExtension mExtension = null;

    public IssuerAltNameExt() {
        this.NAME = "IssuerAltNameExt";
        this.DESC = "Associate Internet-style Identities with Issuer";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mGNs = new GeneralNamesConfig(null, config, true, this.mEnabled);
        try {
            if (this.mEnabled && this.mGNs.getGeneralNames() != null && !this.mGNs.getGeneralNames().isEmpty()) {
                this.mExtension = new IssuerAlternativeNameExtension(Boolean.valueOf(this.mCritical), this.mGNs.getGeneralNames());
            }
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        this.mParams.addElement("critical=" + this.mCritical);
        this.mGNs.getInstanceParams(this.mParams);
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        if (!this.mEnabled || this.mExtension == null) {
            return res;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (extensions == null) {
            extensions = new CertificateExtensions();
            try {
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            }
            catch (CertificateException certificateException) {
            }
            catch (Exception exception) {}
        } else {
            try {
                extensions.delete("IssuerAlternativeName");
            }
            catch (IOException e) {
                try {
                    extensions.delete("2.5.29.18");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            extensions.set("IssuerAlternativeName", (Object)this.mExtension);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_ALT_NAME_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_KEY_ID_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        return PolicyResult.ACCEPTED;
    }

    public Vector<String> getInstanceParams() {
        return this.mParams;
    }

    public Vector<String> getDefaultParams() {
        return defaultParams;
    }

    public String[] getExtendedPluginInfo() {
        return mInfo;
    }

    static {
        defaultParams.addElement("critical=false");
        GeneralNamesConfig.getDefaultParams(null, (boolean)true, defaultParams);
        Vector<String> info = new Vector<String>();
        info.addElement("critical;boolean;RFC 2459 recommendation: SHOULD NOT be marked critical.");
        info.addElement("HELP_TOKEN;configuration-policyrules-issueraltname");
        info.addElement("HELP_TEXT;This policy inserts the Issuer Alternative Name Extension into the certificate. See RFC 2459 (4.2.1.8). ");
        GeneralNamesConfig.getExtendedPluginInfo(null, (boolean)true, info);
        mInfo = new String[info.size()];
        info.copyInto(mInfo);
    }
}

