/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.legacy.server.policy.extensions.CertPolicy;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificatePoliciesExtension;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePoliciesExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CertificatePoliciesExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_NUM_CERTPOLICIES = "numCertPolicies";
    protected static final String PROP_CERTPOLICY = "certPolicy";
    protected static final boolean DEF_CRITICAL = false;
    protected static final int DEF_NUM_CERTPOLICIES = 1;
    protected boolean mEnabled = false;
    protected ConfigStore mConfig;
    protected boolean mCritical = false;
    protected int mNumCertPolicies = 1;
    protected CertPolicy[] mCertPolicies = null;
    protected Vector<String> mInstanceParams = new Vector();
    protected CertificatePoliciesExtension mCertificatePoliciesExtension = null;
    private static Vector<String> mDefParams = new Vector();

    public CertificatePoliciesExt() {
        this.NAME = "CertificatePoliciesExt";
        this.DESC = "Sets non-critical certificate policies extension in certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        int i;
        this.mConfig = config;
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mNumCertPolicies = this.mConfig.getInteger(PROP_NUM_CERTPOLICIES, 1);
        if (this.mNumCertPolicies < 1) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_ATTR_VALUE_2", (Object[])new Object[]{this.NAME, ""}));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_NUM_CERTPOLICIES, "value must be greater than or equal to 1"}));
        }
        this.mCertPolicies = new CertPolicy[this.mNumCertPolicies];
        for (i = 0; i < this.mNumCertPolicies; ++i) {
            String subtreeName = PROP_CERTPOLICY + i;
            try {
                this.mCertPolicies[i] = new CertPolicy(subtreeName, this.mConfig, this.mEnabled);
                continue;
            }
            catch (EBaseException e) {
                logger.error(this.NAME + ": " + CMS.getLogMessage((String)"POLICY_ERROR_CREATE_CERT_POLICY", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw e;
            }
        }
        if (this.mEnabled) {
            try {
                Vector<CertificatePolicyInfo> CertPolicies = new Vector<CertificatePolicyInfo>();
                for (int j = 0; j < this.mNumCertPolicies; ++j) {
                    CertPolicies.addElement(this.mCertPolicies[j].mCertificatePolicyInfo);
                }
                this.mCertificatePoliciesExtension = new CertificatePoliciesExtension(this.mCritical, CertPolicies);
            }
            catch (IOException e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Error initializing " + this.NAME + " Error: " + e}));
            }
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("numCertPolicies=" + this.mNumCertPolicies);
        for (i = 0; i < this.mNumCertPolicies; ++i) {
            this.mCertPolicies[i].getInstanceParams(this.mInstanceParams);
        }
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions == null) {
                extensions = new CertificateExtensions();
                try {
                    certInfo.set("version", (Object)new CertificateVersion(2));
                    certInfo.set("extensions", (Object)extensions);
                }
                catch (Exception exception) {}
            } else {
                try {
                    extensions.delete("CertificatePolicies");
                }
                catch (IOException e) {
                    try {
                        extensions.delete("2.5.29.32");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            extensions.set("CertificatePolicies", (Object)this.mCertificatePoliciesExtension);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_ERROR_CERTIFICATE_POLICIES_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CERTIFICATE_POLICIES_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_ERROR_CERTIFICATE_POLICIES_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CERTIFICATE_POLICIES_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_ERROR_CERTIFICATE_POLICIES_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CERTIFICATE_POLICIES_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        return PolicyResult.ACCEPTED;
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    public String[] getExtendedPluginInfo() {
        Vector<Object> theparams = new Vector<Object>();
        theparams.addElement("critical;boolean;RFC 3280 recommendation: MUST be non-critical.");
        theparams.addElement("numCertPolicies;number; Number of certificate policies. The value must be greater than or equal to 1");
        for (int k = 0; k < 5; ++k) {
            String certPolicykDot = PROP_CERTPOLICY + k + ".";
            theparams.addElement(certPolicykDot + "policyId;string,required;An object identifier in the form n.n.n.n");
            theparams.addElement(certPolicykDot + "noticeRefOrganization;string;See RFC 3280 sec 4.2.1.5");
            theparams.addElement(certPolicykDot + "noticeRefNumbers;string;comma-separated list of numbers. See RFC 3280 sec 4.2.1.5");
            theparams.addElement(certPolicykDot + "userNoticeExplicitText;string;See RFC 3280 sec 4.2.1.5");
            theparams.addElement(certPolicykDot + "cpsURI;string;See RFC 3280 sec 4.2.1.5");
        }
        theparams.addElement("HELP_TOKEN;configuration-policyrules-certificatepolicies");
        theparams.addElement("HELP_TEXT;Adds Certificate Policies Extension. See RFC 3280 (4.2.1.5)");
        Object[] params = new String[theparams.size()];
        theparams.copyInto(params);
        return params;
    }

    static {
        mDefParams.addElement("critical=false");
        mDefParams.addElement("numCertPolicies=1");
        String certPolicy0Dot = "certPolicy0.";
        mDefParams.addElement(certPolicy0Dot + "policyId=");
        mDefParams.addElement(certPolicy0Dot + "noticeRefOrganization=");
        mDefParams.addElement(certPolicy0Dot + "noticeRefNumbers=");
        mDefParams.addElement(certPolicy0Dot + "userNoticeExplicitText=");
        mDefParams.addElement(certPolicy0Dot + "cpsURI=");
    }
}

