/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.DisplayText;
import org.mozilla.jss.netscape.security.x509.NoticeReference;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;
import org.mozilla.jss.netscape.security.x509.Qualifier;
import org.mozilla.jss.netscape.security.x509.UserNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CertPolicy {
    public static Logger logger = LoggerFactory.getLogger(CertPolicy.class);
    protected static final String PROP_POLICY_IDENTIFIER = "policyId";
    protected static final String PROP_NOTICE_REF_ORG = "noticeRefOrganization";
    protected static final String PROP_NOTICE_REF_NUMS = "noticeRefNumbers";
    protected static final String PROP_USER_NOTICE_TEXT = "userNoticeExplicitText";
    protected static final String PROP_CPS_URI = "cpsURI";
    protected String mName = null;
    protected String mNameDot = null;
    protected ConfigStore mConfig;
    protected String mPolicyId = null;
    protected String mNoticeRefOrg = null;
    protected String mNoticeRefNums = null;
    protected String mNoticeRefExplicitText = null;
    protected String mCpsUri = null;
    protected CertificatePolicyInfo mCertificatePolicyInfo = null;

    protected CertPolicy(String name, ConfigStore config, boolean enabled) throws EBaseException {
        this.mName = name;
        this.mConfig = config.getSubStore(this.mName, ConfigStore.class);
        this.mNameDot = this.mName + ".";
        if (this.mConfig == null) {
            logger.error("CertificatePoliciesExt::CertPolicy - mConfig is null!");
            throw new EBaseException("mConfig is null");
        }
        if (this.mConfig.size() == 0) {
            config.putString(this.mNameDot + PROP_POLICY_IDENTIFIER, "");
            config.putString(this.mNameDot + PROP_NOTICE_REF_ORG, "");
            config.putString(this.mNameDot + PROP_NOTICE_REF_NUMS, "");
            config.putString(this.mNameDot + PROP_USER_NOTICE_TEXT, "");
            config.putString(this.mNameDot + PROP_CPS_URI, "");
            this.mConfig = config.getSubStore(this.mName, ConfigStore.class);
            if (this.mConfig == null || this.mConfig.size() == 0) {
                logger.error("CertificatePoliciesExt::CertPolicy - mConfig is null or empty!");
                throw new EBaseException("mConfig is null or empty");
            }
        }
        this.mPolicyId = this.mConfig.getString(PROP_POLICY_IDENTIFIER, null);
        this.mNoticeRefOrg = this.mConfig.getString(PROP_NOTICE_REF_ORG, null);
        this.mNoticeRefNums = this.mConfig.getString(PROP_NOTICE_REF_NUMS, null);
        this.mNoticeRefExplicitText = this.mConfig.getString(PROP_USER_NOTICE_TEXT, null);
        this.mCpsUri = this.mConfig.getString(PROP_CPS_URI, null);
        if (this.mPolicyId != null && (this.mPolicyId.length() == 0 || this.mPolicyId.equals("null"))) {
            this.mPolicyId = null;
        }
        if (this.mNoticeRefOrg != null && (this.mNoticeRefOrg.length() == 0 || this.mNoticeRefOrg.equals("null"))) {
            this.mNoticeRefOrg = null;
        }
        if (this.mNoticeRefNums != null && (this.mNoticeRefNums.length() == 0 || this.mNoticeRefNums.equals("null"))) {
            this.mNoticeRefNums = null;
        }
        if (this.mNoticeRefExplicitText != null && (this.mNoticeRefExplicitText.length() == 0 || this.mNoticeRefExplicitText.equals("null"))) {
            this.mNoticeRefExplicitText = null;
        }
        if (this.mCpsUri != null && (this.mCpsUri.length() == 0 || this.mCpsUri.equals("null"))) {
            this.mCpsUri = null;
        }
        String msg = "value cannot be null.";
        if (this.mPolicyId == null && enabled) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mNameDot + PROP_POLICY_IDENTIFIER, msg}));
        }
        msg = "NoticeReference is optional; If chosen to include, NoticeReference must at least has 'organization'";
        if (this.mNoticeRefOrg == null && this.mNoticeRefNums != null && enabled) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mNameDot + PROP_NOTICE_REF_ORG, msg}));
        }
        if (this.mPolicyId != null) {
            CertUtils.checkOID((String)(this.mNameDot + PROP_POLICY_IDENTIFIER), (String)this.mPolicyId);
        }
        if (enabled) {
            logger.debug("CertPolicy: in CertPolicy");
            DisplayText displayText = null;
            if (this.mNoticeRefExplicitText != null && !this.mNoticeRefExplicitText.equals("")) {
                displayText = new DisplayText(26, this.mNoticeRefExplicitText);
            }
            DisplayText orgName = null;
            if (this.mNoticeRefOrg != null && !this.mNoticeRefOrg.equals("")) {
                orgName = new DisplayText(26, this.mNoticeRefOrg);
            }
            int[] nums = new int[]{};
            if (this.mNoticeRefNums != null && !this.mNoticeRefNums.equals("")) {
                Vector<String> numsVector = new Vector<String>();
                StringTokenizer tokens = new StringTokenizer(this.mNoticeRefNums, ",");
                while (tokens.hasMoreTokens()) {
                    String num = tokens.nextToken().trim();
                    numsVector.addElement(num);
                }
                nums = new int[numsVector.size()];
                for (int i = 0; i < numsVector.size(); ++i) {
                    Integer ii = Integer.valueOf((String)numsVector.elementAt(i));
                    nums[i] = ii;
                }
            }
            CertificatePolicyId cpolicyId = null;
            try {
                cpolicyId = new CertificatePolicyId(ObjectIdentifier.getObjectIdentifier((String)this.mPolicyId));
            }
            catch (Exception e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_POLICY_CERTIFICATE_POLICIES_ERROR", (String[])new String[]{this.mPolicyId}));
            }
            PolicyQualifiers policyQualifiers = new PolicyQualifiers();
            NoticeReference noticeReference = null;
            if (orgName != null) {
                noticeReference = new NoticeReference(orgName, nums);
            }
            UserNotice userNotice = null;
            if (displayText != null || noticeReference != null) {
                userNotice = new UserNotice(noticeReference, displayText);
                PolicyQualifierInfo policyQualifierInfo1 = new PolicyQualifierInfo(PolicyQualifierInfo.QT_UNOTICE, (Qualifier)userNotice);
                policyQualifiers.add(policyQualifierInfo1);
            }
            CPSuri cpsUri = null;
            if (this.mCpsUri != null && this.mCpsUri.length() > 0) {
                cpsUri = new CPSuri(this.mCpsUri);
                PolicyQualifierInfo policyQualifierInfo2 = new PolicyQualifierInfo(PolicyQualifierInfo.QT_CPS, (Qualifier)cpsUri);
                policyQualifiers.add(policyQualifierInfo2);
            }
            if (!(this.mNoticeRefOrg != null && !this.mNoticeRefOrg.equals("") || this.mNoticeRefExplicitText != null && !this.mNoticeRefExplicitText.equals("") || this.mCpsUri != null && !this.mCpsUri.equals(""))) {
                logger.debug("CertPolicy mNoticeRefOrg = " + this.mNoticeRefOrg);
                logger.debug("CertPolicy mNoticeRefExplicitText = " + this.mNoticeRefExplicitText);
                logger.debug("CertPolicy mCpsUri = " + this.mCpsUri);
                this.mCertificatePolicyInfo = new CertificatePolicyInfo(cpolicyId);
            } else {
                logger.debug("CertPolicy mNoticeRefOrg = " + this.mNoticeRefOrg);
                logger.debug("CertPolicy mNoticeRefExplicitText = " + this.mNoticeRefExplicitText);
                logger.debug("CertPolicy mCpsUri = " + this.mCpsUri);
                this.mCertificatePolicyInfo = new CertificatePolicyInfo(cpolicyId, policyQualifiers);
            }
        }
    }

    protected void getInstanceParams(Vector<String> instanceParams) {
        instanceParams.addElement(this.mNameDot + "policyId=" + (this.mPolicyId == null ? "" : this.mPolicyId));
        instanceParams.addElement(this.mNameDot + "noticeRefOrganization=" + (this.mNoticeRefOrg == null ? "" : this.mNoticeRefOrg));
        instanceParams.addElement(this.mNameDot + "noticeRefNumbers=" + (this.mNoticeRefNums == null ? "" : this.mNoticeRefNums));
        instanceParams.addElement(this.mNameDot + "userNoticeExplicitText=" + (this.mNoticeRefExplicitText == null ? "" : this.mNoticeRefExplicitText));
        instanceParams.addElement(this.mNameDot + "cpsURI=" + (this.mCpsUri == null ? "" : this.mCpsUri));
    }
}

