/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.legacy.server.policy.extensions.DistPointParams;
import org.dogtagpki.legacy.server.policy.extensions.NameType;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPoint;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPointsExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDistributionPointsExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CRLDistributionPointsExt.class);
    public static final String PROP_IS_CRITICAL = "critical";
    public static final String PROP_NUM_POINTS = "numPoints";
    public static final String PROP_POINT_TYPE = "pointType";
    public static final String PROP_POINT_NAME = "pointName";
    public static final String PROP_REASONS = "reasons";
    public static final String PROP_ISSUER_NAME = "issuerName";
    public static final String PROP_ISSUER_TYPE = "issuerType";
    private static final int MAX_POINTS = 10;
    private static final int DEFAULT_NUM_BLANK_POINTS = 3;
    private int mNumPoints = 3;
    public static final boolean DEFAULT_CRITICALITY = false;
    private Vector<String> defaultParams = new Vector();
    private Vector<String> mParams = new Vector();
    private String[] mExtParams = null;
    private CRLDistributionPointsExtension mCrldpExt = null;

    public CRLDistributionPointsExt() {
        this.NAME = "CRLDistributionPointsExt";
        this.DESC = "Sets CRL distribution points extension";
        this.defaultParams.addElement("critical=false");
        this.defaultParams.addElement("numPoints=0");
        for (int i = 0; i < 3; ++i) {
            this.defaultParams.addElement(PROP_POINT_NAME + i + "=");
            this.defaultParams.addElement(PROP_POINT_TYPE + i + "=");
            this.defaultParams.addElement(PROP_REASONS + i + "=");
            this.defaultParams.addElement(PROP_ISSUER_NAME + i + "=");
            this.defaultParams.addElement(PROP_ISSUER_TYPE + i + "=");
        }
    }

    private void setExtendedPluginInfo() {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < 10; ++i) {
            v.addElement(PROP_POINT_TYPE + Integer.toString(i) + ";choice(DirectoryName,URI,RelativeToIssuer);The type of the CRL distribution point.");
            v.addElement(PROP_POINT_NAME + Integer.toString(i) + ";string;The name of the CRL distribution point depending on the CRLDP type.");
            v.addElement(PROP_REASONS + Integer.toString(i) + ";string;The revocation reasons for the CRL maintained at this distribution point. It's a comma-seperated list of the following constants: unused, keyCompromise, cACompromise, affiliationChanged, superseded, cessationOfOperation, certificateHold.");
            v.addElement(PROP_ISSUER_TYPE + Integer.toString(i) + ";choice(DirectoryName,URI);The type of the issuer that has signed the CRL maintained at this distribution point.");
            v.addElement(PROP_ISSUER_NAME + Integer.toString(i) + ";string;The name of the issuer that has signed the CRL maintained at this distribution point. The value depends on the issuer type.");
        }
        v.addElement("numPoints;number;The total number of CRL distribution points to be contained or allowed in the extension.");
        v.addElement("critical;boolean;RFC 2459 recommendation: SHOULD be non-critical. But recommends support for this extension by CAs and applications.");
        v.addElement("HELP_TOKEN;configuration-policyrules-crldistributionpoints");
        v.addElement("HELP_TEXT;This policy inserts the CRL Distribution Points Extension into the certificate. See RFC 2459 (4.2.1.14). ");
        this.mExtParams = Utils.getStringArrayFromVector(v);
    }

    public String[] getExtendedPluginInfo() {
        if (this.mExtParams == null) {
            this.setExtendedPluginInfo();
        }
        return this.mExtParams;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        try {
            OIDMap.addAttribute((String)CRLDistributionPointsExtension.class.getName(), (String)"2.5.29.31", (String)"CRLDistributionPoints");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        int numPoints = config.getInteger(PROP_NUM_POINTS, 0);
        this.mParams.addElement("numPoints=" + numPoints);
        this.mNumPoints = numPoints;
        for (int i = 0; i < numPoints; ++i) {
            DistPointParams params = new DistPointParams();
            params.pointType = config.getString(PROP_POINT_TYPE + i, "");
            params.pointName = config.getString(PROP_POINT_NAME + i, "");
            params.reasons = config.getString(PROP_REASONS + i, "");
            params.issuerType = config.getString(PROP_ISSUER_TYPE + i, "");
            params.issuerName = config.getString(PROP_ISSUER_NAME + i, "");
            DistPointParams configparams = new DistPointParams(params);
            CRLDistributionPoint crldp = this.DPParamsToDP(params);
            this.mParams.addElement(PROP_POINT_TYPE + i + "=" + configparams.pointType);
            this.mParams.addElement(PROP_POINT_NAME + i + "=" + configparams.pointName);
            this.mParams.addElement(PROP_REASONS + i + "=" + configparams.reasons);
            this.mParams.addElement(PROP_ISSUER_TYPE + i + "=" + configparams.issuerType);
            this.mParams.addElement(PROP_ISSUER_NAME + i + "=" + configparams.issuerName);
            if (this.mCrldpExt == null) {
                this.mCrldpExt = new CRLDistributionPointsExtension(crldp);
                continue;
            }
            this.mCrldpExt.addPoint(crldp);
        }
        boolean crit = config.getBoolean(PROP_IS_CRITICAL, false);
        this.mParams.addElement("critical=" + crit);
        if (this.mCrldpExt != null) {
            this.mCrldpExt.setCritical(crit);
        }
        this.setExtendedPluginInfo();
    }

    private CRLDistributionPoint DPParamsToDP(DistPointParams params) throws EBaseException {
        CRLDistributionPoint crlDP;
        block23: {
            crlDP = new CRLDistributionPoint();
            try {
                NameType nType;
                if (params.pointName != null && params.pointName.length() == 0) {
                    params.pointName = null;
                }
                if (params.pointType != null && params.pointType.length() == 0) {
                    params.pointType = null;
                }
                if (params.reasons != null && params.reasons.length() == 0) {
                    params.reasons = null;
                }
                if (params.issuerName != null && params.issuerName.length() == 0) {
                    params.issuerName = null;
                }
                if (params.issuerType != null && params.issuerType.length() == 0) {
                    params.issuerType = null;
                }
                if (params.pointName != null && params.pointType != null) {
                    nType = NameType.fromString(params.pointType);
                    if (nType == null) {
                        String err = "Unknown name type: " + params.pointType;
                        logger.error(CMS.getLogMessage((String)"CA_UNKNOWN_NAME_TYPE", (Object[])new Object[]{params.pointType}));
                        throw new EBaseException(err);
                    }
                    if (nType == NameType.DIRECTORY_NAME) {
                        gen = new GeneralNames();
                        gen.addElement((Object)new GeneralName((GeneralNameInterface)new X500Name(params.pointName)));
                        crlDP.setFullName(gen);
                    } else if (nType == NameType.URI) {
                        gen = new GeneralNames();
                        gen.addElement((Object)new GeneralName((GeneralNameInterface)new URIName(params.pointName)));
                        crlDP.setFullName(gen);
                    } else if (nType == NameType.RELATIVE_TO_ISSUER) {
                        crlDP.setRelativeName(new RDN(params.pointName));
                    } else {
                        String err = "Unknown name type: " + nType.toString();
                        logger.error(CMS.getLogMessage((String)"CA_UNKNOWN_NAME_TYPE", (Object[])new Object[]{nType.toString()}));
                        throw new EBaseException(err);
                    }
                }
                if (params.reasons != null) {
                    StringTokenizer tok = new StringTokenizer(params.reasons, ", \t");
                    byte reasonBits = 0;
                    while (tok.hasMoreTokens()) {
                        String s = tok.nextToken();
                        CRLDistributionPointsExtension.Reason r = CRLDistributionPointsExtension.Reason.fromString((String)s);
                        if (r == null) {
                            logger.error(CMS.getLogMessage((String)"CA_UNKNOWN_REASON", (Object[])new Object[]{s}));
                            throw new EBaseException("Unknown reason: " + s);
                        }
                        reasonBits = (byte)(reasonBits | r.getBitMask());
                    }
                    if (reasonBits != 0) {
                        BitArray ba = new BitArray(8, new byte[]{reasonBits});
                        crlDP.setReasons(ba);
                    }
                }
                if (params.issuerName == null || params.issuerType == null) break block23;
                nType = NameType.fromString(params.issuerType);
                if (nType == null) {
                    String err = "Unknown name type: " + params.issuerType;
                    logger.error(CMS.getLogMessage((String)"CA_UNKNOWN_NAME_TYPE", (Object[])new Object[]{params.issuerType}));
                    throw new EBaseException(err);
                }
                if (nType == NameType.DIRECTORY_NAME) {
                    GeneralNames gen = new GeneralNames();
                    gen.addElement((Object)new GeneralName((GeneralNameInterface)new X500Name(params.issuerName)));
                    crlDP.setCRLIssuer(gen);
                    break block23;
                }
                if (nType == NameType.URI) {
                    GeneralNames gen = new GeneralNames();
                    gen.addElement((Object)new GeneralName((GeneralNameInterface)new URIName(params.issuerName)));
                    crlDP.setCRLIssuer(gen);
                    break block23;
                }
                String err = "Unknown name type: " + nType.toString();
                logger.error(CMS.getLogMessage((String)"CA_UNKNOWN_NAME_TYPE", (Object[])new Object[]{nType.toString()}));
                throw new EBaseException(err);
            }
            catch (GeneralNamesException e) {
                throw new EBaseException(e.getMessage());
            }
            catch (IOException e) {
                throw new EBaseException(e.getMessage());
            }
        }
        return crlDP;
    }

    public PolicyResult apply(Request req) {
        if (this.mCrldpExt == null) {
            return PolicyResult.ACCEPTED;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            } else {
                try {
                    extensions.delete("CRLDistributionPoints");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            extensions.set("CRLDistributionPoints", (Object)this.mCrldpExt);
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR", (Object[])new Object[]{this.NAME, e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getDefaultParams() {
        for (int i = 3; i < this.mNumPoints; ++i) {
            this.defaultParams.addElement(PROP_POINT_NAME + i + "=");
            this.defaultParams.addElement(PROP_POINT_TYPE + i + "=");
            this.defaultParams.addElement(PROP_REASONS + i + "=");
            this.defaultParams.addElement(PROP_ISSUER_NAME + i + "=");
            this.defaultParams.addElement(PROP_ISSUER_TYPE + i + "=");
        }
        return this.defaultParams;
    }

    public Vector<String> getInstanceParams() {
        return this.mParams;
    }
}

