/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Date;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.IRevocationPolicy;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationConstraints
extends APolicyRule
implements IRevocationPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(RevocationConstraints.class);
    private static final String PROP_ALLOW_EXPIRED_CERTS = "allowExpiredCerts";
    private static final String PROP_ALLOW_ON_HOLD = "allowOnHold";
    private boolean mAllowExpiredCerts = true;
    private boolean mAllowOnHold = true;
    private static final Vector<String> defConfParams = new Vector();

    public RevocationConstraints() {
        this.NAME = "RevocationConstraints";
        this.DESC = "Whether to allow revocation of expired certs and on-hold.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"allowExpiredCerts;boolean;Allow a user to revoke an already-expired certificate", "allowOnHold;boolean;Allow a user to set reason to On-Hold", "HELP_TOKEN;configuration-policyrules-revocationconstraints", "HELP_TEXT;Allow administrator to decide policy on whether to allow recovation of expired certificatesand set reason to On-Hold"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        try {
            this.mAllowExpiredCerts = config.getBoolean(PROP_ALLOW_EXPIRED_CERTS, true);
            this.mAllowOnHold = config.getBoolean(PROP_ALLOW_ON_HOLD, true);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        logger.debug("RevocationConstraints: allow expired certs " + this.mAllowExpiredCerts);
        logger.debug("RevocationConstraints: allow on hold " + this.mAllowOnHold);
    }

    public PolicyResult apply(Request req) {
        int reason;
        logger.debug("RevocationConstraints: apply begins");
        if (req.getExtDataInInteger("revocationReason") == null) {
            logger.debug("RevocationConstraints: apply: no revocationReason found in request");
            return PolicyResult.REJECTED;
        }
        RevocationReason rr = RevocationReason.valueOf((int)req.getExtDataInInteger("revocationReason"));
        if (!this.mAllowOnHold && rr != null && (reason = rr.getCode()) == RevocationReason.CERTIFICATE_HOLD.getCode()) {
            String[] params = new String[]{this.getInstanceName()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_ON_HOLD_ALLOWED", (String[])params), "");
            return PolicyResult.REJECTED;
        }
        if (this.mAllowExpiredCerts) {
            return PolicyResult.ACCEPTED;
        }
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertImpl[] oldCerts = req.getExtDataInCertArray("OLD_CERTS");
            if (oldCerts == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_OLD_CERT", (String[])new String[0]), this.getInstanceName());
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < oldCerts.length; ++i) {
                Date now;
                X509CertInfo oldCertInfo = (X509CertInfo)oldCerts[i].get("x509.info");
                CertificateValidity oldValidity = (CertificateValidity)oldCertInfo.get("validity");
                Date notAfter = (Date)oldValidity.get("notAfter");
                if (!notAfter.before(now = new Date())) continue;
                String[] params = new String[]{this.getInstanceName()};
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_CANNOT_REVOKE_EXPIRED_CERTS", (String[])params), "");
                result = PolicyResult.REJECTED;
                break;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("allowExpiredCerts=" + this.mAllowExpiredCerts);
        confParams.addElement("allowOnHold=" + this.mAllowOnHold);
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    static {
        defConfParams.addElement("allowExpiredCerts=true");
        defConfParams.addElement("allowOnHold=true");
    }
}

