/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Date;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.IRenewalPolicy;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class RenewalValidityConstraints
extends APolicyRule
implements IRenewalPolicy,
IExtendedPluginInfo {
    private long mMinValidity;
    private long mMaxValidity;
    private long mRenewalInterval;
    private static final String PROP_MIN_VALIDITY = "minValidity";
    private static final String PROP_MAX_VALIDITY = "maxValidity";
    private static final String PROP_RENEWAL_INTERVAL = "renewalInterval";
    public static final int DEF_MIN_VALIDITY = 180;
    public static final int DEF_MAX_VALIDITY = 730;
    public static final long DEF_RENEWAL_INTERVAL = 15L;
    public static final long DAYS_TO_MS_FACTOR = 86400000L;
    private static final Vector<String> defConfParams = new Vector();

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"minValidity;number;Specifies the minimum validity period, in days, for renewed certificates.", "maxValidity;number;Specifies the maximum validity period, in days, for renewed certificates.", "renewalInterval;number;Specifies how many days before its expiration that a certificate can be renewed.", "HELP_TOKEN;configuration-policyrules-renewalvalidityconstraints", "HELP_TEXT;Reject renewal request if the certificate is too far before it's expiry date"};
        return params;
    }

    public RenewalValidityConstraints() {
        this.NAME = "RenewalValidityConstraints";
        this.DESC = "Enforces minimum and maximum validity and renewal interval for certificate renewal.";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        try {
            String val = config.getString(PROP_MIN_VALIDITY, null);
            this.mMinValidity = val == null ? 15552000000L : Long.parseLong(val) * 86400000L;
            val = config.getString(PROP_MAX_VALIDITY, null);
            this.mMaxValidity = val == null ? 63072000000L : Long.parseLong(val) * 86400000L;
            val = config.getString(PROP_RENEWAL_INTERVAL, null);
            this.mRenewalInterval = val == null ? 1296000000L : Long.parseLong(val) * 86400000L;
            if (this.mMinValidity > this.mMaxValidity) {
                String[] params = new String[]{this.getInstanceName(), String.valueOf(this.mMinValidity / 86400000L), String.valueOf(this.mMaxValidity / 86400000L)};
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_RENEWAL_MIN_MAX", (String[])params));
            }
            if (this.mRenewalInterval > this.mMaxValidity) {
                String[] params = new String[]{this.getInstanceName(), String.valueOf(this.mRenewalInterval / 86400000L), String.valueOf(this.mMaxValidity / 86400000L)};
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_RENEWAL_INTERVAL", (String[])params));
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])params));
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        if (this.agentApproved(req)) {
            return result;
        }
        try {
            X509CertInfo[] certInfo = req.getExtDataInCertInfoArray("CERT_INFO");
            X509CertImpl[] currentCerts = req.getExtDataInCertArray("OLD_CERTS");
            if (certInfo == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            if (currentCerts == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_OLD_CERT", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            if (certInfo.length != currentCerts.length) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_MISMATCHED_CERTINFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfo.length; ++i) {
                long interval;
                Date now;
                X509CertInfo oldCertInfo = (X509CertInfo)currentCerts[i].get("x509.info");
                CertificateValidity oldValidity = (CertificateValidity)oldCertInfo.get("validity");
                Date notAfter = (Date)oldValidity.get("notAfter");
                if (notAfter.after(now = new Date()) && (interval = notAfter.getTime() - now.getTime()) > this.mRenewalInterval) {
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_LONG_RENEWAL_LEAD_TIME", (String[])new String[]{this.getInstanceName(), String.valueOf(this.mRenewalInterval / 86400000L)}), "");
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_EXISTING_CERT_DETAILS", (String[])new String[]{this.getInstanceName(), this.getCertDetails(req, currentCerts[i])}), "");
                    result = PolicyResult.REJECTED;
                    this.setDummyValidity(certInfo[i]);
                    continue;
                }
                Date renewedNotBef = notAfter;
                Date renewedNotAfter = new Date(notAfter.getTime() + this.mMaxValidity);
                if (renewedNotAfter.before(now) || renewedNotAfter.getTime() - now.getTime() <= this.mRenewalInterval) {
                    renewedNotBef = now;
                    renewedNotAfter = new Date(now.getTime() + this.mMaxValidity);
                }
                CertificateValidity newValidity = new CertificateValidity(renewedNotBef, renewedNotAfter);
                certInfo[i].set("validity", (Object)newValidity);
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("minValidity=" + this.mMinValidity / 86400000L);
        confParams.addElement("maxValidity=" + this.mMaxValidity / 86400000L);
        confParams.addElement("renewalInterval=" + this.mRenewalInterval / 86400000L);
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    private void setDummyValidity(X509CertInfo certInfo) {
        try {
            certInfo.set("validity", (Object)new CertificateValidity(new Date(), new Date()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCertDetails(Request req, X509CertImpl cert) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("Serial No: " + cert.getSerialNumber().toString(16));
        sb.append("\n");
        sb.append("Validity: " + cert.getNotBefore().toString() + " - " + cert.getNotAfter().toString());
        sb.append("\n");
        String certType = req.getExtDataInString("certType");
        if (certType == null) {
            certType = "server";
        }
        if (certType.equals("client")) {
            sb.append("\n");
        } else {
            sb.append("Certificate Content is as follows:");
            sb.append("\n");
            try {
                byte[] ba = cert.getEncoded();
                String encodedCert = Utils.base64encode((byte[])ba, (boolean)true);
                sb.append("-----BEGIN CERTIFICATE-----\n" + encodedCert + "-----END CERTIFICATE-----\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    static {
        defConfParams.addElement("minValidity=180");
        defConfParams.addElement("maxValidity=730");
        defConfParams.addElement("renewalInterval=15");
    }
}

