/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributePresentConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(AttributePresentConstraints.class);
    protected static final String PROP_ENABLED = "enabled";
    protected static final String PROP_LDAP = "ldap";
    protected String mName = null;
    protected String mImplName = null;
    private ConfigStore mConfig;
    private LDAPConfig mLdapConfig;
    private LdapBoundConnFactory mConnFactory;
    private LDAPConnection mCheckAttrLdapConnection = null;
    protected static final String PROP_LDAP_HOST = "ldap.ldapconn.host";
    protected static final String DEF_LDAP_HOST = "localhost";
    protected static final String PROP_LDAP_PORT = "ldap.ldapconn.port";
    protected static final Integer DEF_LDAP_PORT = 389;
    protected static final String PROP_LDAP_SSL = "ldap.ldapconn.secureConn";
    protected static final Boolean DEF_LDAP_SSL = Boolean.FALSE;
    protected static final String PROP_LDAP_VER = "ldap.ldapconn.version";
    protected static final Integer DEF_LDAP_VER = 3;
    protected static final String PROP_LDAP_BIND = "ldap.ldapauth.bindDN";
    protected static final String DEF_LDAP_BIND = "CN=Directory Manager";
    protected static final String PROP_LDAP_PW = "ldap.ldapauth.bindPWPrompt";
    protected static final String DEF_LDAP_PW = "";
    protected static final String PROP_LDAP_CERT = "ldap.ldapauth.clientCertNickname";
    protected static final String DEF_LDAP_CERT = "";
    protected static final String PROP_LDAP_AUTH = "ldap.ldapauth.authtype";
    protected static final String DEF_LDAP_AUTH = "BasicAuth";
    protected static final String PROP_LDAP_BASE = "ldap.ldapconn.basedn";
    protected static final String DEF_LDAP_BASE = "";
    protected static final String PROP_LDAP_MINC = "ldap.ldapconn.minConns";
    protected static final Integer DEF_LDAP_MINC = 1;
    protected static final String PROP_LDAP_MAXC = "ldap.ldapconn.maxConns";
    protected static final Integer DEF_LDAP_MAXC = 5;
    protected static final String PROP_ATTR = "attribute";
    protected static final String DEF_ATTR = "pin";
    protected static final String PROP_VALUE = "value";
    protected static final String DEF_VALUE = "";
    protected static Vector<String> mParamNames = new Vector();
    protected static Hashtable<String, Object> mParamDefault = new Hashtable();
    protected Hashtable<String, Object> mParamValue = null;

    public AttributePresentConstraints() {
        this.DESC = "Rejects request if ldap attribute is not present in the directory.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"attribute;string,required;Ldap attribute to check presence of (default pin)", "value;string;if this parameter is non-empty, the attribute must match this value for the request to proceed ", "ldap.ldapconn.basedn;string,required;Base DN to start searching under. If your user's DN is 'uid=jsmith, o=company', you might want to use 'o=company' here", "ldap.ldapconn.host;string,required;LDAP host to connect to", "ldap.ldapconn.port;number,required;LDAP port number (use 389, or 636 if SSL)", "ldap.ldapconn.secureConn;boolean;Use SSL to connect to directory?", "ldap.ldapconn.version;choice(3,2),required;LDAP protocol version", "ldap.ldapauth.bindDN;string;DN to bind as for attribute checking. For example 'CN=Pincheck User'", "ldap.ldapauth.bindPWPrompt;password;Enter password used to bind as the above user", "ldap.ldapauth.authtype;choice(BasicAuth,SslClientAuth),required;How to bind to the directory", "ldap.ldapauth.clientCertNickname;string;If you want to use SSL client auth to the directory, set the client cert nickname here", "ldap.ldapconn.basedn;string,required;Base DN to start searching under. If your user's DN is 'uid=jsmith, o=company', you might want to use 'o=company' here", "ldap.ldapconn.minConns;number;number of connections to keep open to directory server. Default " + DEF_LDAP_MINC, "ldap.ldapconn.maxConns;number;when needed, connection pool can grow to this many (multiplexed) connections. Default " + DEF_LDAP_MAXC, "HELP_TOKEN;configuration-policyrules-pinpresent", "HELP_TEXT;" + this.DESC + " This plugin can be used to check the presence (and, optionally, the value) of any LDAP attribute for the user. "};
        return params;
    }

    public String getName() {
        return this.mName;
    }

    public String getImplName() {
        return this.mImplName;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void shutdown() {
    }

    protected static void addParam(String name, Object value) {
        mParamNames.addElement(name);
        mParamDefault.put(name, value);
    }

    protected void getStringConfigParam(ConfigStore config, String paramName) {
        try {
            this.mParamValue.put(paramName, config.getString(paramName, (String)mParamDefault.get(paramName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getIntConfigParam(ConfigStore config, String paramName) {
        try {
            this.mParamValue.put(paramName, config.getInteger(paramName, ((Integer)mParamDefault.get(paramName)).intValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getBooleanConfigParam(ConfigStore config, String paramName) {
        try {
            this.mParamValue.put(paramName, config.getBoolean(paramName, ((Boolean)mParamDefault.get(paramName)).booleanValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mConfig = config;
        this.mParamValue = new Hashtable();
        this.getStringConfigParam(this.mConfig, PROP_LDAP_HOST);
        this.getIntConfigParam(this.mConfig, PROP_LDAP_PORT);
        this.getBooleanConfigParam(this.mConfig, PROP_LDAP_SSL);
        this.getIntConfigParam(this.mConfig, PROP_LDAP_VER);
        this.getStringConfigParam(this.mConfig, PROP_LDAP_BIND);
        this.getStringConfigParam(this.mConfig, PROP_LDAP_PW);
        this.getStringConfigParam(this.mConfig, PROP_LDAP_CERT);
        this.getStringConfigParam(this.mConfig, PROP_LDAP_AUTH);
        this.getStringConfigParam(this.mConfig, PROP_LDAP_BASE);
        this.getIntConfigParam(this.mConfig, PROP_LDAP_MINC);
        this.getIntConfigParam(this.mConfig, PROP_LDAP_MAXC);
        this.getStringConfigParam(this.mConfig, PROP_ATTR);
        this.getStringConfigParam(this.mConfig, PROP_VALUE);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        this.mLdapConfig = (LDAPConfig)this.mConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
        this.mConnFactory = new LdapBoundConnFactory("AttributePresentConstraints");
        this.mConnFactory.setCMSEngine((CMSEngine)engine);
        this.mConnFactory.init(socketConfig, this.mLdapConfig, engine.getPasswordStore());
        this.mCheckAttrLdapConnection = this.mConnFactory.getConn();
    }

    public PolicyResult apply(Request r) {
        PolicyResult res = PolicyResult.ACCEPTED;
        String requestType = r.getRequestType();
        if (requestType.equals("enrollment") || requestType.equals("renewal")) {
            String uid = r.getExtDataInString("HTTP_PARAMS", "uid");
            if (uid == null) {
                logger.error("did not find UID parameter in request " + r.getRequestId());
                this.setError(r, CMS.getUserMessage((String)"CMS_POLICY_PIN_UNAUTHORIZED", (String[])new String[0]), "");
                return PolicyResult.REJECTED;
            }
            String userdn = null;
            try {
                String[] attrs = new String[]{(String)this.mParamValue.get(PROP_ATTR)};
                LDAPSearchResults searchResult = this.mCheckAttrLdapConnection.search((String)this.mParamValue.get(PROP_LDAP_BASE), 2, "(uid=" + uid + ")", attrs, false);
                if (!searchResult.hasMoreElements()) {
                    logger.error(CMS.getLogMessage((String)"CMS_AUTH_NO_PIN_FOUND", (Object[])new Object[]{uid}));
                    this.setError(r, CMS.getUserMessage((String)"CMS_POLICY_PIN_UNAUTHORIZED", (String[])new String[0]), "");
                    return PolicyResult.REJECTED;
                }
                LDAPEntry entry = (LDAPEntry)searchResult.nextElement();
                userdn = entry.getDN();
                LDAPAttribute attr = entry.getAttribute((String)this.mParamValue.get(PROP_ATTR));
                if (attr == null) {
                    logger.error(CMS.getLogMessage((String)"CMS_AUTH_NO_PIN_FOUND", (Object[])new Object[]{userdn}));
                    this.setError(r, CMS.getUserMessage((String)"CMS_POLICY_PIN_UNAUTHORIZED", (String[])new String[0]), "");
                    return PolicyResult.REJECTED;
                }
                String acceptedValue = (String)this.mParamValue.get(PROP_VALUE);
                if (!acceptedValue.equals("")) {
                    int matches = 0;
                    String[] values = attr.getStringValueArray();
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].equals(acceptedValue)) continue;
                        ++matches;
                    }
                    if (matches == 0) {
                        logger.error(CMS.getLogMessage((String)"CMS_AUTH_NO_PIN_FOUND", (Object[])new Object[]{userdn}));
                        this.setError(r, CMS.getUserMessage((String)"CMS_POLICY_PIN_UNAUTHORIZED", (String[])new String[0]), "");
                        return PolicyResult.REJECTED;
                    }
                }
                logger.debug("AttributePresentConstraints: Attribute is present for user: \"" + userdn + "\"");
            }
            catch (LDAPException e) {
                logger.error(CMS.getLogMessage((String)"POLICY_PIN_UNAUTHORIZED", (Object[])new Object[0]), (Throwable)e);
                this.setError(r, CMS.getUserMessage((String)"CMS_POLICY_PIN_UNAUTHORIZED", (String[])new String[0]), "");
                return PolicyResult.REJECTED;
            }
        }
        return res;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        Enumeration<String> e = mParamNames.elements();
        while (e.hasMoreElements()) {
            try {
                String paramName = e.nextElement();
                String paramValue = this.mParamValue.get(paramName).toString();
                String temp = paramName + "=" + paramValue;
                params.addElement(temp);
            }
            catch (Exception exception) {}
        }
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> params = new Vector<String>();
        Enumeration<String> e = mParamNames.elements();
        while (e.hasMoreElements()) {
            try {
                String paramName = e.nextElement();
                String paramValue = mParamDefault.get(paramName).toString();
                String temp = paramName + "=" + paramValue;
                params.addElement(temp);
            }
            catch (Exception exception) {}
        }
        return params;
    }

    static {
        AttributePresentConstraints.addParam(PROP_LDAP_HOST, DEF_LDAP_HOST);
        AttributePresentConstraints.addParam(PROP_LDAP_PORT, DEF_LDAP_PORT);
        AttributePresentConstraints.addParam(PROP_LDAP_SSL, DEF_LDAP_SSL);
        AttributePresentConstraints.addParam(PROP_LDAP_VER, DEF_LDAP_VER);
        AttributePresentConstraints.addParam(PROP_LDAP_BIND, DEF_LDAP_BIND);
        AttributePresentConstraints.addParam(PROP_LDAP_PW, "");
        AttributePresentConstraints.addParam(PROP_LDAP_CERT, "");
        AttributePresentConstraints.addParam(PROP_LDAP_AUTH, DEF_LDAP_AUTH);
        AttributePresentConstraints.addParam(PROP_LDAP_BASE, "");
        AttributePresentConstraints.addParam(PROP_LDAP_MINC, DEF_LDAP_MINC);
        AttributePresentConstraints.addParam(PROP_LDAP_MAXC, DEF_LDAP_MAXC);
        AttributePresentConstraints.addParam(PROP_ATTR, DEF_ATTR);
        AttributePresentConstraints.addParam(PROP_VALUE, "");
    }
}

