/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.ca;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.IPolicy;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import org.dogtagpki.legacy.ca.CAPolicyConfig;
import org.dogtagpki.legacy.core.policy.GenericPolicyProcessor;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAPolicy
implements IPolicy {
    public static Logger logger = LoggerFactory.getLogger(CAPolicy.class);
    CAPolicyConfig mConfig;
    CertificateAuthority mCA = null;
    public static String PROP_PROCESSOR = "processor";
    public static String PR_TYPE_CLASSIC = "classic";
    public GenericPolicyProcessor mPolicies = null;

    public IPolicyProcessor getPolicyProcessor() {
        return this.mPolicies;
    }

    public void init(CertificateAuthority owner, CAPolicyConfig config) throws EBaseException {
        this.mCA = owner;
        this.mConfig = config;
        String processorType = config.getString(PROP_PROCESSOR, PR_TYPE_CLASSIC);
        logger.debug("selected policy processor = " + processorType);
        if (!processorType.equals(PR_TYPE_CLASSIC)) {
            throw new EBaseException("Unknown policy processor type (" + processorType + ")");
        }
        this.mPolicies = new GenericPolicyProcessor();
        this.mPolicies.setCMSEngine(owner.getCMSEngine());
        this.mPolicies.init((IAuthority)this.mCA, (ConfigStore)this.mConfig);
    }

    public boolean isProfileRequest(Request request) {
        String profileId = request.getExtDataInString("profileId");
        return profileId != null && !profileId.equals("");
    }

    public PolicyResult apply(Request r) {
        if (r == null) {
            logger.debug("in CAPolicy.apply(request=null)");
            return PolicyResult.REJECTED;
        }
        logger.debug("in CAPolicy.apply(requestType=" + r.getRequestType() + ",requestId=" + r.getRequestId().toString() + ",requestStatus=" + r.getRequestStatus().toString() + ")");
        CAEngine engine = CAEngine.getInstance();
        if (this.isProfileRequest(r)) {
            logger.debug("CAPolicy: Profile-base Request " + r.getRequestId().toString());
            logger.debug("CAPolicy: requestId=" + r.getRequestId().toString());
            String profileId = r.getExtDataInString("profileId");
            if (profileId == null || profileId.equals("")) {
                return PolicyResult.REJECTED;
            }
            ProfileSubsystem ps = engine.getProfileSubsystem();
            try {
                Profile profile = ps.getProfile(profileId);
                r.setExtData("dbStatus", "NOT_UPDATED");
                profile.populate(r);
                profile.validate(r);
                return PolicyResult.ACCEPTED;
            }
            catch (EBaseException e) {
                logger.error("CAPolicy: " + e, (Throwable)e);
                return PolicyResult.REJECTED;
            }
        }
        logger.debug("mPolicies = " + this.mPolicies.getClass());
        return this.mPolicies.apply(r);
    }
}

