/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.security.PWsdrCache;
import com.netscape.cmscore.security.PWsdrConsolePasswordCallback;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PWCBsdr
implements PasswordCallback {
    public static Logger logger = LoggerFactory.getLogger(PWCBsdr.class);
    String mprompt = "";
    boolean firsttime = true;
    private PasswordCallback mCB = null;
    private String mPWcachedb = null;

    public PWCBsdr() {
        this(null);
    }

    public PWCBsdr(String prompt) {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mprompt = prompt;
        try {
            this.mPWcachedb = cs.getString("pwCache");
            logger.debug("got pwCache from configstore: " + this.mPWcachedb);
        }
        catch (NullPointerException e) {
            logger.warn("after CMS.getConfigStore got NullPointerException ... testing ok", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_SECURITY_GET_CONFIG", (Object[])new Object[0]), (Throwable)e);
        }
        this.mCB = new PWsdrConsolePasswordCallback(prompt);
    }

    public Password getPasswordFirstAttempt(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        logger.debug("in getPasswordFirstAttempt");
        Password pw = null;
        String tmpPrompt = info.getName();
        String skip_token = System.getProperty("cms.skip_token");
        if (skip_token != null && tmpPrompt.equals(skip_token)) {
            throw new PasswordCallback.GiveUpException();
        }
        try {
            String defpw = System.getProperty("cms.defaultpassword");
            if (defpw != null) {
                return new Password(defpw.toCharArray());
            }
            if (this.mprompt != null) {
                tmpPrompt = this.mprompt;
            }
            if (tmpPrompt == null) {
                System.out.println("Shouldn't get here");
                throw new PasswordCallback.GiveUpException();
            }
            logger.debug("getting tag = " + tmpPrompt);
            PWsdrCache pwc = new PWsdrCache(this.mPWcachedb);
            pw = pwc.getEntry(tmpPrompt);
            if (pw == null) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_SECURITY_THROW_CALLBACK", (Object[])new Object[0]));
                throw new PasswordCallback.GiveUpException();
            }
            logger.debug("non-null password returned in first attempt");
            return pw;
        }
        catch (Throwable e) {
            throw new PasswordCallback.GiveUpException();
        }
    }

    public Password getPasswordAgain(PasswordCallbackInfo info) throws PasswordCallback.GiveUpException {
        logger.debug("in getPasswordAgain");
        try {
            Password pw = null;
            try {
                if (this.firsttime) {
                    try {
                        this.firsttime = false;
                        pw = this.mCB.getPasswordFirstAttempt(info);
                    }
                    catch (PasswordCallback.GiveUpException e) {
                        throw new PasswordCallback.GiveUpException();
                    }
                } else {
                    pw = this.mCB.getPasswordAgain(info);
                }
                return pw;
            }
            catch (PasswordCallback.GiveUpException e) {
                throw new PasswordCallback.GiveUpException();
            }
        }
        catch (Throwable e) {
            throw new PasswordCallback.GiveUpException();
        }
    }
}

