/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.notification;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.certsrv.notification.EmailResolver;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.notification.EmailResolverKeys;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqCertSANameEmailResolver
extends EmailResolver {
    public static Logger logger = LoggerFactory.getLogger(ReqCertSANameEmailResolver.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public String getEmail(EmailResolverKeys keys) throws EBaseException, ENotificationException {
        req = (Request)keys.get("request");
        mEmail = null;
        if (req != null) {
            mEmail = req.getExtDataInString("HTTP_PARAMS", "csrRequestorEmail");
            if (mEmail == null) {
                mail = req.getExtDataInString("requestor_email");
                ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: REQUESTOR_EMAIL = " + mail);
                if (mail != null && !mail.equals("")) {
                    return mail;
                }
            } else {
                if (!mEmail.equals("")) {
                    ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: REQUESTOR_EMAIL = " + mEmail);
                    return mEmail;
                }
                ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: REQUESTOR_EMAIL is null ");
            }
        } else {
            ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: request null in keys");
        }
        request = keys.get("cert");
        cert = null;
        engine = CAEngine.getInstance();
        certDB = engine.getCertificateRepository();
        if (request instanceof RevokedCertImpl) {
            revCert = (RevokedCertImpl)request;
            cert = certDB.getX509Certificate(revCert.getSerialNumber());
        } else {
            cert = (X509Certificate)request;
        }
        subjectDN = null;
        if (cert != null) {
            subjectDN = (X500Name)cert.getSubjectDN();
            try {
                mEmail = subjectDN.getEmail();
                if (mEmail != null) {
                    if (!mEmail.equals("")) {
                        ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: cert subjectDN E=" + mEmail);
                    }
                } else {
                    ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: no E component in subjectDN ");
                }
            }
            catch (IOException e) {
                ReqCertSANameEmailResolver.logger.error("ReqCertSANameEmailResolver: X500Name getEmail failed: " + e.getMessage(), (Throwable)e);
                throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{subjectDN.toString()}), (Exception)e);
            }
            if (mEmail == null) {
                certInfo = null;
                ReqCertSANameEmailResolver.logger.debug("ReqCertSANameEmailResolver: about to try subjectalternatename");
                try {
                    certInfo = (X509CertInfo)((X509CertImpl)cert).get("x509.info");
                }
                catch (CertificateParsingException ex) {
                    ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_NO_CERTINFO", (Object[])new Object[0]), (Throwable)ex);
                    throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"subjectDN= " + subjectDN.toString()}), (Exception)ex);
                }
                try {
                    exts = (CertificateExtensions)certInfo.get("extensions");
                }
                catch (IOException e) {
                    ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"subjectDN= " + subjectDN.toString()}), (Exception)e);
                }
                catch (CertificateException e) {
                    ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"subjectDN= " + subjectDN.toString()}), (Exception)e);
                }
                if (exts != null) {
                    try {
                        ext = (SubjectAlternativeNameExtension)exts.get("SubjectAlternativeName");
                    }
                    catch (IOException e) {
                        ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"subjectDN= " + subjectDN.toString()}), (Exception)e);
                    }
                    try {
                        if (ext == null) ** GOTO lbl85
                        gn = (GeneralNames)ext.get("subject_name");
                        e = gn.elements();
                        while (e.hasMoreElements()) {
                            gni = (GeneralNameInterface)e.nextElement();
                            if (gni.getType() == 1) {
                                ReqCertSANameEmailResolver.logger.debug("ReqCertSANameEmailResolver: got an subjectalternatename email");
                                nameString = gni.toString();
                                mEmail = nameString.substring(nameString.indexOf(32) + 1);
                                ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: subjectalternatename email used:" + mEmail);
                            }
                            ReqCertSANameEmailResolver.logger.warn("ReqCertSANameEmailResolver: not an subjectalternatename email");
                        }
                    }
                    catch (IOException e) {
                        ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_SUBJECTALTNAME", (Object[])new Object[0]), (Throwable)e);
                    }
                }
            }
        } else {
            ReqCertSANameEmailResolver.logger.warn("ReqCertSANameEmailResolver: cert null in keys");
        }
lbl85:
        // 5 sources

        if (mEmail == null) {
            if (cert != null) {
                ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_NO_EMAIL", (Object[])new Object[]{subjectDN.toString()}));
                ReqCertSANameEmailResolver.logger.error("ReqCertSANameEmailResolver: no email resolved, throwing NotificationResources.EMAIL_RESOLVE_FAILED_1 for " + subjectDN);
                throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"subjectDN= " + subjectDN}));
            }
            if (req != null) {
                ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_NO_EMAIL_ID", (Object[])new Object[]{req.getRequestId().toString()}));
                ReqCertSANameEmailResolver.logger.error("ReqCertSANameEmailResolver: no email resolved, throwing NotificationResources.EMAIL_RESOLVE_FAILED_1 for request id =" + req.getRequestId());
                throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{"requestId= " + req.getRequestId()}));
            }
            ReqCertSANameEmailResolver.logger.error(CMS.getLogMessage((String)"CMSCORE_NOTIFY_NO_EMAIL_REQUEST", (Object[])new Object[0]));
            ReqCertSANameEmailResolver.logger.error("ReqCertSANameEmailResolver: no email resolved, throwing NotificationResources.EMAIL_RESOLVE_FAILED_1.  No request id or cert info found");
            throw new ENotificationException(CMS.getUserMessage((String)"CMS_NOTIFICATION_EMAIL_RESOLVE_FAILED", (String[])new String[]{": No request id or cert info found"}));
        }
        ReqCertSANameEmailResolver.logger.info("ReqCertSANameEmailResolver: email resolved: " + mEmail);
        return mEmail;
    }
}

