/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.LdapEnrollmentListener;
import com.netscape.cmscore.ldap.LdapRenewalListener;
import com.netscape.cmscore.ldap.LdapRevocationListener;
import com.netscape.cmscore.ldap.LdapUnrevocationListener;
import com.netscape.cmscore.ldap.PublishObject;
import com.netscape.cmscore.request.Request;
import java.util.Hashtable;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapRequestListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(LdapRequestListener.class);
    private Hashtable<String, RequestListener> mRequestListeners = new Hashtable();

    public void set(String name, String val) {
    }

    public void setPublisherProcessor(CAPublisherProcessor publisherProcessor) {
        this.mRequestListeners.put("enrollment", new LdapEnrollmentListener(publisherProcessor));
        this.mRequestListeners.put("renewal", new LdapRenewalListener(publisherProcessor));
        this.mRequestListeners.put("revocation", new LdapRevocationListener(publisherProcessor));
        this.mRequestListeners.put("unrevocation", new LdapUnrevocationListener(publisherProcessor));
    }

    public void init(Subsystem sys, ConfigStore config) throws EBaseException {
    }

    public PublishObject getPublishObject(Request r) {
        String type = r.getRequestType();
        PublishObject obj = new PublishObject();
        if (type.equals("enrollment")) {
            if (r.getExtDataInInteger("Result") == null) {
                return null;
            }
            if (r.getExtDataInInteger("Result").equals(Request.RES_ERROR)) {
                logger.warn("Request errored. Nothing to publish for enrollment request id " + r.getRequestId());
                return null;
            }
            logger.debug("Checking publishing for request " + r.getRequestId());
            X509CertImpl[] certs = r.getExtDataInCertArray("issuedCerts");
            if (certs == null || certs.length == 0 || certs[0] == null) {
                logger.warn("No certs to publish for request id " + r.getRequestId());
                return null;
            }
            obj.setCerts(certs);
            return obj;
        }
        if (type.equals("renewal")) {
            X509CertImpl[] certs = r.getExtDataInCertArray("issuedCerts");
            if (certs == null || certs.length == 0) {
                logger.warn("no certs to publish for renewal request " + r.getRequestId());
                return null;
            }
            obj.setCerts(certs);
            return obj;
        }
        if (type.equals("revocation")) {
            X509CertImpl[] revcerts = r.getExtDataInCertArray("OLD_CERTS");
            if (revcerts == null || revcerts.length == 0 || revcerts[0] == null) {
                logger.warn("Nothing to unpublish for revocation request " + r.getRequestId());
                return null;
            }
            obj.setCerts(revcerts);
            return obj;
        }
        if (type.equals("unrevocation")) {
            X509CertImpl[] certs = r.getExtDataInCertArray("OLD_CERTS");
            if (certs == null || certs.length == 0 || certs[0] == null) {
                logger.warn("Nothing to publish for unrevocation request " + r.getRequestId());
                return null;
            }
            obj.setCerts(certs);
            return obj;
        }
        logger.warn("Request errored. Nothing to publish for request id " + r.getRequestId());
        return null;
    }

    public void accept(Request r) {
        String type = r.getRequestType();
        RequestListener handler = this.mRequestListeners.get(type);
        if (handler == null) {
            logger.warn("Nothing to publish for request type " + type);
            return;
        }
        handler.accept(r);
    }
}

