/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.AuthEvent;
import com.netscape.certsrv.logging.event.CertRequestProcessedEvent;
import com.netscape.certsrv.profile.ECMCBadIdentityException;
import com.netscape.certsrv.profile.ECMCBadMessageCheckException;
import com.netscape.certsrv.profile.ECMCBadRequestException;
import com.netscape.certsrv.profile.ECMCPopFailedException;
import com.netscape.certsrv.profile.ECMCPopRequiredException;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.servlet.common.CMCOutputTemplate;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cms.servlet.profile.SSLClientCertProvider;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestNotifier;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkix.cmc.LraPopWitness;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileSubmitCMCServlet
extends ProfileServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileSubmitCMCServlet.class);
    private static final long serialVersionUID = -8017841111435988197L;
    private static final String PROP_PROFILE_ID = "profileId";
    private String mProfileId = null;
    private String mProfileSubId = null;
    private String requestB64 = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mProfileId = sc.getInitParameter(PROP_PROFILE_ID);
        this.mRenderResult = false;
    }

    private void setInputsIntoContext(HttpServletRequest request, Profile profile, Map<String, String> ctx) {
        String method = "ProfileSubmitCMCServlet.setInputsIntoContext: ";
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                while (inputNames.hasMoreElements()) {
                    String inputName = inputNames.nextElement();
                    if (request.getParameter(inputName) == null) continue;
                    logger.debug(method + "setting: " + inputName);
                    ctx.put(inputName, request.getParameter(inputName));
                }
            }
        }
    }

    private void setCredentialsIntoContext(HttpServletRequest request, AuthManager authenticator, Map<String, String> ctx) {
        Enumeration authIds = authenticator.getValueNames();
        if (authIds != null) {
            while (authIds.hasMoreElements()) {
                String authName = (String)authIds.nextElement();
                if (request.getParameter(authName) == null) continue;
                ctx.put(authName, request.getParameter(authName));
            }
        }
    }

    public AuthToken authenticate(AuthManager authenticator, HttpServletRequest request) throws EBaseException {
        String method = "ProfileSubmitCMCServlet: authenticate: ";
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        AuthCredentials credentials = new AuthCredentials();
        Enumeration authNames = authenticator.getValueNames();
        if (authNames != null) {
            while (authNames.hasMoreElements()) {
                String authName = (String)authNames.nextElement();
                if (authName.equals("cert_request")) {
                    credentials.set(authName, (Object)this.requestB64);
                    continue;
                }
                credentials.set(authName, (Object)request.getParameter(authName));
            }
        }
        AuthToken authToken = null;
        String auditSubjectID = null;
        String authMgrID = authenticator.getName();
        SessionContext sc = SessionContext.getContext();
        X509Certificate clientCert = this.getSSLClientCertificate(request, false);
        if (clientCert != null) {
            sc.put((Object)"sslClientCert", (Object)clientCert);
        }
        try {
            authToken = authenticator.authenticate(credentials);
            if (sc != null) {
                sc.put((Object)"authManagerId", (Object)authMgrID);
                auditSubjectID = authToken.getInString("userid");
                if (auditSubjectID != null) {
                    logger.debug(method + "setting auditSubjectID in SessionContext:" + auditSubjectID);
                    sc.put((Object)"userid", (Object)auditSubjectID);
                } else {
                    logger.debug(method + "no auditSubjectID found in authToken");
                }
            }
            if (!auditSubjectID.equals("$Unidentified$") && !auditSubjectID.equals("$NonRoleUser$")) {
                auditor.log((LogEvent)AuthEvent.createSuccessEvent((String)auditSubjectID, (String)authMgrID));
            }
        }
        catch (EBaseException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            String attempted_auditSubjectID = null;
            if (sc != null) {
                attempted_auditSubjectID = (String)sc.get((Object)"userid");
            }
            auditor.log((LogEvent)AuthEvent.createFailureEvent((String)auditSubjectID, (String)authMgrID, (String)attempted_auditSubjectID));
            throw e;
        }
        return authToken;
    }

    private void setInputsIntoRequest(HttpServletRequest request, Profile profile, Request req) {
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                if (inputNames == null) continue;
                while (inputNames.hasMoreElements()) {
                    String inputName = inputNames.nextElement();
                    if (request.getParameter(inputName) == null) continue;
                    req.setExtData(inputName, request.getParameter(inputName));
                }
            }
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        block150: {
            SEQUENCE seq;
            CMCOutputTemplate template;
            UTF8String s;
            SEQUENCE seq2;
            CMCOutputTemplate template2;
            String tmpSharedTokenAuthenticatedCertSubject;
            HttpServletRequest request = cmsReq.getHttpReq();
            HttpServletResponse response = cmsReq.getHttpResp();
            Locale locale = this.getLocale(request);
            String cert_request_type = this.servletConfig.getInitParameter("cert_request_type");
            String outputFormat = this.servletConfig.getInitParameter("outputFormat");
            int reqlen = request.getContentLength();
            ServletInputStream is = null;
            try {
                is = request.getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] reqbuf = new byte[reqlen];
            int bytesread = 0;
            boolean partial = false;
            while (bytesread < reqlen) {
                try {
                    bytesread += is.read(reqbuf, bytesread, reqlen - bytesread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (partial || bytesread >= reqlen) continue;
                partial = true;
            }
            this.requestB64 = Utils.base64encode((byte[])reqbuf, (boolean)true);
            if (logger.isDebugEnabled()) {
                logger.debug("Start of ProfileSubmitCMCServlet Input Parameters");
                Enumeration paramNames = request.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    if (CMS.isSensitive((String)paramName)) {
                        logger.debug("ProfileSubmitCMCServlet Input Parameter " + paramName + "='(sensitive)'");
                        continue;
                    }
                    logger.debug("ProfileSubmitCMCServlet Input Parameter " + paramName + "='" + request.getParameter(paramName) + "'");
                }
                logger.debug("End of ProfileSubmitCMCServlet Input Parameters");
            }
            logger.debug("ProfileSubmitCMCServlet: start serving");
            if (this.mProfileSubId == null || this.mProfileSubId.equals("")) {
                this.mProfileSubId = "profile";
            }
            logger.debug("ProfileSubmitCMCServlet: SubId=" + this.mProfileSubId);
            CAEngine engine = CAEngine.getInstance();
            ProfileSubsystem ps = engine.getProfileSubsystem();
            Auditor auditor = engine.getAuditor();
            if (ps == null) {
                logger.warn("ProfileSubmitCMCServlet: ProfileSubsystem not found");
                CMCOutputTemplate template3 = new CMCOutputTemplate();
                SEQUENCE seq3 = new SEQUENCE();
                seq3.addElement((ASN1Value)new INTEGER(0L));
                UTF8String s2 = null;
                try {
                    s2 = new UTF8String(CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template3.createFullResponseWithFailedStatus(response, seq3, 11, s2);
                return;
            }
            String profileId = request.getParameter(PROP_PROFILE_ID);
            if (profileId == null) {
                profileId = this.mProfileId;
            }
            Profile profile = null;
            try {
                logger.debug("ProfileSubmitCMCServlet: profileId " + profileId);
                profile = ps.getProfile(profileId);
            }
            catch (EProfileException e) {
                logger.warn("ProfileSubmitCMCServlet: profile not found profileId " + profileId + " " + e.getMessage(), (Throwable)e);
            }
            if (profile == null) {
                CMCOutputTemplate template4 = new CMCOutputTemplate();
                SEQUENCE seq4 = new SEQUENCE();
                seq4.addElement((ASN1Value)new INTEGER(0L));
                UTF8String s3 = null;
                try {
                    s3 = new UTF8String(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template4.createFullResponseWithFailedStatus(response, seq4, 11, s3);
                return;
            }
            if (!ps.isProfileEnable(profileId)) {
                logger.debug("ProfileSubmitCMCServlet: Profile " + profileId + " not enabled");
                CMCOutputTemplate template5 = new CMCOutputTemplate();
                SEQUENCE seq5 = new SEQUENCE();
                seq5.addElement((ASN1Value)new INTEGER(0L));
                UTF8String s4 = null;
                try {
                    s4 = new UTF8String(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template5.createFullResponseWithFailedStatus(response, seq5, 11, s4);
                return;
            }
            HashMap<String, String> ctx = new HashMap<String, String>();
            if (this.requestB64 != null) {
                ctx.put("cert_request_type", cert_request_type);
                ctx.put("cert_request", Utils.normalizeString((String)this.requestB64));
            }
            AuthManager authenticator = null;
            try {
                authenticator = ps.getProfileAuthenticator(profile);
            }
            catch (EProfileException s4) {
                // empty catch block
            }
            if (authenticator == null) {
                logger.debug("ProfileSubmitCMCServlet: authenticator not found");
            } else {
                logger.debug("ProfileSubmitCMCServlet: authenticator " + authenticator.getName() + " found");
                this.setCredentialsIntoContext(request, authenticator, ctx);
            }
            this.setInputsIntoContext(request, profile, ctx);
            logger.debug("ProfileSubmitCMCServlet: set Inputs into Context");
            AuthToken authToken = null;
            SessionContext context = SessionContext.getContext();
            context.put((Object)"profileContext", ctx);
            context.put((Object)"sslClientCertProvider", (Object)new SSLClientCertProvider(request));
            logger.debug("ProfileSubmitCMCServlet: set sslClientCertProvider");
            String auditSubjectID = this.auditSubjectID();
            if (authenticator != null) {
                try {
                    authToken = this.authenticate(authenticator, request);
                    if (authToken != null) {
                        auditSubjectID = authToken.getInString("userid");
                        context.put((Object)"AuthToken", (Object)authToken);
                    }
                }
                catch (EBaseException e) {
                    CMCOutputTemplate template6 = new CMCOutputTemplate();
                    SEQUENCE seq6 = new SEQUENCE();
                    seq6.addElement((ASN1Value)new INTEGER(0L));
                    UTF8String s5 = null;
                    try {
                        s5 = new UTF8String(e.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    template6.createFullResponseWithFailedStatus(response, seq6, 2, s5);
                    logger.warn("ProfileSubmitCMCServlet: authentication error " + e.getMessage(), (Throwable)e);
                    return;
                }
                AuthzToken authzToken = null;
                if (authToken != null) {
                    logger.debug("ProfileSubmitCMCServlet authToken not null");
                    try {
                        authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "submit");
                    }
                    catch (Exception e) {
                        logger.warn("ProfileSubmitCMCServlet authorization failure: " + e.getMessage(), (Throwable)e);
                    }
                    String authMgrID = authenticator.getName();
                    if (authMgrID.equals("CMCAuth")) {
                        authzToken = null;
                        logger.debug("ProfileSubmitCMCServlet CMCAuth requires additional authz check");
                        try {
                            authzToken = this.authorize(this.mAclMethod, authToken, "certServer.ca.certrequests", "execute");
                        }
                        catch (Exception e) {
                            logger.warn("ProfileSubmitCMCServlet authorization failure: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (authzToken == null) {
                    logger.warn("ProfileSubmitCMCServlet authorization failure: authzToken is null");
                    CMCOutputTemplate template7 = new CMCOutputTemplate();
                    SEQUENCE seq7 = new SEQUENCE();
                    seq7.addElement((ASN1Value)new INTEGER(0L));
                    UTF8String s6 = null;
                    try {
                        s6 = new UTF8String("ProfileSubmitCMCServlet authorization failure");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    template7.createFullResponseWithFailedStatus(response, seq7, 2, s6);
                    return;
                }
            }
            String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_REQUEST_RECEIVED_3", (Object[])new Object[]{auditSubjectID, "Success", Utils.normalizeString((String)this.requestB64)});
            auditor.log(auditMessage);
            Request[] reqs = null;
            String tmpCertSerialS = (String)ctx.get("cmcSigningCert");
            if (tmpCertSerialS != null) {
                logger.debug("ProfileSubmitCMCServlet: found existing CRED_CMC_SIGNING_CERT in ctx for CMCUserSignedAuth:" + tmpCertSerialS);
                logger.debug("ProfileSubmitCMCServlet: null it out");
                ctx.put("cmcSigningCert", "");
            }
            String signingCertSerialS = null;
            if (authToken != null) {
                signingCertSerialS = (String)authToken.get("cmcSigningCert");
            }
            if (signingCertSerialS != null) {
                logger.debug("ProfileSubmitCMCServlet: setting CRED_CMC_SIGNING_CERT in ctx for CMCUserSignedAuth");
                ctx.put("cmcSigningCert", signingCertSerialS);
            }
            if ((tmpSharedTokenAuthenticatedCertSubject = (String)ctx.get("tokenSharedTokenAuthenticatedCertSubject")) != null) {
                logger.debug("ProfileSubmitCMCServlet: found existing TOKEN_SHARED_TOKEN_AUTHENTICATED_CERT_SUBJECT in ctx for CMCUserSignedAuth:" + tmpSharedTokenAuthenticatedCertSubject);
                logger.debug("ProfileSubmitCMCServlet: null it out");
                ctx.put("tokenSharedTokenAuthenticatedCertSubject", "");
            }
            String errorCode = null;
            String errorReason = null;
            String auditRequesterID = "$Unidentified$";
            try {
                reqs = profile.createRequests(ctx, locale);
            }
            catch (ECMCBadMessageCheckException e) {
                errorReason = e.getMessage();
                logger.warn("ProfileSubmitCMCServlet: after createRequests - " + errorReason, (Throwable)e);
                template2 = new CMCOutputTemplate();
                seq2 = new SEQUENCE();
                seq2.addElement((ASN1Value)new INTEGER(0L));
                s = null;
                try {
                    s = new UTF8String(e.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template2.createFullResponseWithFailedStatus(response, seq2, 1, s);
            }
            catch (ECMCBadIdentityException e) {
                errorReason = e.getMessage();
                logger.warn("ProfileSubmitCMCServlet: after createRequests - " + errorReason, (Throwable)e);
                template2 = new CMCOutputTemplate();
                seq2 = new SEQUENCE();
                seq2.addElement((ASN1Value)new INTEGER(0L));
                s = null;
                try {
                    s = new UTF8String(e.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template2.createFullResponseWithFailedStatus(response, seq2, 7, s);
            }
            catch (ECMCPopFailedException e) {
                errorReason = e.getMessage();
                logger.warn("ProfileSubmitCMCServlet: after createRequests - " + errorReason, (Throwable)e);
                template2 = new CMCOutputTemplate();
                seq2 = new SEQUENCE();
                seq2.addElement((ASN1Value)new INTEGER(0L));
                s = null;
                try {
                    s = new UTF8String(e.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template2.createFullResponseWithFailedStatus(response, seq2, 9, s);
            }
            catch (ECMCBadRequestException e) {
                errorReason = e.getMessage();
                logger.warn("ProfileSubmitCMCServlet: after createRequests - " + errorReason, (Throwable)e);
                template2 = new CMCOutputTemplate();
                seq2 = new SEQUENCE();
                seq2.addElement((ASN1Value)new INTEGER(0L));
                s = null;
                try {
                    s = new UTF8String(e.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template2.createFullResponseWithFailedStatus(response, seq2, 2, s);
            }
            catch (EProfileException e) {
                errorReason = e.getMessage();
                logger.warn("ProfileSubmitCMCServlet: after createRequests - " + errorReason, (Throwable)e);
                template2 = new CMCOutputTemplate();
                seq2 = new SEQUENCE();
                seq2.addElement((ASN1Value)new INTEGER(0L));
                s = null;
                try {
                    s = new UTF8String(e.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template2.createFullResponseWithFailedStatus(response, seq2, 11, s);
            }
            catch (Throwable e) {
                errorReason = e.getMessage();
                logger.warn("ProfileSubmitCMCServlet: createRequests - " + errorReason, e);
                template2 = new CMCOutputTemplate();
                seq2 = new SEQUENCE();
                seq2.addElement((ASN1Value)new INTEGER(0L));
                s = null;
                try {
                    s = new UTF8String(CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                template2.createFullResponseWithFailedStatus(response, seq2, 11, s);
            }
            if (errorReason != null) {
                auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)errorReason));
                return;
            }
            TaggedAttribute attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_lraPOPWitness);
            if (attr != null) {
                boolean verifyAllow = false;
                try {
                    verifyAllow = engine.getConfig().getBoolean("cmc.lraPopWitness.verify.allow", false);
                }
                catch (EBaseException seq8) {
                    // empty catch block
                }
                logger.debug("ProfileSubmitCMCServlet: cmc.lraPopWitness.verify.allow is " + verifyAllow);
                if (!verifyAllow) {
                    LraPopWitness lraPop = null;
                    SET vals = attr.getValues();
                    if (vals.size() > 0) {
                        try {
                            lraPop = (LraPopWitness)ASN1Util.decode((ASN1Template)LraPopWitness.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
                        }
                        catch (InvalidBERException e) {
                            logger.warn(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENCODING_ERROR", (String[])new String[0]));
                        }
                        SEQUENCE bodyIds = lraPop.getBodyIds();
                        CMCOutputTemplate template8 = new CMCOutputTemplate();
                        template8.createFullResponseWithFailedStatus(response, bodyIds, 9, null);
                        return;
                    }
                }
            }
            Request provedReq = null;
            boolean isRevoke = false;
            if (reqs == null) {
                BigInteger reqID = (BigInteger)context.get((Object)"cmcDecryptedPopReqId");
                if (reqID == null) {
                    logger.debug("ProfileSubmitCMCServlet: revocation request");
                    isRevoke = true;
                } else {
                    provedReq = this.requestRepository.readRequest(new RequestId(reqID.toString()));
                    if (provedReq == null) {
                        Integer nums = (Integer)context.get((Object)"numOfControls");
                        CMCOutputTemplate template9 = new CMCOutputTemplate();
                        if (nums != null && nums == 1) {
                            TaggedAttribute attr1 = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_getCert);
                            if (attr1 != null) {
                                template9.createSimpleResponse(response, reqs);
                            } else {
                                template9.createFullResponse(response, reqs, cert_request_type, null);
                            }
                        } else {
                            template9.createFullResponse(response, reqs, cert_request_type, null);
                        }
                        return;
                    }
                    logger.debug("ProfileSubmitCMCServlet: provedReq not null");
                }
            }
            for (int k = 0; !isRevoke && provedReq == null && k < reqs.length; ++k) {
                UTF8String s7;
                CMCOutputTemplate template10;
                auditRequesterID = this.auditRequesterID(reqs[k]);
                this.setInputsIntoRequest(request, profile, reqs[k]);
                if (authToken != null) {
                    String st_sbj;
                    Enumeration tokenNames = authToken.getElements();
                    while (tokenNames.hasMoreElements()) {
                        String tokenName = (String)tokenNames.nextElement();
                        String[] vals = authToken.getInStringArray(tokenName);
                        if (vals != null) {
                            for (int i = 0; i < vals.length; ++i) {
                                reqs[k].setExtData("auth_token." + tokenName + "[" + i + "]", vals[i]);
                            }
                            continue;
                        }
                        String val = authToken.getInString(tokenName);
                        if (val == null) continue;
                        reqs[k].setExtData("auth_token." + tokenName, val);
                    }
                    tmpCertSerialS = reqs[k].getExtDataInString("cmcSigningCert");
                    if (tmpCertSerialS != null) {
                        logger.debug("ProfileSubmitCMCServlet: found existing CRED_CMC_SIGNING_CERT in request for CMCUserSignedAuth:" + tmpCertSerialS);
                        logger.debug("ProfileSubmitCMCServlet: null it out");
                        reqs[k].setExtData("cmcSigningCert", "");
                    }
                    if (signingCertSerialS != null) {
                        logger.debug("ProfileSubmitCMCServlet: setting CRED_CMC_SIGNING_CERT in request for CMCUserSignedAuth");
                        reqs[k].setExtData("cmcSigningCert", signingCertSerialS);
                    }
                    if ((tmpSharedTokenAuthenticatedCertSubject = reqs[k].getExtDataInString("tokenSharedTokenAuthenticatedCertSubject")) != null) {
                        logger.debug("ProfileSubmitCMCServlet: found existing TOKEN_SHARED_TOKEN_AUTHENTICATED_CERT_SUBJECT in request for CMCUserSignedAuth:" + tmpSharedTokenAuthenticatedCertSubject);
                        logger.debug("ProfileSubmitCMCServlet: null it out");
                        reqs[k].setExtData("tokenSharedTokenAuthenticatedCertSubject", "");
                    }
                    if ((st_sbj = (String)ctx.get("tokenSharedTokenAuthenticatedCertSubject")) != null) {
                        logger.debug("ProfileSubmitCMCServlet: setting AuthToken.TOKEN_SHARED_TOKEN_AUTHENTICATED_CERT_SUBJECT in req for CMCUserSignedAuth");
                        reqs[k].setExtData("tokenSharedTokenAuthenticatedCertSubject", st_sbj);
                    }
                    if (tmpSharedTokenAuthenticatedCertSubject != null) {
                        logger.debug("ProfileSubmitCMCServlet: setting CRED_CMC_SIGNING_CERT in request for CMCUserSignedAuth");
                        reqs[k].setExtData("cmcSigningCert", signingCertSerialS);
                    }
                }
                reqs[k].setExtData("profile", "true");
                reqs[k].setExtData(PROP_PROFILE_ID, profileId);
                reqs[k].setExtData("profileApprovedBy", profile.getApprovedBy());
                String setId = profile.getPolicySetId(reqs[k]);
                if (setId == null) {
                    template = new CMCOutputTemplate();
                    seq = new SEQUENCE();
                    seq.addElement((ASN1Value)new INTEGER(0L));
                    UTF8String s8 = null;
                    try {
                        s8 = new UTF8String(CMS.getUserMessage((String)"CMS_PROFILE_NO_POLICY_SET_FOUND", (String[])new String[0]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    template.createFullResponseWithFailedStatus(response, seq, 11, s8);
                    return;
                }
                logger.debug("ProfileSubmitCMCServlet profileSetid=" + setId);
                reqs[k].setExtData("profileSetId", setId);
                reqs[k].setExtData("profileRemoteHost", request.getRemoteHost());
                reqs[k].setExtData("profileRemoteAddr", request.getRemoteAddr());
                logger.debug("ProfileSubmitCMCServlet: request " + reqs[k].getRequestId().toString());
                try {
                    logger.debug("ProfileSubmitCMCServlet: populating request inputs");
                    if (authenticator != null) {
                        authenticator.populate(authToken, reqs[k]);
                    }
                    profile.populateInput(ctx, reqs[k]);
                    profile.populate(reqs[k]);
                }
                catch (ECMCPopFailedException e) {
                    errorReason = e.getMessage();
                    logger.warn("ProfileSubmitCMCServlet: after populate - " + errorReason, (Throwable)e);
                    template10 = new CMCOutputTemplate();
                    SEQUENCE seq9 = new SEQUENCE();
                    seq9.addElement((ASN1Value)new INTEGER(0L));
                    s7 = null;
                    try {
                        s7 = new UTF8String(e.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    template10.createFullResponseWithFailedStatus(response, seq9, 9, s7);
                }
                catch (EProfileException e) {
                    errorReason = e.getMessage();
                    logger.warn("ProfileSubmitCMCServlet: after populate - " + errorReason, (Throwable)e);
                    template10 = new CMCOutputTemplate();
                    SEQUENCE seq10 = new SEQUENCE();
                    seq10.addElement((ASN1Value)new INTEGER(0L));
                    s7 = null;
                    try {
                        s7 = new UTF8String(e.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    template10.createFullResponseWithFailedStatus(response, seq10, 2, s7);
                }
                catch (Throwable e) {
                    errorReason = e.getMessage();
                    logger.warn("ProfileSubmitCMCServlet: after populate - " + errorReason, e);
                    template10 = new CMCOutputTemplate();
                    SEQUENCE seq11 = new SEQUENCE();
                    seq11.addElement((ASN1Value)new INTEGER(0L));
                    s7 = null;
                    try {
                        s7 = new UTF8String(e.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    template10.createFullResponseWithFailedStatus(response, seq11, 11, s7);
                }
                if (errorReason == null) continue;
                auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)errorReason));
                return;
            }
            try {
                X509CertImpl x509cert;
                int[] error_codes = null;
                if (reqs != null && reqs.length > 0) {
                    error_codes = new int[reqs.length];
                }
                for (int k = 0; !isRevoke && provedReq == null && k < reqs.length; ++k) {
                    RequestNotifier notify;
                    try {
                        auditRequesterID = this.auditRequesterID(reqs[k]);
                        if (reqs[k] != null) {
                            Enumeration reqKeys = reqs[k].getExtDataKeys();
                            while (reqKeys.hasMoreElements()) {
                                String reqKey = (String)reqKeys.nextElement();
                                String reqVal = reqs[k].getExtDataInString(reqKey);
                                if (reqVal == null) continue;
                                logger.debug("ProfileSubmitCMCServlet: key=$request." + reqKey + "$ value=" + reqVal);
                            }
                        }
                        profile.submit(authToken, reqs[k]);
                        reqs[k].setRequestStatus(RequestStatus.COMPLETE);
                        x509cert = reqs[k].getExtDataInCert("req_issued_cert");
                        if (x509cert != null) {
                            auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)x509cert));
                        }
                    }
                    catch (EDeferException e) {
                        logger.warn("ProfileSubmitCMCServlet: set request to PENDING");
                        reqs[k].setRequestStatus(RequestStatus.PENDING);
                        notify = engine.getRequestQueue().getPendingNotify();
                        if (notify != null) {
                            notify.notify(reqs[k]);
                        }
                        logger.warn("ProfileSubmitCMCServlet: submit " + e.getMessage());
                        errorCode = "2";
                        errorReason = CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEFERRED", (String[])new String[]{e.toString()});
                    }
                    catch (ERejectException e) {
                        reqs[k].setRequestStatus(RequestStatus.REJECTED);
                        logger.warn("ProfileSubmitCMCServlet: submit " + e.getMessage(), (Throwable)e);
                        errorCode = "3";
                        errorReason = CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REJECTED", (String[])new String[]{e.toString()});
                    }
                    catch (ECMCPopRequiredException e) {
                        logger.warn("ProfileSubmitCMCServlet: popRequired; set request to PENDING");
                        reqs[k].setRequestStatus(RequestStatus.PENDING);
                        notify = engine.getRequestQueue().getPendingNotify();
                        if (notify != null) {
                            notify.notify(reqs[k]);
                        }
                        logger.warn("ProfileSubmitCMCServlet: submit " + e.getMessage(), (Throwable)e);
                        errorCode = "4";
                        errorReason = CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CMC_POP_REQUIRED", (String[])new String[]{e.toString()});
                    }
                    catch (Throwable e) {
                        logger.warn("ProfileSubmitCMCServlet: submit " + e.getMessage(), e);
                        errorCode = "1";
                        errorReason = CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]);
                    }
                    try {
                        if (errorCode == null) {
                            engine.getRequestQueue().markAsServiced(reqs[k]);
                        } else {
                            engine.getRequestRepository().updateRequest(reqs[k]);
                        }
                    }
                    catch (EBaseException e) {
                        logger.warn("ProfileSubmitCMCServlet: updateRequest " + e.getMessage(), (Throwable)e);
                    }
                    if (errorCode != null) {
                        if (errorCode.equals("1")) {
                            auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)errorReason));
                        } else if (!errorCode.equals("2") && errorCode.equals("3")) {
                            auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)errorReason));
                        }
                        error_codes[k] = Integer.parseInt(errorCode);
                        continue;
                    }
                    error_codes[k] = 0;
                }
                int otherInfoCode = 11;
                if (provedReq != null) {
                    error_codes = new int[1];
                    auditRequesterID = this.auditRequesterID(provedReq);
                    try {
                        profile.validate(provedReq);
                        profile.execute(provedReq);
                        reqs = new Request[]{provedReq};
                        reqs[0].setRequestStatus(RequestStatus.COMPLETE);
                        x509cert = reqs[0].getExtDataInCert("req_issued_cert");
                        if (x509cert != null) {
                            auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)x509cert));
                        }
                    }
                    catch (ERejectException e) {
                        provedReq.setRequestStatus(RequestStatus.REJECTED);
                        logger.warn("ProfileSubmitCMCServlet: provedReq submit- " + e.getMessage(), (Throwable)e);
                        errorCode = "3";
                        errorReason = CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REJECTED", (String[])new String[]{e.toString()});
                        otherInfoCode = 2;
                    }
                    catch (Exception e) {
                        logger.warn("ProfileSubmitCMCServlet: provedReq submit- " + e.getMessage(), (Throwable)e);
                        errorCode = "1";
                        errorReason = CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]);
                    }
                    if (errorCode == null) {
                        engine.getRequestQueue().markAsServiced(provedReq);
                        logger.debug("ProfileSubmitCMCServlet: provedReq set to complete");
                    } else {
                        error_codes[0] = Integer.parseInt(errorCode);
                        engine.getRequestRepository().updateRequest(provedReq);
                        logger.warn("ProfileSubmitCMCServlet: provedReq updateRequest");
                        auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)errorReason));
                    }
                }
                if (errorCode != null) {
                    if (errorCode.equals("4")) {
                        template = new CMCOutputTemplate();
                        template.createFullResponse(response, reqs, cert_request_type, error_codes);
                        return;
                    }
                    template = new CMCOutputTemplate();
                    seq = new SEQUENCE();
                    seq.addElement((ASN1Value)new INTEGER(0L));
                    UTF8String s9 = null;
                    try {
                        s9 = new UTF8String(errorReason);
                    }
                    catch (Exception s10) {
                        // empty catch block
                    }
                    template.createFullResponseWithFailedStatus(response, seq, otherInfoCode, s9);
                    return;
                }
                logger.debug("ProfileSubmitCMCServlet: done serving");
                template = new CMCOutputTemplate();
                if (cert_request_type.equals("pkcs10") || cert_request_type.equals("crmf")) {
                    if (outputFormat != null && outputFormat.equals("pkcs7")) {
                        X509CertImpl cert = reqs[0].getExtDataInCert("req_issued_cert");
                        X509Certificate[] certChain = engine.getCertChain((X509Certificate)cert);
                        PKCS7 p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), certChain, new SignerInfo[0]);
                        byte[] pkcs7 = p7.getBytes();
                        response.setContentType("application/pkcs7-mime");
                        response.setContentLength(pkcs7.length);
                        try {
                            ServletOutputStream os = response.getOutputStream();
                            os.write(pkcs7);
                            os.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    template.createSimpleResponse(response, reqs);
                    break block150;
                }
                if (cert_request_type.equals("cmc")) {
                    TaggedAttribute attr1;
                    Integer nums = (Integer)context.get((Object)"numOfControls");
                    if (nums != null && nums == 1 && (attr1 = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_getCert)) != null) {
                        template.createSimpleResponse(response, reqs);
                        return;
                    }
                    template.createFullResponse(response, reqs, cert_request_type, error_codes);
                }
            }
            catch (Exception e) {
                throw new EBaseException(e);
            }
            finally {
                SessionContext.releaseContext();
            }
        }
    }

    private String auditRequesterID(Request request) {
        String id;
        String requesterID = "$Unidentified$";
        if (request != null && (id = request.getRequestId().toString()) != null) {
            requesterID = id.trim();
        }
        return requesterID;
    }
}

