/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ca.EErrorPublishCRL;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.ScheduleCRLGenerationEvent;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.LdapRule;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.util.StatsSubsystem;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="camasterCAUpdateCRL", urlPatterns={"/agent/ca/updateCRL"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/agent/ca/updateCRL.template"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="camasterCAUpdateCRL"), @WebInitParam(name="resourceID", value="certServer.ca.crl"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr")})
public class UpdateCRL
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(UpdateCRL.class);
    private static final long serialVersionUID = -1182106454856991246L;
    private static final String TPL_FILE = "updateCRL.template";
    private static Vector<String> mTesting = new Vector();
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ca/updateCRL.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        logger.info("UpdateCRL: Updating CRL");
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        logger.debug("UpdateCRL:process: Incoming Request: " + req.toString());
        CAEngine engine = CAEngine.getInstance();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("crl", true);
        }
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "update");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            if (statsSub != null) {
                statsSub.endTiming("crl");
            }
            return;
        }
        EBaseException error = null;
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            if (statsSub != null) {
                statsSub.endTiming("crl");
            }
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            String signatureAlgorithm = req.getParameter("signatureAlgorithm");
            this.process(argSet, header, req, resp, signatureAlgorithm, locale[0]);
        }
        catch (EBaseException e) {
            error = e;
        }
        logger.info("UpdateCRL: Done updating CRL");
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (statsSub != null) {
                statsSub.endTiming("crl");
            }
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        if (statsSub != null) {
            statsSub.endTiming("crl");
        }
    }

    private CRLExtensions crlEntryExtensions(String reason, String invalidity) {
        CRLExtensions entryExts = new CRLExtensions();
        CRLReasonExtension crlReasonExtn = null;
        if (reason != null && reason.length() > 0) {
            try {
                RevocationReason revReason = RevocationReason.valueOf((int)Integer.parseInt(reason));
                if (revReason == null) {
                    revReason = RevocationReason.UNSPECIFIED;
                }
                crlReasonExtn = new CRLReasonExtension(revReason);
            }
            catch (Exception e) {
                logger.warn("Invalid revocation reason: " + reason + ": " + e.getMessage(), (Throwable)e);
            }
        }
        InvalidityDateExtension invalidityDateExtn = null;
        if (invalidity != null && invalidity.length() > 0) {
            long now = System.currentTimeMillis();
            Date invalidityDate = null;
            try {
                long backInTime = Long.parseLong(invalidity);
                invalidityDate = new Date(now - backInTime * 60000L);
            }
            catch (Exception e) {
                logger.warn("Invalid invalidity time offset: " + invalidity + ": " + e.getMessage(), (Throwable)e);
            }
            if (invalidityDate != null) {
                try {
                    invalidityDateExtn = new InvalidityDateExtension(invalidityDate);
                }
                catch (Exception e) {
                    logger.warn("Error creating invalidity extension: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (crlReasonExtn != null) {
            try {
                entryExts.set(crlReasonExtn.getName(), crlReasonExtn);
            }
            catch (Exception e) {
                logger.warn("Error adding revocation reason extension to entry extensions: " + e.getMessage(), (Throwable)e);
            }
        }
        if (invalidityDateExtn != null) {
            try {
                entryExts.set(invalidityDateExtn.getName(), invalidityDateExtn);
            }
            catch (Exception e) {
                logger.warn("Error adding invalidity date extension to entry extensions: " + e.getMessage(), (Throwable)e);
            }
        }
        return entryExts;
    }

    private void addInfo(CMSTemplateParams argSet, CRLIssuingPoint crlIssuingPoint, long cacheUpdate) {
        ArgBlock rarg = new ArgBlock();
        rarg.addLongValue("cacheUpdate", cacheUpdate);
        Object crlNumbers = crlIssuingPoint.getCRLNumber().toString();
        BigInteger deltaNumber = crlIssuingPoint.getDeltaCRLNumber();
        String crlSizes = "" + crlIssuingPoint.getCRLSize();
        if (deltaNumber != null && deltaNumber.compareTo(BigInteger.ZERO) > 0) {
            if (crlNumbers != null) {
                crlNumbers = (String)crlNumbers + ",";
            }
            if (crlNumbers != null) {
                crlNumbers = (String)crlNumbers + deltaNumber.toString();
            }
            if (crlSizes != null) {
                crlSizes = crlSizes + "," + crlIssuingPoint.getDeltaCRLSize();
            }
        }
        rarg.addStringValue("crlNumbers", (String)crlNumbers);
        rarg.addStringValue("crlSizes", crlSizes);
        StringBuffer crlSplits = new StringBuffer();
        Vector<Long> splits = crlIssuingPoint.getSplitTimes();
        for (int i = 0; i < splits.size(); ++i) {
            crlSplits.append(splits.elementAt(i));
            if (i + 1 >= splits.size()) continue;
            crlSplits.append(",");
        }
        rarg.addStringValue("crlSplits", crlSplits.toString());
        argSet.addRepeatRecord(rarg);
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, HttpServletRequest req, HttpServletResponse resp, String signatureAlgorithm, Locale locale) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        long startTime = new Date().getTime();
        String waitForUpdate = req.getParameter("waitForUpdate");
        String clearCache = req.getParameter("clearCRLCache");
        String crlIssuingPointId = req.getParameter("crlIssuingPoint");
        String test = req.getParameter("test");
        String add = req.getParameter("add");
        String from = req.getParameter("from");
        String by = req.getParameter("by");
        String reason = req.getParameter("reason");
        String invalidity = req.getParameter("invalidity");
        String results = req.getParameter("results");
        String futureThisUpdateValue = req.getParameter("customFutureThisUpdateDateValue");
        Date futureThisUpdate = UpdateCRL.getFutureUpdateFromString(futureThisUpdateValue);
        String cancelCurFutureThisUpdateValue = req.getParameter("cancelCurCustomFutureThisUpdateValue");
        if (futureThisUpdate == null) {
            logger.debug("UpdateCRL:process : customFutureThisUpdate value is either not present or an illegal value, treating as null. ");
        }
        if (crlIssuingPointId != null) {
            CRLIssuingPoint ip;
            Enumeration<CRLIssuingPoint> ips = Collections.enumeration(engine.getCRLIssuingPoints());
            while (ips.hasMoreElements() && !crlIssuingPointId.equals((ip = ips.nextElement()).getId())) {
                if (ips.hasMoreElements()) continue;
                crlIssuingPointId = null;
            }
        }
        if (crlIssuingPointId == null) {
            crlIssuingPointId = "MasterCRL";
        }
        logger.info("UpdateCRL: issuing point: " + crlIssuingPointId);
        CRLIssuingPoint crlIssuingPoint = engine.getCRLIssuingPoint(crlIssuingPointId);
        header.addStringValue("crlIssuingPoint", crlIssuingPointId);
        CAPublisherProcessor lpm = engine.getPublisherProcessor();
        if (crlIssuingPoint == null) {
            logger.warn("Unable to find CRL issuing point " + crlIssuingPointId);
            return;
        }
        if (futureThisUpdate != null) {
            crlIssuingPoint.setCustomFutureThisUpdateValue(futureThisUpdate);
        } else if ("true".equals(cancelCurFutureThisUpdateValue)) {
            crlIssuingPoint.setCancelCurFutureThisUpdateValue(true);
        }
        if (clearCache != null && clearCache.equals("true") && crlIssuingPoint.isCRLGenerationEnabled() && crlIssuingPoint.isCRLUpdateInProgress() == 0 && crlIssuingPoint.isCRLIssuingPointInitialized()) {
            logger.debug("UpdateCRL: clearing CRL cache");
            crlIssuingPoint.clearCRLCache();
        }
        if (!(waitForUpdate != null && waitForUpdate.equals("true") && crlIssuingPoint.isCRLGenerationEnabled() && crlIssuingPoint.isCRLUpdateInProgress() == 0 && crlIssuingPoint.isCRLIssuingPointInitialized())) {
            if (!crlIssuingPoint.isCRLIssuingPointInitialized()) {
                logger.info("UpdateCRL: CRL issuing point not initialized");
                header.addStringValue("crlUpdate", "notInitialized");
            } else if (crlIssuingPoint.isCRLUpdateInProgress() != 0 || crlIssuingPoint.isManualUpdateSet()) {
                logger.info("UpdateCRL: CRL update in progress");
                header.addStringValue("crlUpdate", "inProgress");
            } else if (!crlIssuingPoint.isCRLGenerationEnabled()) {
                logger.info("UpdateCRL: CRL update disabled");
                header.addStringValue("crlUpdate", "Disabled");
            } else {
                try {
                    logger.info("UpdateCRL: Scheduling CRL update");
                    crlIssuingPoint.setManualUpdate(signatureAlgorithm);
                    header.addStringValue("crlUpdate", "Scheduled");
                    auditor.log((LogEvent)new ScheduleCRLGenerationEvent(this.auditSubjectID()));
                }
                catch (Exception e) {
                    auditor.log((LogEvent)new ScheduleCRLGenerationEvent(this.auditSubjectID(), e));
                    throw e;
                }
            }
            return;
        }
        if (test != null && test.equals("true") && crlIssuingPoint.isCRLCacheTestingEnabled() && !mTesting.contains(crlIssuingPointId)) {
            logger.debug("UpdateCRL: CRL test started");
            mTesting.add(crlIssuingPointId);
            BigInteger addLen = null;
            BigInteger startFrom = null;
            if (add != null && add.length() > 0 && from != null && from.length() > 0) {
                try {
                    addLen = new BigInteger(add);
                    startFrom = new BigInteger(from);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (addLen != null && startFrom != null) {
                Date revocationDate = new Date();
                String err = null;
                CRLExtensions entryExts = this.crlEntryExtensions(reason, invalidity);
                BigInteger serialNumber = startFrom;
                BigInteger counter = addLen;
                BigInteger stepBy = null;
                if (by != null && by.length() > 0) {
                    try {
                        stepBy = new BigInteger(by);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                long t1 = System.currentTimeMillis();
                long t2 = 0L;
                while (counter.compareTo(BigInteger.ZERO) > 0) {
                    RevokedCertImpl revokedCert = new RevokedCertImpl(serialNumber, revocationDate, entryExts);
                    crlIssuingPoint.addRevokedCert(serialNumber, revokedCert);
                    serialNumber = serialNumber.add(BigInteger.ONE);
                    if ((counter = counter.subtract(BigInteger.ONE)).compareTo(BigInteger.ZERO) != 0 && (stepBy == null || counter.mod(stepBy).compareTo(BigInteger.ZERO) != 0)) continue;
                    t2 = System.currentTimeMillis();
                    long t0 = t2 - t1;
                    t1 = t2;
                    try {
                        if (signatureAlgorithm != null) {
                            crlIssuingPoint.updateCRLNow(signatureAlgorithm);
                        } else {
                            crlIssuingPoint.updateCRLNow();
                        }
                    }
                    catch (Throwable e) {
                        counter = BigInteger.ZERO;
                        err = e.toString();
                    }
                    if (results == null || !results.equals("1")) continue;
                    this.addInfo(argSet, crlIssuingPoint, t0);
                }
                if (err != null) {
                    header.addStringValue("crlUpdate", "Failure");
                    header.addStringValue("error", err);
                } else {
                    header.addStringValue("crlUpdate", "Success");
                }
            } else {
                logger.debug("UpdateCRL: CRL test error: missing parameters");
                header.addStringValue("crlUpdate", "missingParameters");
            }
            mTesting.remove(crlIssuingPointId);
            logger.debug("UpdateCRL: CRL test finished");
            return;
        }
        if (test != null && test.equals("true") && crlIssuingPoint.isCRLCacheTestingEnabled() && mTesting.contains(crlIssuingPointId)) {
            header.addStringValue("crlUpdate", "testingInProgress");
            return;
        }
        if (test != null && test.equals("true") && !crlIssuingPoint.isCRLCacheTestingEnabled()) {
            header.addStringValue("crlUpdate", "testingNotEnabled");
            return;
        }
        logger.info("UpdateCRL: Updating CRL for " + crlIssuingPointId);
        try {
            Enumeration<LdapRule> rules;
            EErrorPublishCRL publishError = null;
            try {
                long now1 = System.currentTimeMillis();
                if (signatureAlgorithm != null) {
                    crlIssuingPoint.updateCRLNow(signatureAlgorithm);
                } else {
                    crlIssuingPoint.updateCRLNow();
                }
                long now2 = System.currentTimeMillis();
                header.addStringValue("time", "" + (now2 - now1));
            }
            catch (EErrorPublishCRL e) {
                publishError = e;
            }
            if (lpm != null && lpm.isCRLPublishingEnabled() && (rules = lpm.getRules("crl")) != null && rules.hasMoreElements()) {
                if (publishError != null) {
                    header.addStringValue("crlPublished", "Failure");
                    header.addStringValue("error", publishError.toString(locale));
                } else {
                    header.addStringValue("crlPublished", "Success");
                }
            }
            SessionContext sContext = SessionContext.getContext();
            String agentId = (String)sContext.get((Object)"userid");
            AuthToken authToken = (AuthToken)sContext.get((Object)"AuthToken");
            String authMgr = "noAuthManager";
            if (authToken != null) {
                authMgr = authToken.getInString("authMgrInstName");
            }
            long endTime = new Date().getTime();
            if (crlIssuingPoint.getNextUpdate() != null) {
                logger.info("CRLUpdate request {} authenticated by {} is {}. Id: {}\ncrl Number: {} last update time: {} next update time: {} number of entries in the CRL: {}", new Object[]{"fromAgent agentID: " + agentId, authMgr, "completed", crlIssuingPoint.getId(), crlIssuingPoint.getCRLNumber(), crlIssuingPoint.getLastUpdate(), crlIssuingPoint.getNextUpdate(), crlIssuingPoint.getCRLSize() + " time: " + (endTime - startTime)});
            } else {
                logger.info("CRLUpdate request {} authenticated by {} is {}. Id: {}\ncrl Number: {} last update time: {} next update time: {} number of entries in the CRL: {}", new Object[]{"fromAgent agentID: " + agentId, authMgr, "completed", crlIssuingPoint.getId(), crlIssuingPoint.getCRLNumber(), crlIssuingPoint.getLastUpdate(), "not set", crlIssuingPoint.getCRLSize() + " time: " + (endTime - startTime)});
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_UPDATE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (lpm != null && lpm.isCRLPublishingEnabled() && e instanceof ELdapException) {
                header.addStringValue("crlPublished", "Failure");
                header.addStringValue("error", e.toString(locale));
            }
            throw e;
        }
    }

    private static Date getFutureUpdateFromString(String futureThisUpdateValue) {
        Date futureDate = null;
        if (futureThisUpdateValue == null || futureThisUpdateValue.length() == 0) {
            return null;
        }
        String[] date_values = null;
        try {
            date_values = futureThisUpdateValue.split(":", 6);
        }
        catch (Exception e) {
            return null;
        }
        if (date_values == null || date_values.length < 3) {
            return null;
        }
        int date_len = date_values.length;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int min = 0;
        int seconds = 0;
        try {
            year = Integer.parseInt(date_values[0]);
            month = Integer.parseInt(date_values[1]);
            day = Integer.parseInt(date_values[2]);
            if (date_len >= 4 && date_values[3] != null) {
                hour = Integer.parseInt(date_values[3]);
            }
            if (date_len >= 5 && date_values[4] != null) {
                min = Integer.parseInt(date_values[4]);
            }
            if (date_len == 6 && date_values[5] != null) {
                seconds = Integer.parseInt(date_values[5]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        Calendar thisUpdate = Calendar.getInstance();
        thisUpdate.set(year, --month, day, hour, min, seconds);
        futureDate = thisUpdate.getTime();
        return futureDate;
    }
}

