/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caSrchCerts", urlPatterns={"/ee/ca/srchCerts"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="templatePath", value="/ee/ca/srchCert.template"), @WebInitParam(name="ID", value="caSrchCerts"), @WebInitParam(name="resourceID", value="certServer.ee.certificates"), @WebInitParam(name="timeLimits", value="10")})
public class SrchCerts
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(SrchCerts.class);
    private static final long serialVersionUID = -5876805830088921643L;
    private static final String TPL_FILE = "srchCert.template";
    private static final String PROP_MAX_SEARCH_RETURNS = "maxSearchReturns";
    private static final String CURRENT_TIME = "currentTime";
    private static final int MAX_RESULTS = 1000;
    private CertificateRepository mCertDB;
    private X500Name mAuthName = null;
    private String mFormPath = null;
    private int mMaxReturns = 1000;
    private int mTimeLimits = 30;
    private boolean mUseClientFilter = false;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CertificateAuthority ca = engine.getCA();
        CAConfig authConfig = ca.getConfigStore();
        if (authConfig != null) {
            try {
                this.mMaxReturns = authConfig.getInteger(PROP_MAX_SEARCH_RETURNS, 1000);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
        }
        this.mCertDB = engine.getCertificateRepository();
        this.mAuthName = ca.getX500Name();
        this.mFormPath = "/ca/srchCert.template";
        try {
            int maxResults = Integer.parseInt(sc.getInitParameter("maxResults"));
            if (maxResults < this.mMaxReturns) {
                this.mMaxReturns = maxResults;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mTimeLimits = Integer.parseInt(sc.getInitParameter("timeLimits"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sc.getInitParameter("useClientFilter") != null && sc.getInitParameter("useClientFilter").equalsIgnoreCase("true")) {
            this.mUseClientFilter = true;
        }
    }

    private boolean isOn(HttpServletRequest req, String name) {
        String inUse = req.getParameter(name);
        if (inUse == null) {
            return false;
        }
        return inUse.equals("on");
    }

    private boolean isOff(HttpServletRequest req, String name) {
        String inUse = req.getParameter(name);
        if (inUse == null) {
            return false;
        }
        return inUse.equals("off");
    }

    private void buildCertStatusFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "statusInUse")) {
            return;
        }
        String status = req.getParameter("status");
        filter.append("(certStatus=");
        filter.append(status);
        filter.append(")");
    }

    private void buildProfileFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "profileInUse")) {
            return;
        }
        String profile = req.getParameter("profile");
        filter.append("(certMetaInfo=profileId:");
        filter.append(profile);
        filter.append(")");
    }

    private void buildBasicConstraintsFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "basicConstraintsInUse")) {
            return;
        }
        filter.append("(x509cert.BasicConstraints.isCA=on)");
    }

    private void buildSerialNumberRangeFilter(HttpServletRequest req, StringBuffer filter) {
        String serialTo;
        if (!this.isOn(req, "serialNumberRangeInUse")) {
            return;
        }
        boolean changed = false;
        String serialFrom = req.getParameter("serialFrom");
        if (serialFrom != null && !serialFrom.equals("")) {
            filter.append("(certRecordId>=" + serialFrom + ")");
            changed = true;
        }
        if ((serialTo = req.getParameter("serialTo")) != null && !serialTo.equals("")) {
            filter.append("(certRecordId<=" + serialTo + ")");
            changed = true;
        }
        if (!changed) {
            filter.append("(certRecordId=*)");
        }
    }

    private void buildAVAFilter(HttpServletRequest req, String paramName, String avaName, StringBuffer lf, String match) {
        String val = req.getParameter(paramName);
        if (val != null && !val.equals("")) {
            if (match != null && match.equals("exact")) {
                lf.append("(|");
                lf.append("(x509cert.subject=*");
                lf.append(avaName);
                lf.append("=");
                lf.append(LDAPUtil.escapeFilter((Object)LDAPUtil.escapeRDNValue((Object)val)));
                lf.append(",*)");
                lf.append("(x509cert.subject=*");
                lf.append(avaName);
                lf.append("=");
                lf.append(LDAPUtil.escapeFilter((Object)LDAPUtil.escapeRDNValue((Object)val)));
                lf.append(")");
                lf.append(")");
            } else {
                lf.append("(x509cert.subject=*");
                lf.append(avaName);
                lf.append("=");
                lf.append("*");
                lf.append(LDAPUtil.escapeFilter((Object)LDAPUtil.escapeRDNValue((Object)val)));
                lf.append("*)");
            }
        }
    }

    private void buildSubjectFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "subjectInUse")) {
            return;
        }
        StringBuffer lf = new StringBuffer();
        String match = req.getParameter("match");
        this.buildAVAFilter(req, "eMail", "E", lf, match);
        this.buildAVAFilter(req, "commonName", "CN", lf, match);
        this.buildAVAFilter(req, "userID", "UID", lf, match);
        this.buildAVAFilter(req, "orgUnit", "OU", lf, match);
        this.buildAVAFilter(req, "org", "O", lf, match);
        this.buildAVAFilter(req, "locality", "L", lf, match);
        this.buildAVAFilter(req, "state", "ST", lf, match);
        this.buildAVAFilter(req, "country", "C", lf, match);
        if (lf.length() == 0) {
            filter.append("(x509cert.subject=*)");
            return;
        }
        if (match.equals("exact")) {
            filter.append("(&");
            filter.append(lf);
            filter.append(")");
        } else {
            filter.append("(|");
            filter.append(lf);
            filter.append(")");
        }
    }

    private void buildRevokedByFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "revokedByInUse")) {
            return;
        }
        String revokedBy = req.getParameter("revokedBy");
        if (revokedBy == null || revokedBy.equals("")) {
            filter.append("(certRevokedBy=*)");
        } else {
            filter.append("(certRevokedBy=");
            filter.append(revokedBy);
            filter.append(")");
        }
    }

    private void buildDateFilter(HttpServletRequest req, String prefix, String outStr, long adjustment, StringBuffer filter) {
        long epoch = 0L;
        try {
            epoch = Long.parseLong(req.getParameter(prefix));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Calendar from = Calendar.getInstance();
        from.setTimeInMillis(epoch);
        logger.debug("buildDateFilter epoch=" + req.getParameter(prefix));
        logger.debug("buildDateFilter from=" + from);
        filter.append("(");
        filter.append(outStr);
        filter.append(Long.toString(from.getTimeInMillis() + adjustment));
        filter.append(")");
    }

    private void buildRevokedOnFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "revokedOnInUse")) {
            return;
        }
        this.buildDateFilter(req, "revokedOnFrom", "certRevokedOn>=", 0L, filter);
        this.buildDateFilter(req, "revokedOnTo", "certRevokedOn<=", 86399999L, filter);
    }

    private void buildRevocationReasonFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "revocationReasonInUse")) {
            return;
        }
        String reasons = req.getParameter("revocationReason");
        if (reasons == null) {
            return;
        }
        String queryCertFilter = null;
        StringTokenizer st = new StringTokenizer(reasons, ",");
        if (st.hasMoreTokens()) {
            filter.append("(|");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (queryCertFilter == null) {
                    queryCertFilter = "";
                }
                filter.append("(x509cert.certRevoInfo=");
                filter.append(token);
                filter.append(")");
            }
            filter.append(")");
        }
    }

    private void buildIssuedByFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "issuedByInUse")) {
            return;
        }
        String issuedBy = req.getParameter("issuedBy");
        if (issuedBy == null || issuedBy.equals("")) {
            filter.append("(certIssuedBy=*)");
        } else {
            filter.append("(certIssuedBy=");
            filter.append(issuedBy);
            filter.append(")");
        }
    }

    private void buildIssuedOnFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "issuedOnInUse")) {
            return;
        }
        this.buildDateFilter(req, "issuedOnFrom", "certCreateTime>=", 0L, filter);
        this.buildDateFilter(req, "issuedOnTo", "certCreateTime<=", 86399999L, filter);
    }

    private void buildValidNotBeforeFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "validNotBeforeInUse")) {
            return;
        }
        this.buildDateFilter(req, "validNotBeforeFrom", "x509cert.notBefore>=", 0L, filter);
        this.buildDateFilter(req, "validNotBeforeTo", "x509cert.notBefore<=", 86399999L, filter);
    }

    private void buildValidNotAfterFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "validNotAfterInUse")) {
            return;
        }
        this.buildDateFilter(req, "validNotAfterFrom", "x509cert.notAfter>=", 0L, filter);
        this.buildDateFilter(req, "validNotAfterTo", "x509cert.notAfter<=", 86399999L, filter);
    }

    private void buildValidityLengthFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "validityLengthInUse")) {
            return;
        }
        String op = req.getParameter("validityOp");
        long count = 0L;
        try {
            count = Long.parseLong(req.getParameter("count"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long unit = 0L;
        try {
            unit = Long.parseLong(req.getParameter("unit"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        filter.append("(");
        filter.append("x509cert.duration");
        filter.append(op);
        filter.append(count * unit);
        filter.append(")");
    }

    private void buildCertTypeFilter(HttpServletRequest req, StringBuffer filter) {
        if (!this.isOn(req, "certTypeInUse")) {
            return;
        }
        if (this.isOn(req, "SSLClient")) {
            filter.append("(x509cert.nsExtension.SSLClient=on)");
        } else if (this.isOff(req, "SSLClient")) {
            filter.append("(x509cert.nsExtension.SSLClient=off)");
        }
        if (this.isOn(req, "SSLServer")) {
            filter.append("(x509cert.nsExtension.SSLServer=on)");
        } else if (this.isOff(req, "SSLServer")) {
            filter.append("(x509cert.nsExtension.SSLServer=off)");
        }
        if (this.isOn(req, "SecureEmail")) {
            filter.append("(x509cert.nsExtension.SecureEmail=on)");
        } else if (this.isOff(req, "SecureEmail")) {
            filter.append("(x509cert.nsExtension.SecureEmail=off)");
        }
        if (this.isOn(req, "SubordinateSSLCA")) {
            filter.append("(x509cert.nsExtension.SubordinateSSLCA=on)");
        } else if (this.isOff(req, "SubordinateSSLCA")) {
            filter.append("(x509cert.nsExtension.SubordinateSSLCA=off)");
        }
        if (this.isOn(req, "SubordinateEmailCA")) {
            filter.append("(x509cert.nsExtension.SubordinateEmailCA=on)");
        } else if (this.isOff(req, "SubordinateEmailCA")) {
            filter.append("(x509cert.nsExtension.SubordinateEmailCA=off)");
        }
    }

    public String buildFilter(HttpServletRequest req) {
        Object queryCertFilter = req.getParameter("queryCertFilter");
        StringBuffer filter = new StringBuffer();
        this.buildSerialNumberRangeFilter(req, filter);
        this.buildSubjectFilter(req, filter);
        this.buildRevokedByFilter(req, filter);
        this.buildRevokedOnFilter(req, filter);
        this.buildRevocationReasonFilter(req, filter);
        this.buildIssuedByFilter(req, filter);
        this.buildIssuedOnFilter(req, filter);
        this.buildValidNotBeforeFilter(req, filter);
        this.buildValidNotAfterFilter(req, filter);
        this.buildValidityLengthFilter(req, filter);
        this.buildCertTypeFilter(req, filter);
        this.buildCertStatusFilter(req, filter);
        this.buildProfileFilter(req, filter);
        this.buildBasicConstraintsFilter(req, filter);
        if (this.mUseClientFilter) {
            logger.debug("useClientFilter=true");
        } else {
            logger.debug("useClientFilter=false");
            logger.debug("client queryCertFilter = " + (String)queryCertFilter);
            queryCertFilter = "(&" + filter.toString() + ")";
        }
        logger.debug("queryCertFilter = " + (String)queryCertFilter);
        return queryCertFilter;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String revokeAll = null;
        EBaseException error = null;
        int maxResults = -1;
        int timeLimit = -1;
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            String timeLimitStr;
            revokeAll = req.getParameter("revokeAll");
            String maxResultsStr = req.getParameter("maxResults");
            if (maxResultsStr != null && maxResultsStr.length() > 0) {
                maxResults = Integer.parseInt(maxResultsStr);
            }
            if ((timeLimitStr = req.getParameter("timeLimit")) != null && timeLimitStr.length() > 0) {
                timeLimit = Integer.parseInt(timeLimitStr);
            }
            String queryCertFilter = this.buildFilter(req);
            this.process(argSet, header, queryCertFilter, revokeAll, maxResults, timeLimit, req, resp, locale[0]);
        }
        catch (NumberFormatException e) {
            logger.warn(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, String filter, String revokeAll, int maxResults, int timeLimit, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws EBaseException {
        try {
            long startTime = new Date().getTime();
            if (filter.indexOf(CURRENT_TIME, 0) > -1) {
                filter = this.insertCurrentTime(filter);
            }
            if (maxResults == -1 || maxResults > this.mMaxReturns) {
                logger.debug("Resetting maximum of returned results from " + maxResults + " to " + this.mMaxReturns);
                maxResults = this.mMaxReturns;
            }
            if (timeLimit == -1 || timeLimit > this.mTimeLimits) {
                logger.debug("Resetting timelimit from " + timeLimit + " to " + this.mTimeLimits);
                timeLimit = this.mTimeLimits;
            }
            logger.debug("Start searching ... filter=" + filter + " maxreturns=" + maxResults + " timelimit=" + timeLimit);
            Enumeration<CertRecord> e = this.mCertDB.searchCertificates(filter, maxResults, timeLimit, "serialno");
            int count = 0;
            while (e != null && e.hasMoreElements()) {
                CertRecord rec = e.nextElement();
                if (rec == null) continue;
                ++count;
                ArgBlock rarg = new ArgBlock();
                this.fillRecordIntoArg(rec, rarg);
                argSet.addRepeatRecord(rarg);
            }
            long endTime = new Date().getTime();
            header.addStringValue("op", req.getParameter("op"));
            if (this.mAuthName != null) {
                header.addStringValue("issuerName", this.mAuthName.toString());
            }
            header.addStringValue("time", Long.toString(endTime - startTime));
            header.addStringValue("serviceURL", req.getRequestURI());
            header.addStringValue("queryFilter", filter);
            if (revokeAll != null) {
                header.addStringValue("revokeAll", revokeAll);
            }
            header.addIntegerValue("totalRecordCount", count);
            header.addIntegerValue("maxSize", maxResults);
        }
        catch (EBaseException e) {
            CMS.getLogMessage((String)"CMSGW_ERROR_LISTCERTS", (Object[])new Object[]{e.toString()});
            throw e;
        }
    }

    private String insertCurrentTime(String filter) {
        Date now = null;
        StringBuffer newFilter = new StringBuffer();
        int k = 0;
        int i = filter.indexOf(CURRENT_TIME, k);
        while (i > -1) {
            if (now == null) {
                now = new Date();
            }
            newFilter.append(filter.substring(k, i));
            newFilter.append(now.getTime());
            k = i + CURRENT_TIME.length();
            i = filter.indexOf(CURRENT_TIME, k);
        }
        if (k > 0) {
            newFilter.append(filter.substring(k, filter.length()));
        }
        return newFilter.toString();
    }

    private void fillRecordIntoArg(CertRecord rec, ArgBlock rarg) throws EBaseException {
        X509CertImpl xcert = rec.getCertificate();
        if (xcert != null) {
            this.fillX509RecordIntoArg(rec, rarg);
        }
    }

    private void fillX509RecordIntoArg(CertRecord rec, ArgBlock rarg) throws EBaseException {
        X509CertImpl cert = rec.getCertificate();
        rarg.addIntegerValue("version", cert.getVersion());
        rarg.addStringValue("serialNumber", cert.getSerialNumber().toString(16));
        rarg.addStringValue("serialNumberDecimal", cert.getSerialNumber().toString());
        String subject = cert.getSubjectName().toString();
        if (subject.equals("")) {
            rarg.addStringValue("subject", " ");
        } else {
            rarg.addStringValue("subject", subject);
        }
        rarg.addStringValue("type", "X.509");
        try {
            PublicKey pKey = cert.getPublicKey();
            X509Key key = null;
            if (pKey instanceof CertificateX509Key) {
                CertificateX509Key certKey = (CertificateX509Key)pKey;
                key = (X509Key)certKey.get("value");
            }
            if (pKey instanceof X509Key) {
                key = (X509Key)pKey;
            }
            rarg.addStringValue("subjectPublicKeyAlgorithm", key.getAlgorithmId().getOID().toString());
            if (key.getAlgorithmId().toString().equalsIgnoreCase("RSA")) {
                RSAPublicKey rsaKey = new RSAPublicKey(key.getEncoded());
                rarg.addIntegerValue("subjectPublicKeyLength", rsaKey.getKeySize());
            }
        }
        catch (Exception e) {
            rarg.addStringValue("subjectPublicKeyAlgorithm", null);
            rarg.addIntegerValue("subjectPublicKeyLength", 0);
        }
        rarg.addLongValue("validNotBefore", cert.getNotBefore().getTime() / 1000L);
        rarg.addLongValue("validNotAfter", cert.getNotAfter().getTime() / 1000L);
        rarg.addStringValue("signatureAlgorithm", cert.getSigAlgOID());
        String issuedBy = rec.getIssuedBy();
        if (issuedBy == null) {
            issuedBy = "";
        }
        rarg.addStringValue("issuedBy", issuedBy);
        rarg.addLongValue("issuedOn", rec.getCreateTime().getTime() / 1000L);
        rarg.addStringValue("revokedBy", rec.getRevokedBy() == null ? "" : rec.getRevokedBy());
        if (rec.getRevokedOn() == null) {
            rarg.addStringValue("revokedOn", null);
        } else {
            CRLExtensions crlExts;
            rarg.addLongValue("revokedOn", rec.getRevokedOn().getTime() / 1000L);
            RevocationInfo revocationInfo = rec.getRevocationInfo();
            if (revocationInfo != null && (crlExts = revocationInfo.getCRLEntryExtensions()) != null) {
                Enumeration enum1 = crlExts.getElements();
                int reason = 0;
                while (enum1.hasMoreElements()) {
                    Extension ext = (Extension)enum1.nextElement();
                    if (!(ext instanceof CRLReasonExtension)) continue;
                    reason = ((CRLReasonExtension)ext).getReason().getCode();
                    break;
                }
                rarg.addIntegerValue("revocationReason", reason);
            }
        }
    }
}

