/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.security.JssSubsystem;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

@WebServlet(name="caRevocation", urlPatterns={"/ee/ca/revocation"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="successTemplate", value="/ee/ca/reasonToRevoke.template"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="ID", value="caRevocation"), @WebInitParam(name="resourceID", value="certServer.ee.request.revocation"), @WebInitParam(name="AuthMgr", value="sslClientCertAuthMgr"), @WebInitParam(name="interface", value="ee")})
public class RevocationServlet
extends CMSServlet {
    private static final long serialVersionUID = -9086730404084717413L;
    private static final String PROP_REVOKEBYDN = "revokeByDN";
    private static final String TPL_FILE = "reasonToRevoke.template";
    public static final String SERIAL_NO = "serialNo";
    public static final String REASON_CODE = "reasonCode";
    private String mFormPath = null;
    private boolean mRevokeByDN = true;
    private SecureRandom mRandom = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mFormPath = "/reasonToRevoke.template";
        try {
            this.mFormPath = sc.getInitParameter("successTemplate");
            if (this.mFormPath == null) {
                this.mFormPath = "/reasonToRevoke.template";
            }
            if (engine.getEnableNonces()) {
                this.mRandom = jssSubsystem.getRandomNumberGenerator();
            }
            this.mRevokeByDN = false;
            String tmp = sc.getInitParameter(PROP_REVOKEBYDN);
            if (tmp == null || tmp.trim().equalsIgnoreCase("false")) {
                this.mRevokeByDN = false;
            } else if (tmp.trim().equalsIgnoreCase("true")) {
                this.mRevokeByDN = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        int i;
        ArgBlock httpParams = cmsReq.getHttpParams();
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        BigInteger old_serial_no = null;
        X509CertImpl old_cert = null;
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, httpReq, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "submit");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        if (this.mAuthMgr != null && this.mAuthMgr.equals("certUserDBAuthMgr")) {
            cert = new X509Certificate[1];
            old_serial_no = this.getCertFromAgent(httpParams, (X509Certificate[])cert);
            old_cert = cert[0];
        } else {
            cert = new X509CertImpl[1];
            old_serial_no = this.getCertFromAuthMgr(authToken, (X509Certificate[])cert);
            old_cert = cert[0];
        }
        header.addStringValue("serialNumber", old_cert.getSerialNumber().toString(16));
        header.addStringValue("serialNumberDecimal", old_cert.getSerialNumber().toString());
        boolean noInfo = false;
        X509CertImpl[] certsToRevoke = null;
        if (engine.getEnableNonces()) {
            long n = this.mRandom.nextLong();
            Map<Object, Long> nonces = engine.getNonces(cmsReq.getHttpReq(), "cert-revoke");
            nonces.put(old_serial_no, n);
            header.addStringValue("nonce", old_serial_no + ":" + n);
        }
        certsToRevoke = cr.getX509Certificates(old_cert.getSubjectName().toString(), 2);
        boolean authorized = false;
        if (certsToRevoke != null && certsToRevoke.length > 0) {
            for (i = 0; i < certsToRevoke.length; ++i) {
                if (!old_cert.getSerialNumber().equals(certsToRevoke[i].getSerialNumber())) continue;
                authorized = true;
                break;
            }
        }
        if (!(noInfo || certsToRevoke != null && certsToRevoke.length != 0 && authorized)) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_ALREADY_REVOKED_1", (Object[])new Object[]{old_serial_no.toString(16)}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CERT_ALREADY_REVOKED", (String[])new String[0]));
        }
        if (!this.mRevokeByDN || noInfo) {
            certsToRevoke = new X509CertImpl[]{old_cert};
            try {
                byte[] ba = old_cert.getEncoded();
                header.addStringValue("b64eCertificate", Utils.base64encode((byte[])ba, (boolean)true));
            }
            catch (CertificateEncodingException ba) {
                // empty catch block
            }
        }
        if (certsToRevoke != null && certsToRevoke.length > 0) {
            header.addIntegerValue("totalRecordCount", certsToRevoke.length);
            header.addIntegerValue("verifiedRecordCount", certsToRevoke.length);
            for (i = 0; i < certsToRevoke.length; ++i) {
                ArgBlock rarg = new ArgBlock();
                rarg.addStringValue("serialNumber", certsToRevoke[i].getSerialNumber().toString(16));
                rarg.addStringValue("serialNumberDecimal", certsToRevoke[i].getSerialNumber().toString());
                rarg.addStringValue("subject", certsToRevoke[i].getSubjectDN().toString());
                rarg.addLongValue("validNotBefore", certsToRevoke[i].getNotBefore().getTime() / 1000L);
                rarg.addLongValue("validNotAfter", certsToRevoke[i].getNotAfter().getTime() / 1000L);
                argSet.addRepeatRecord(rarg);
            }
        } else {
            header.addIntegerValue("totalRecordCount", 0);
            header.addIntegerValue("verifiedRecordCount", 0);
        }
        int reasonCode = httpParams.getValueAsInt(REASON_CODE, 0);
        header.addIntegerValue("reason", reasonCode);
        try {
            ServletOutputStream out = httpResp.getOutputStream();
            httpResp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
            cmsReq.setStatus(CMSRequest.SUCCESS);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private BigInteger getCertFromAgent(ArgBlock httpParams, X509Certificate[] certContainer) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certRepository = engine.getCertificateRepository();
        BigInteger serialno = null;
        X509CertImpl cert = null;
        serialno = httpParams.getValueAsBigInteger(SERIAL_NO, null);
        if (serialno == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_SERIALNO_FOR_REVOKE", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_SERIALNO_FOR_REVOKE", (String[])new String[0]));
        }
        cert = certRepository.getX509Certificate(serialno);
        if (cert == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERT_FOR_REVOCATION", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_FOR_REVOCATION", (String[])new String[0]));
        }
        certContainer[0] = cert;
        return serialno;
    }

    private BigInteger getCertFromAuthMgr(AuthToken authToken, X509Certificate[] certContainer) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certRepository = engine.getCertificateRepository();
        X509CertImpl cert = authToken.getInCert("tokenCert");
        if (cert == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTS_REVOKE_FROM_AUTHMGR", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_CERTS_REVOKE_FROM_AUTHMGR", (String[])new String[0]));
        }
        X509CertImpl certInDB = certRepository.getX509Certificate(cert.getSerialNumber());
        if (certInDB == null || !certInDB.equals((Object)cert)) {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERT_FOR_REVOCATION", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_FOR_REVOCATION", (String[])new String[0]));
        }
        certContainer[0] = cert;
        BigInteger serialno = cert.getSerialNumber();
        return serialno;
    }
}

