/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.cert.CrlCachePrettyPrint;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CRLRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.CrlPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetCRL", urlPatterns={"/ee/ca/getCRL"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="templatePath", value="/ee/ca/displayCRL.template"), @WebInitParam(name="ID", value="caGetCRL"), @WebInitParam(name="resourceID", value="certServer.ee.crl")})
public class GetCRL
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetCRL.class);
    private static final long serialVersionUID = 7132206924070383013L;
    private static final String TPL_FILE = "displayCRL.template";
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mFormPath = "/ca/displayCRL.template";
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        String crlDisplayType;
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        ArgBlock args = cmsReq.getHttpParams();
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        logger.debug("**** mFormPath before getTemplate = " + this.mFormPath);
        try {
            form = this.getTemplate(this.mFormPath, httpReq, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        String op = null;
        String crlId = null;
        op = args.getValueAsString("op", null);
        crlId = args.getValueAsString("crlIssuingPoint", null);
        if (op == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_OPTIONS_SELECTED", (Object[])new Object[0]));
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_OPTIONS_SELECTED", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        if (crlId == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_CRL_ISSUING_POINT", (Object[])new Object[0]));
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_CRL_SELECTED", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        CRLRepository crlRepository = engine.getCRLRepository();
        CRLIssuingPointRecord crlRecord = null;
        CRLIssuingPoint crlIP = engine.getCRLIssuingPoint(crlId);
        try {
            crlRecord = crlRepository.readCRLIssuingPointRecord(crlId);
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_CRL_ISSUING_POINT_FOUND", (Object[])new Object[]{crlId}), (Throwable)e);
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRL_NOT_FOUND", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        if (crlRecord == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_CRL_NOT_YET_UPDATED_1", (Object[])new Object[]{crlId}));
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRL_NOT_UPDATED", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        header.addStringValue("crlIssuingPoint", crlId);
        header.addStringValue("crlNumber", crlRecord.getCRLNumber().toString());
        long lCRLSize = crlRecord.getCRLSize();
        header.addLongValue("crlSize", lCRLSize);
        if (crlIP != null) {
            header.addStringValue("crlDescription", crlIP.getDescription());
        }
        if ((crlDisplayType = args.getValueAsString("crlDisplayType", null)) != null) {
            header.addStringValue("crlDisplayType", crlDisplayType);
        }
        if ((op.equals("checkCRLcache") || op.equals("displayCRL") && crlDisplayType != null && crlDisplayType.equals("cachedCRL")) && (crlIP == null || !crlIP.isCRLCacheEnabled() || crlIP.isCRLCacheEmpty())) {
            cmsReq.setError(CMS.getUserMessage((String)(crlIP != null && crlIP.isCRLCacheEnabled() && crlIP.isCRLCacheEmpty() ? "CMS_GW_CRL_CACHE_IS_EMPTY" : "CMS_GW_CRL_CACHE_IS_NOT_ENABLED"), (String[])new String[]{crlId}));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        byte[] crlbytes = null;
        if (op.equals("importDeltaCRL") || op.equals("getDeltaCRL") || op.equals("displayCRL") && crlDisplayType != null && crlDisplayType.equals("deltaCRL")) {
            crlbytes = crlRecord.getDeltaCRL();
        } else if (op.equals("importCRL") || op.equals("getCRL") || op.equals("checkCRL") || op.equals("displayCRL") && crlDisplayType != null && (crlDisplayType.equals("entireCRL") || crlDisplayType.equals("crlHeader") || crlDisplayType.equals("base64Encoded"))) {
            crlbytes = crlRecord.getCRL();
        }
        if (!(crlbytes != null || op.equals("checkCRLcache") || op.equals("displayCRL") && crlDisplayType != null && crlDisplayType.equals("cachedCRL"))) {
            logger.error(CMS.getLogMessage((String)"CMSGW_CRL_NOT_YET_UPDATED_1", (Object[])new Object[]{crlId}));
            cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRL_NOT_UPDATED", (String[])new String[0]))));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        byte[] bytes = crlbytes;
        X509CRLImpl crl = null;
        if (op.equals("checkCRL") || op.equals("importCRL") || op.equals("importDeltaCRL") || op.equals("displayCRL") && crlDisplayType != null && (crlDisplayType.equals("entireCRL") || crlDisplayType.equals("crlHeader") || crlDisplayType.equals("base64Encoded") || crlDisplayType.equals("deltaCRL"))) {
            try {
                crl = op.equals("displayCRL") && crlDisplayType != null && crlDisplayType.equals("crlHeader") ? new X509CRLImpl(crlbytes, false) : new X509CRLImpl(crlbytes);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_DECODE_CRL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DECODE_CRL_FAILED", (String[])new String[0]))));
                cmsReq.setStatus(CMSRequest.ERROR);
                return;
            }
            if ((op.equals("importDeltaCRL") || op.equals("displayCRL") && crlDisplayType != null && crlDisplayType.equals("deltaCRL")) && (crlIP == null || !crlIP.isThisCurrentDeltaCRL(crl)) && (crlRecord.getCRLNumber() == null || crlRecord.getDeltaCRLNumber() == null || crlRecord.getDeltaCRLNumber().compareTo(crlRecord.getCRLNumber()) < 0 || crlRecord.getDeltaCRLSize() == null || crlRecord.getDeltaCRLSize() == -1L)) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERR_NO_DELTA_CRL_1", (Object[])new Object[0]));
                cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRL_NOT_UPDATED", (String[])new String[0]))));
                cmsReq.setStatus(CMSRequest.ERROR);
                return;
            }
        }
        String mimeType = "application/x-pkcs7-crl";
        if (op.equals("checkCRLcache") || op.equals("checkCRL") || op.equals("displayCRL")) {
            header.addStringValue("toDo", op);
            String certSerialNumber = args.getValueAsString("certSerialNumber", "");
            header.addStringValue("certSerialNumber", certSerialNumber);
            if (certSerialNumber.startsWith("0x")) {
                certSerialNumber = this.hexToDecimal(certSerialNumber);
            }
            if (op.equals("checkCRLcache")) {
                if (crlIP.getRevocationDateFromCache(new BigInteger(certSerialNumber), false, false) != null) {
                    header.addBooleanValue("isOnCRL", true);
                } else {
                    header.addBooleanValue("isOnCRL", false);
                }
            }
            if (op.equals("checkCRL")) {
                header.addBooleanValue("isOnCRL", crl.isRevoked(new BigInteger(certSerialNumber)));
            }
            if (op.equals("displayCRL")) {
                if (crlDisplayType.equals("entireCRL") || crlDisplayType.equals("cachedCRL")) {
                    crlDetails = crlDisplayType.equals("entireCRL") ? new CrlPrettyPrint(crl) : new CrlCachePrettyPrint(crlIP);
                    String pageStart = args.getValueAsString("pageStart", null);
                    String pageSize = args.getValueAsString("pageSize", null);
                    if (pageStart != null && pageSize != null) {
                        long lPageStart = 0L;
                        long lPageSize = 0L;
                        try {
                            lPageStart = Long.valueOf(pageStart);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            lPageSize = Long.valueOf(pageSize);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (lPageStart < 1L) {
                            lPageStart = 1L;
                        }
                        if (lPageSize < 1L) {
                            lPageSize = 10L;
                        }
                        header.addStringValue("crlPrettyPrint", crlDetails.toString(locale[0], lCRLSize, lPageStart, lPageSize));
                        header.addLongValue("pageStart", lPageStart);
                        header.addLongValue("pageSize", lPageSize);
                    } else {
                        header.addStringValue("crlPrettyPrint", crlDetails.toString(locale[0]));
                    }
                } else if (crlDisplayType.equals("crlHeader")) {
                    crlDetails = new CrlPrettyPrint(crl);
                    header.addStringValue("crlPrettyPrint", crlDetails.toString(locale[0], lCRLSize, 0L, 0L));
                } else if (crlDisplayType.equals("base64Encoded")) {
                    try {
                        int k;
                        byte[] ba = crl.getEncoded();
                        String crlBase64Encoded = Utils.base64encode((byte[])ba, (boolean)true);
                        int length = crlBase64Encoded.length();
                        int i = 0;
                        int j = 0;
                        int n = 1;
                        while (i < length && (k = crlBase64Encoded.indexOf(10, i)) >= 0) {
                            if (n < 100) {
                                ++n;
                                i = k + 1;
                                continue;
                            }
                            n = 1;
                            ArgBlock rarg = new ArgBlock();
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, k));
                            j = i = k + 1;
                            argSet.addRepeatRecord(rarg);
                        }
                        if (j < length) {
                            ArgBlock rarg = new ArgBlock();
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, length));
                            argSet.addRepeatRecord(rarg);
                        }
                    }
                    catch (CRLException ba) {}
                } else if (crlDisplayType.equals("deltaCRL")) {
                    header.addIntegerValue("deltaCRLSize", crl.getNumberOfRevokedCertificates());
                    crlDetails = new CrlPrettyPrint(crl);
                    header.addStringValue("crlPrettyPrint", crlDetails.toString(locale[0], 0L, 0L, 0L));
                    try {
                        int k;
                        byte[] ba = crl.getEncoded();
                        String crlBase64Encoded = Utils.base64encode((byte[])ba, (boolean)true);
                        int length = crlBase64Encoded.length();
                        int i = 0;
                        int j = 0;
                        int n = 1;
                        while (i < length && (k = crlBase64Encoded.indexOf(10, i)) >= 0) {
                            if (n < 100) {
                                ++n;
                                i = k + 1;
                                continue;
                            }
                            n = 1;
                            ArgBlock rarg = new ArgBlock();
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, k));
                            j = i = k + 1;
                            argSet.addRepeatRecord(rarg);
                        }
                        if (j < length) {
                            ArgBlock rarg = new ArgBlock();
                            rarg.addStringValue("crlBase64Encoded", crlBase64Encoded.substring(j, length));
                            argSet.addRepeatRecord(rarg);
                        }
                    }
                    catch (CRLException cRLException) {
                        // empty catch block
                    }
                }
            }
            try {
                ServletOutputStream out = httpResp.getOutputStream();
                httpResp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                cmsReq.setError((EBaseException)((Object)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]))));
                cmsReq.setStatus(CMSRequest.ERROR);
            }
            return;
        }
        if (op.equals("importCRL") || op.equals("importDeltaCRL")) {
            mimeType = GetCRL.clientIsMSIE((HttpServletRequest)httpReq) ? "application/pkix-crl" : "application/x-pkcs7-crl";
        } else if (op.equals("getCRL")) {
            mimeType = "application/octet-stream";
            httpResp.setHeader("Content-disposition", "attachment; filename=" + crlId + ".crl");
        } else if (op.equals("getDeltaCRL")) {
            mimeType = "application/octet-stream";
            httpResp.setHeader("Content-disposition", "attachment; filename=delta-" + crlId + ".crl");
        } else {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_OPTIONS_SELECTED", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_OPTIONS_SELECTED", (String[])new String[0]));
        }
        try {
            httpResp.setContentType(mimeType);
            httpResp.setContentLength(bytes.length);
            httpResp.getOutputStream().write(bytes);
            httpResp.getOutputStream().flush();
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAYING_CRLINFO", (Object[])new Object[0]), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAYING_CRLINFO_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    private String hexToDecimal(String hex) {
        String newHex = hex.substring(2);
        BigInteger bi = new BigInteger(newHex, 16);
        return bi.toString();
    }
}

