/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestResource;
import com.netscape.certsrv.cert.CertResource;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.request.Request;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Date;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class CertRequestInfoFactory {
    public static CertRequestInfo create(Request request) throws SecurityException, NoSuchMethodException {
        CertRequestInfo info = new CertRequestInfo();
        RequestId requestId = request.getRequestId();
        info.setRequestID(requestId);
        String requestType = request.getRequestType();
        RequestStatus requestStatus = request.getRequestStatus();
        info.setRequestType(requestType);
        info.setRequestStatus(requestStatus);
        info.setCertRequestType(request.getExtDataInString("cert_request_type"));
        Integer result = request.getExtDataInInteger("Result");
        if (result == null || result.equals(Request.RES_SUCCESS)) {
            info.setOperationResult("success");
        } else {
            info.setOperationResult("error");
        }
        String error = request.getExtDataInString("Error");
        info.setErrorMessage(error);
        if (requestType != null && requestStatus == RequestStatus.COMPLETE) {
            X509CertImpl[] certs;
            X509CertImpl impl = request.getExtDataInCert("req_issued_cert");
            if (impl == null && requestType.equals("revocation") && (certs = request.getExtDataInCertArray("OLD_CERTS")) != null && certs.length > 0) {
                impl = certs[0];
            }
            if (impl != null) {
                BigInteger serialNo = impl.getSerialNumber();
                info.setCertId(new CertId(serialNo));
            }
        }
        Date creationTime = request.getCreationTime();
        info.setCreationTime(creationTime);
        Date modificationTime = request.getModificationTime();
        info.setModificationTime(modificationTime);
        return info;
    }

    public static CertRequestInfo create(Request request, UriInfo uriInfo) throws SecurityException, NoSuchMethodException {
        CertRequestInfo info = CertRequestInfoFactory.create(request);
        Method getRequestInfo = CertRequestResource.class.getMethod("getRequestInfo", RequestId.class);
        Path certRequestPath = getRequestInfo.getAnnotation(Path.class);
        UriBuilder reqBuilder = uriInfo.getBaseUriBuilder();
        reqBuilder.path(certRequestPath.value());
        info.setRequestURL(reqBuilder.build(new Object[]{info.getRequestID()}).toString());
        Method getCert = CertResource.class.getMethod("getCert", CertId.class);
        Path certPath = getCert.getAnnotation(Path.class);
        UriBuilder certBuilder = uriInfo.getBaseUriBuilder();
        certBuilder.path(certPath.value());
        CertId certID = info.getCertId();
        if (certID != null) {
            BigInteger serialNo = info.getCertId().toBigInteger();
            info.setCertURL(certBuilder.build(new Object[]{serialNo}).toString());
        }
        return info;
    }
}

