/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.cert.ImportCertsTemplateFiller;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

class CertFrRequestFiller
extends ImportCertsTemplateFiller {
    @Override
    public CMSTemplateParams getTemplateParams(CMSRequest cmsReq, IAuthority authority, Locale locale, Exception e) throws Exception {
        Request r;
        CAEngine engine = CAEngine.getInstance();
        CMSTemplateParams tparams = super.getTemplateParams(cmsReq, authority, locale, e);
        String reqId = cmsReq.getHttpParams().getValueAsString("requestId");
        tparams.getHeader().addStringValue("requestId", reqId);
        if (reqId != null && (r = engine.getRequestRepository().readRequest(new RequestId(reqId))) != null) {
            boolean noCertImport = true;
            String certType = r.getExtDataInString("HTTP_PARAMS", "certType");
            if (certType != null && certType.equals("client")) {
                noCertImport = false;
            }
            tparams.getHeader().addBooleanValue("noCertImport", noCertImport);
            X509CertImpl[] certs = r.getExtDataInCertArray("issuedCerts");
            if (certs != null) {
                X509CertInfo info = (X509CertInfo)certs[0].get("x509.info");
                CertificateExtensions extensions = (CertificateExtensions)info.get("extensions");
                tparams.getHeader().addStringValue("certtype", "x509");
                boolean emailCert = false;
                if (extensions != null) {
                    for (int i = 0; i < extensions.size(); ++i) {
                        NSCertTypeExtension type;
                        Extension ext = (Extension)extensions.elementAt(i);
                        if (ext instanceof NSCertTypeExtension && ((Boolean)(type = (NSCertTypeExtension)ext).get("email")).booleanValue()) {
                            emailCert = true;
                        }
                        if (!(ext instanceof KeyUsageExtension)) continue;
                        KeyUsageExtension usage = (KeyUsageExtension)ext;
                        try {
                            if (!((Boolean)usage.get("digital_signature")).booleanValue() && !((Boolean)usage.get("data_encipherment")).booleanValue()) continue;
                            emailCert = true;
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
                tparams.getHeader().addBooleanValue("emailCert", emailCert);
            }
        }
        return tparams;
    }
}

