/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.ca.CAService;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.publishers.PublisherUtils;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapEncryptCertPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapEncryptCertPublisher.class);
    public static final String LDAP_USERCERT_ATTR = "userCertificate;binary";
    public static final String PROP_REVOKE_CERT = "revokeCert";
    protected String mCertAttr = "userCertificate;binary";
    private ConfigStore mConfig;
    private boolean mInited = false;

    public LdapEncryptCertPublisher() {
    }

    public String getImplName() {
        return "LdapEncryptCertPublisher";
    }

    public String getDescription() {
        return "LdapEncryptCertPublisher";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"certAttr;string;LDAP attribute in which to store the certificate", "HELP_TOKEN;configuration-ldappublish-publisher-usercertpublisher", "HELP_TEXT;This plugin knows how to publish user certificates"};
        return params;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certAttr=" + this.mCertAttr);
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("certAttr=" + this.mCertAttr);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mCertAttr = this.mConfig.getString("certAttr", LDAP_USERCERT_ATTR);
        this.mInited = true;
    }

    public LdapEncryptCertPublisher(String certAttr) {
        this.mCertAttr = certAttr;
    }

    public void publish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (conn == null) {
            return;
        }
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        logger.info("Publishing " + cert);
        try {
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCertAttr}, false);
            LDAPEntry entry = res.next();
            LDAPAttribute attr = this.getModificationAttribute(entry.getAttribute(this.mCertAttr), certEnc);
            if (attr == null) {
                logger.info("publish: " + dn + " already has cert.");
                return;
            }
            LDAPModification mod = new LDAPModification(2, attr);
            conn.modify(dn, mod);
        }
        catch (CertificateEncodingException e) {
            logger.error("LdapEncryptCertPublisher: error in publish: " + e.getMessage(), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}));
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_PUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        if (!(certObj instanceof X509Certificate)) {
            throw new IllegalArgumentException("Illegal arg to publish");
        }
        X509Certificate cert = (X509Certificate)certObj;
        try {
            byte[] certEnc = cert.getEncoded();
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{this.mCertAttr}, false);
            LDAPEntry entry = res.next();
            if (!LdapEncryptCertPublisher.ByteValueExists(entry.getAttribute(this.mCertAttr), certEnc)) {
                logger.info(dn + " already has not cert");
                return;
            }
            LDAPModification mod = new LDAPModification(1, new LDAPAttribute(this.mCertAttr, certEnc));
            conn.modify(dn, mod);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_UNPUBLISH_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNPUBLISH_USERCERT_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public LDAPAttribute getModificationAttribute(LDAPAttribute attr, byte[] bval) {
        LDAPAttribute at = new LDAPAttribute(attr.getName(), bval);
        X509CertImpl thisCert = null;
        try {
            thisCert = new X509CertImpl(bval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (thisCert == null) {
            return at;
        }
        Enumeration vals = attr.getByteValues();
        byte[] val = null;
        while (vals.hasMoreElements()) {
            val = (byte[])vals.nextElement();
            try {
                X509CertImpl cert = new X509CertImpl(val);
                logger.info("Checking " + cert);
                if (CertUtils.isEncryptionCert((X509CertImpl)thisCert) && CertUtils.isEncryptionCert((X509CertImpl)cert)) {
                    logger.info("SKIP ENCRYPTION " + cert);
                    this.revokeCert(cert);
                    continue;
                }
                if (CertUtils.isSigningCert((X509CertImpl)thisCert) && CertUtils.isSigningCert((X509CertImpl)cert)) {
                    logger.info("SKIP SIGNING " + cert);
                    this.revokeCert(cert);
                    continue;
                }
                at.addValue(val);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_CHECK_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        }
        return at;
    }

    private RevokedCertImpl formCRLEntry(BigInteger serialNo, RevocationReason reason) throws EBaseException {
        CRLReasonExtension reasonExt = new CRLReasonExtension(reason);
        CRLExtensions crlentryexts = new CRLExtensions();
        try {
            crlentryexts.set("CRLReason", (Extension)reasonExt);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_SET_CRL_REASON", (Object[])new Object[]{reason.toString(), e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        RevokedCertImpl crlentry = new RevokedCertImpl(serialNo, new Date(), crlentryexts);
        return crlentry;
    }

    private void revokeCert(X509CertImpl cert) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        try {
            if (!this.mConfig.getBoolean(PROP_REVOKE_CERT, true)) {
                return;
            }
        }
        catch (EBaseException e) {
            return;
        }
        BigInteger serialNum = cert.getSerialNumber();
        CAService service = engine.getCAService();
        RevokedCertImpl crlEntry = this.formCRLEntry(serialNum, RevocationReason.KEY_COMPROMISE);
        service.revokeCert(crlEntry);
    }

    public static boolean ByteValueExists(LDAPAttribute attr, byte[] bval) {
        if (attr == null) {
            return false;
        }
        Enumeration vals = attr.getByteValues();
        byte[] val = null;
        while (vals.hasMoreElements()) {
            val = (byte[])vals.nextElement();
            if (!PublisherUtils.byteArraysAreEqual(val, bval)) continue;
            return true;
        }
        return false;
    }

    public static boolean StringValueExists(LDAPAttribute attr, String sval) {
        if (attr == null) {
            return false;
        }
        Enumeration vals = attr.getStringValues();
        String val = null;
        while (vals.hasMoreElements()) {
            val = (String)vals.nextElement();
            if (!val.equalsIgnoreCase(sval)) continue;
            return true;
        }
        return false;
    }
}

