/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cms.publish.mappers.LdapDNCompsMap;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCertCompsMap
extends LdapDNCompsMap {
    public static Logger logger = LoggerFactory.getLogger(LdapCertCompsMap.class);

    public LdapCertCompsMap() {
    }

    public LdapCertCompsMap(String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        this.init(baseDN, dnComps, filterComps);
    }

    @Override
    public String getImplName() {
        return "LdapCertCompsMap";
    }

    @Override
    public String getDescription() {
        return "LdapCertCompsMap";
    }

    @Override
    public Vector<String> getDefaultParams() {
        Vector<String> v = super.getDefaultParams();
        return v;
    }

    @Override
    public Vector<String> getInstanceParams() {
        Vector<String> v = super.getInstanceParams();
        return v;
    }

    public LdapCertCompsMap(String certAttr, String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        super(certAttr, baseDN, dnComps, filterComps);
    }

    @Override
    protected void init(String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        super.init(baseDN, dnComps, filterComps);
    }

    public String map(LDAPConnection conn, Object obj) throws ELdapException {
        if (conn == null) {
            return null;
        }
        try {
            X509Certificate cert = (X509Certificate)obj;
            String result = null;
            X500Name subjectDN = (X500Name)cert.getSubjectDN();
            logger.debug("LdapCertCompsMap: " + subjectDN);
            byte[] certbytes = cert.getEncoded();
            result = super.map(conn, subjectDN, certbytes);
            return result;
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_CANT_DECODE_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CERT_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (ClassCastException e) {
            try {
                X509CRLImpl crl = (X509CRLImpl)obj;
                String result = null;
                X500Name issuerDN = (X500Name)crl.getIssuerDN();
                logger.warn("LdapCertCompsMap: " + issuerDN + ": " + e.getMessage(), (Throwable)e);
                byte[] crlbytes = crl.getEncoded();
                result = super.map(conn, issuerDN, crlbytes);
                return result;
            }
            catch (CRLException ex) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_CANT_DECODE_CRL", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CRL_FAILED", (String[])new String[]{ex.toString()}), (Throwable)ex);
            }
            catch (ClassCastException ex) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_NOT_SUPPORTED_OBJECT", (Object[])new Object[0]), (Throwable)ex);
                return null;
            }
        }
    }

    public String map(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        return this.map(conn, obj);
    }
}

