/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.output;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.output.EnrollOutput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class CertOutput
extends EnrollOutput {
    public static final String VAL_PRETTY_CERT = "pretty_cert";
    public static final String VAL_B64_CERT = "b64_cert";

    public CertOutput() {
        this.addValueName(VAL_PRETTY_CERT);
        this.addValueName(VAL_B64_CERT);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_TEXT", (String[])new String[0]);
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws EProfileException {
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_PRETTY_CERT)) {
            return new Descriptor("pretty_print", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_PP", (String[])new String[0]));
        }
        if (name.equals(VAL_B64_CERT)) {
            return new Descriptor("pretty_print", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_B64", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public String getValue(String name, Locale locale, Request request) throws EProfileException {
        if (name.equals(VAL_PRETTY_CERT)) {
            X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
            if (cert == null) {
                return null;
            }
            CertPrettyPrint prettyCert = new CertPrettyPrint((Certificate)cert);
            return prettyCert.toString(locale);
        }
        if (name.equals(VAL_B64_CERT)) {
            X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
            if (cert == null) {
                return null;
            }
            try {
                return CertUtil.toPEM((X509Certificate)cert);
            }
            catch (Exception e) {
                throw new EProfileException((Throwable)e);
            }
        }
        return null;
    }
}

