/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.output;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.output.EnrollOutput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkix.cmmf.CertOrEncCert;
import org.mozilla.jss.pkix.cmmf.CertRepContent;
import org.mozilla.jss.pkix.cmmf.CertResponse;
import org.mozilla.jss.pkix.cmmf.CertifiedKeyPair;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;

public class CMMFOutput
extends EnrollOutput {
    public static final String VAL_PRETTY_CERT = "pretty_cert";
    public static final String VAL_CMMF_RESPONSE = "cmmf_response";

    public CMMFOutput() {
        this.addValueName(VAL_PRETTY_CERT);
        this.addValueName(VAL_CMMF_RESPONSE);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_TEXT", (String[])new String[0]);
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws EProfileException {
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_PRETTY_CERT)) {
            return new Descriptor("pretty_print", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_PP", (String[])new String[0]));
        }
        if (name.equals(VAL_CMMF_RESPONSE)) {
            return new Descriptor("pretty_print", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CMMF_B64", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public String getValue(String name, Locale locale, Request request) throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        if (name.equals(VAL_PRETTY_CERT)) {
            X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
            CertPrettyPrint prettyCert = new CertPrettyPrint((Certificate)cert);
            return prettyCert.toString(locale);
        }
        if (name.equals(VAL_CMMF_RESPONSE)) {
            try {
                X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
                if (cert == null) {
                    return null;
                }
                CertificateAuthority ca = engine.getCA();
                CertificateChain cachain = ca.getCACertChain();
                X509Certificate[] cacerts = cachain.getChain();
                byte[][] caPubs = new byte[cacerts.length][];
                for (int j = 0; j < cacerts.length; ++j) {
                    caPubs[j] = ((X509CertImpl)cacerts[j]).getEncoded();
                }
                CertRepContent certRepContent = null;
                certRepContent = new CertRepContent((byte[][])caPubs);
                PKIStatusInfo status = new PKIStatusInfo(0);
                CertifiedKeyPair certifiedKP = new CertifiedKeyPair(new CertOrEncCert(cert.getEncoded()));
                CertResponse resp = new CertResponse(new INTEGER(request.getRequestId().toString()), status, certifiedKP);
                certRepContent.addCertResponse(resp);
                ByteArrayOutputStream certRepOut = new ByteArrayOutputStream();
                certRepContent.encode((OutputStream)certRepOut);
                byte[] certRepBytes = certRepOut.toByteArray();
                return Utils.base64encode((byte[])certRepBytes, (boolean)true);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

