/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.EnrollProfile;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import java.util.Map;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualKeyGenInput
extends EnrollInput {
    public static Logger logger = LoggerFactory.getLogger(DualKeyGenInput.class);
    public static final String VAL_KEYGEN_REQUEST_TYPE = "cert_request_type";
    public static final String VAL_KEYGEN_REQUEST = "cert_request";
    public EnrollProfile mEnrollProfile = null;

    public DualKeyGenInput() {
        this.addValueName(VAL_KEYGEN_REQUEST_TYPE);
        this.addValueName(VAL_KEYGEN_REQUEST);
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
        this.mEnrollProfile = (EnrollProfile)profile;
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_DUAL_KEY_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_DUAL_KEY_TEXT", (String[])new String[0]);
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        String keygen_request_type = ctx.get(VAL_KEYGEN_REQUEST_TYPE);
        String keygen_request = ctx.get(VAL_KEYGEN_REQUEST);
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        if (keygen_request_type == null) {
            logger.error("DualKeyGenInput: populate - invalid cert request type");
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_UNKNOWN_CERT_REQ_TYPE", (String[])new String[]{""}));
        }
        if (keygen_request == null) {
            logger.error("DualKeyGenInput: populate - invalid certificate request");
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NO_CERT_REQ", (String[])new String[0]));
        }
        if (keygen_request_type.startsWith("pkcs10")) {
            CAEngine engine = CAEngine.getInstance();
            PKCS10 pkcs10 = engine.parsePKCS10(this.getLocale(request), keygen_request);
            this.mEnrollProfile.fillPKCS10(this.getLocale(request), pkcs10, info, request);
        } else if (keygen_request_type.startsWith("keygen")) {
            DerInputStream keygen = CertUtils.parseKeyGen((String)keygen_request);
            this.mEnrollProfile.fillKeyGen(this.getLocale(request), keygen, info, request);
        } else if (keygen_request_type.startsWith("crmf")) {
            CertReqMsg[] msgs = CertUtil.parseCRMF((String)keygen_request);
            if (msgs == null) {
                throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NO_CERT_REQ", (String[])new String[0]));
            }
            for (int x = 0; x < msgs.length; ++x) {
                this.verifyPOP(this.getLocale(request), msgs[x]);
            }
            Integer seqNum = request.getExtDataInInteger("req_seq_num");
            if (seqNum == null) {
                throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_UNKNOWN_SEQ_NUM", (String[])new String[0]));
            }
            this.mEnrollProfile.fillCertReqMsg(this.getLocale(request), msgs[seqNum], info, request);
        } else {
            logger.error("DualKeyGenInput: populate - invalid cert request type " + keygen_request_type);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_UNKNOWN_CERT_REQ_TYPE", (String[])new String[]{keygen_request_type}));
        }
        request.setExtData("req_x509info", info);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_KEYGEN_REQUEST_TYPE)) {
            return new Descriptor("dual_keygen_request_type", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_KEYGEN_REQ_TYPE", (String[])new String[0]));
        }
        if (name.equals(VAL_KEYGEN_REQUEST)) {
            return new Descriptor("dual_keygen_request", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_KEYGEN_REQ", (String[])new String[0]));
        }
        return null;
    }
}

