/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserValidityDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(UserValidityDefault.class);
    public static final String VAL_NOT_BEFORE = "userValdityNotBefore";
    public static final String VAL_NOT_AFTER = "userValdityNotAfter";

    public UserValidityDefault() {
        this.addValueName(VAL_NOT_BEFORE);
        this.addValueName(VAL_NOT_AFTER);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NOT_BEFORE)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_BEFORE", (String[])new String[0]));
        }
        if (name.equals(VAL_NOT_AFTER)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_AFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                Date notBefore = (Date)validity.get("notBefore");
                return notBefore.toString();
            }
            catch (Exception e) {
                logger.error("UserValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals(VAL_NOT_AFTER)) {
            try {
                CertificateValidity validity = null;
                validity = (CertificateValidity)info.get("validity");
                Date notAfter = (Date)validity.get("notAfter");
                return notAfter.toString();
            }
            catch (Exception e) {
                logger.error("UserValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_USER_VALIDITY", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateValidity certValidity = null;
        try {
            byte[] certValidityData = request.getExtDataInByteArray("req_validity");
            if (certValidityData != null) {
                certValidity = new CertificateValidity();
                certValidity.decode((InputStream)new ByteArrayInputStream(certValidityData));
            }
            info.set("validity", (Object)certValidity);
        }
        catch (Exception e) {
            logger.warn("UserValidityDefault: populate " + e.getMessage(), (Throwable)e);
        }
    }
}

