/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cms.profile.def.SubjectNameDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.provider.DSAPublicKey;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerKeygenUserKeyDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(SubjectNameDefault.class);
    public static final String CONFIG_ENABLE_ARCHIVAL = "enableArchival";
    public static final String CONFIG_LEN = "keySize";
    public static final String CONFIG_TYPE = "keyType";
    public static final String VAL_LEN = "LEN";
    public static final String VAL_TYPE = "TYPE";
    private static final String TEMP_PUBKEY_RSA_1024 = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBz6H2rT2r1RpHdr3JyYr7thSjfwWPbIJ6U09NziHSekLsNZQKsjdLS/LPCfe/aXkhpzPztlx++tkPucpt/xT0exp08feAPIE+Y6gVoyXzEw+Ztz+Zez9Y1cQWxAyp7z11flytjL+4zBGDXmEoe3ZlQvij9DGypPjBC9PhWm0lBwIDAQAB";
    private static final String TEMP_PUBKEY_RSA_2048 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4Ha+CxWDPAHEl9+u57U3UCw8bfG/ZN3cVTrQgj/p8ak12NYUWt0ZI/xCcLj7gKwFPbNMTDwzizRPZuxKJT7fHgW8a1BQDUL2VGfx7O0A7KlLqcpVc6VKsQx5caP3hrB38Q5xnTKeVee9cBrd8An+veZ2QV6mHLEU8iMCN2No/t1oO+aYje42XloNRblXVQAOYW+3aMCam2kIKWUqLvA3Sbf2BPR2x5SSZRPHJt3hQCheara5j+nHLQ8paRvVlT+ghgyX5N3BwiPmvC+e9iUaaofj+DxrGX3cTo5hehG2b71sY3xdC5OIhEGRfkAqIAEw6eaU6a/ymNsByRgVByfQaQIDAQAB";
    private static final String TEMP_PUBKEY_RSA_3072 = "MIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAm0yQ0y+8YOTWkye5qFuqNI/qC4wtjEjNnoZaqSZUOJLg6ZRDlsZoOiblJpw65rPjaPcSp/inqYfCCA5mISYaqfcoB80LCnw1+DAv8tcvwUtytQYXHVj2gbyuVHaBgD4n4j/wFV80sF3OTQcPKYmeTfWRtv2xZQMK9rYfa8Le+DAZyOWPk4+RtTIRPa5R9arLqE+ONgUcrD3NvewOdsCrT7flJnFdx8TGl5ftxVWYlHRSg+wEB8pQZlw0BSDlQGHXIRjBKT2+iCkYzuKPWpMbu42PnBaQTcvjD3cl8MjLQcZp6v39bU1Du0C0LYunhvIWidwKnCOGOYu+a0VKuHxH8odjFdPoWGmP+orllkwSZzhWayYJxGpJJQlWcM05uD6qDF67WQnuYsliVH4LNiSjf/iPSpr0tzDXOtdeVsiQgO9wYYlnooBtd1xfTmkILwt3j9ZXeBtmt4lLYxbLo2ZCzkFqCCdu5FfcFgxjPaRaW0bQHKuP1woGk0rDUUbuqr+PAgMBAAE=";
    private static final String TEMP_PUBKEY_RSA_4096 = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAs3xoddtoCQrDpPK/45DpN/wPHO/6qrsbEDnwEnSkcLz51WHb7+CEUP9oxuE8vPn9JXcLdZkgPcmfMVibSUEJVUCXPibGTqAJ/7RAAm+/FhdL02N57hpgLzbIPbIaTP00z/jbTqR4a0uV49fnEPqrhA/KoUmOn3eoiAPAB5xNSauFOmMZXv2gr4akNxvSiZ/59ddYF+DBEFSs4ufCqIqBWYAMMo78eskgm/ZUyv7OZzG+8c1nncdnrNk/JtXauANu8NUQXX2qllmEOioY6gnalpR26fwOscjkvHDTvRQmSIqceWdd5P6OMHJwzTVG8d4b0f150o1RTzU3gvg9/qXvbOGcnH2TXZjYi02mhyXgPrimZepKyDr2LjeAEZbfAAXecaMhjrDZEkDZNFWe4eoG2JuE34TODeiCLMBql6VTgOvCFW3to32aBwNLpCV4hi5rKLnPMlf8Tz0zYvGqDeCp4zzy6C9tosiYfHIkVU/AVqK9PoY0RsLnBzHOV7Jl2VgHr8Ro+C66+leajssAemK8swcj2AZEOuVLlsdCvguUn6XUyDqI3tIfnoLK690hG1znuIWzFZzzivZ5ZwgfxguCly9zDArc7i6YHxOR2lcUrM0VfHmyHpE9JNfarEgAPS59ASG7y14LOvp4yYKNz10TtetwkSfpcjqiuWHtIDi9sjMCAwEAAQ==";
    private static final String TEMP_PUBKEY_EC_NISTP256 = "MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEw67JdXDj1J3wwvLTYtzpyUArev/Ra2QEsHo+q5P3VcDrr0HqJGXsj5/vH7bPe4WG5OkgxmL5BiBpKpTmJMxNLg==";
    private static final String TEMP_PUBKEY_EC_NISTP384 = "MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEdjuCVoP3qykxs97Wjk2k/cEE6fza0N0Y8JRzLYNrFtOti4zKNpvYcteaYTWLKYGOUEgGuOBV9lWjEbZSH5n+AqKf+JLaTu+Qytsr9OnBu3L4r18yNdWQQo/LlaLkr5on";
    private static final String TEMP_PUBKEY_EC_NISTP521 = "MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQAnGS6GRhXMwgKu+0G7BHWbu99h4KoZi4vzKvJ+QmoApZbaU0A83ayHhKp6c5mubgZY7Vq1/msGxju89QqOf25nNwBOl9Y0IYG+/LMSjtSR1rU+MI00iyrjx3GgnC0lbxZD6KiPqMNlx5h4oyiy6d+xYfIweSF+QYVm53s4Q4OWVEhz54=";

    public ServerKeygenUserKeyDefault() {
        this.addConfigName(CONFIG_ENABLE_ARCHIVAL);
        this.addConfigName(CONFIG_TYPE);
        this.addConfigName(CONFIG_LEN);
        this.addValueName(VAL_TYPE);
        this.addValueName(VAL_LEN);
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_ENABLE_ARCHIVAL)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SERVER_SIDE_KEYGEN_ENABLE_ARCHIVAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_TYPE)) {
            return new Descriptor("string", null, "RSA", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SERVER_SIDE_KEYGEN_KEYTYPE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_LEN)) {
            return new Descriptor("string", null, "2048", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SERVER_SIDE_KEYGEN_KEYSIZE", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_LEN)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_LEN", (String[])new String[0]));
        }
        if (name.equals(VAL_TYPE)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_TYPE", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        logger.debug("ServerKeygenUserKeyDefault: getValue name=" + name);
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_LEN)) {
            CertificateX509Key ck = null;
            try {
                ck = (CertificateX509Key)info.get("key");
            }
            catch (Exception exception) {
                // empty catch block
            }
            X509Key k = null;
            try {
                k = (X509Key)ck.get("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (k == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_NOT_FOUND", (String[])new String[0]));
            }
            try {
                if (k.getAlgorithm().equals("RSA")) {
                    return Integer.toString(this.getRSAKeyLen(k));
                }
                if (k.getAlgorithm().equals("EC")) {
                    Vector vect = CryptoUtil.getECKeyCurve((X509Key)k);
                    if (vect == null) {
                        return null;
                    }
                    return vect.toString();
                }
                return Integer.toString(this.getDSAKeyLen(k));
            }
            catch (Exception e) {
                logger.debug("ServerKeygenUserKeyDefault: getValue " + e.toString());
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals(VAL_TYPE)) {
            CertificateX509Key ck = null;
            try {
                ck = (CertificateX509Key)info.get("key");
            }
            catch (Exception k) {
                // empty catch block
            }
            X509Key k = null;
            try {
                k = (X509Key)ck.get("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (k == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_NOT_FOUND", (String[])new String[0]));
            }
            return k.getAlgorithm() + " - " + k.getAlgorithmId().getOID().toString();
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_TYPE), this.getConfig(CONFIG_LEN)};
        logger.debug("ServerKeygenUserKeyDefault: getText ");
        if (locale == null) {
            logger.debug("ServerKeygenUserKeyDefault: getText: locale null ");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SERVER_KEYGEN_USER_KEY_INFO", (String[])params);
    }

    public int getRSAKeyLen(X509Key key) throws Exception {
        X509Key newkey = null;
        try {
            newkey = new X509Key(AlgorithmId.get((String)"RSA"), key.getKey());
        }
        catch (Exception e) {
            logger.debug("ServerKeygenUserKeyDefault: getRSAKey " + e.toString());
            throw e;
        }
        RSAPublicKey rsaKey = new RSAPublicKey(newkey.getEncoded());
        return rsaKey.getKeySize();
    }

    public int getDSAKeyLen(X509Key key) throws Exception {
        DSAPublicKey dsaKey = new DSAPublicKey(key.getEncoded());
        DSAParams keyParams = dsaKey.getParams();
        BigInteger p = keyParams.getP();
        int len = p.bitLength();
        return len;
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateX509Key certKey = null;
        String method = "ServerKeygenUserKeyDefault: populate: ";
        logger.debug(method + "begins");
        Object errmsg = "";
        try {
            String pubKeyStr;
            block40: {
                String curveName;
                block39: {
                    String p12passwd = request.getExtDataInString("serverSideKeygenP12Passwd");
                    if (p12passwd == null || p12passwd.length() == 0) {
                        logger.debug(method + "p12passwd not found");
                        throw new EPropertyException(CMS.getUserMessage((String)"CMS_PASSWORD_EMPTY_PASSWORD", (String[])new String[0]));
                    }
                    Object transportCertStr = null;
                    CryptoManager cm = CryptoManager.getInstance();
                    X509Certificate transCert = null;
                    CAEngine engine = CAEngine.getInstance();
                    CertificateAuthority ca = engine.getCA();
                    CAConfig caConfig = ca.getConfigStore();
                    ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
                    ConnectorConfig kraConnectorConfig = connectorsConfig.getConnectorConfig("KRA");
                    try {
                        String transportNickname = kraConnectorConfig.getString("transportCertNickname", "KRA Transport Certificate");
                        transCert = cm.findCertByNickname(transportNickname);
                    }
                    catch (Exception e) {
                        logger.debug(method + "'KRA transport certificate' not found in nssdb; need to be manually setup for Server-Side keygen enrollment");
                        throw new EPropertyException(CMS.getUserMessage((String)"CMS_MISSING_KRA_TRANSPORT_CERT_IN_CA_NSSDB", (String[])new String[0]));
                    }
                    CryptoToken ct = CryptoUtil.getCryptoToken((String)"internal");
                    if (ct == null) {
                        logger.debug(method + "crypto token null");
                    }
                    EncryptionAlgorithm encryptAlgorithm = EncryptionAlgorithm.AES_128_CBC_PAD;
                    CAEngineConfig caCfg = engine.getConfig();
                    boolean useOAEP = caCfg.getUseOAEPKeyWrap();
                    KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.RSA;
                    if (useOAEP) {
                        wrapAlgorithm = KeyWrapAlgorithm.RSA_OAEP;
                    }
                    logger.debug(method + "KeyWrapAlgorithm: " + wrapAlgorithm);
                    SymmetricKey sessionKey = CryptoUtil.generateKey((CryptoToken)ct, (KeyGenAlgorithm)KeyGenAlgorithm.AES, (int)128, null, (boolean)true);
                    byte[] iv = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                    byte[] sessionWrappedPassphrase = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)ct, (SymmetricKey)sessionKey, (byte[])p12passwd.getBytes("UTF-8"), (EncryptionAlgorithm)encryptAlgorithm, (IVParameterSpec)new IVParameterSpec(iv));
                    logger.debug(method + "sessionWrappedPassphrase.length=" + sessionWrappedPassphrase.length);
                    Object transWrappedSessionKey = CryptoUtil.wrapUsingPublicKey((CryptoToken)ct, (PublicKey)transCert.getPublicKey(), (SymmetricKey)sessionKey, (KeyWrapAlgorithm)wrapAlgorithm);
                    logger.debug(method + " transWrappedSessionKey.length =" + ((byte[])transWrappedSessionKey).length);
                    CertificateSubjectName reqSubj = request.getExtDataInCertSubjectName("req_subject_name");
                    String subj = "unknown serverKeyGenUser";
                    if (reqSubj != null) {
                        X500Name xN = reqSubj.getX500Name();
                        subj = xN.toString();
                        logger.debug(method + "subj = " + subj);
                    }
                    request.setExtData("clientKeyID", subj);
                    request.setExtData("serverSideKeygenP12PasswdEnc", sessionWrappedPassphrase);
                    request.setExtData("serverSideKeygenP12PasswdTransSession", (byte[])transWrappedSessionKey);
                    request.setExtData("serverSideKeygenP12Passwd", "");
                    request.deleteExtData("serverSideKeygenP12Passwd");
                    request.setExtData("isServerSideKeygen", "true");
                    CryptoToken token = cm.getInternalKeyStorageToken();
                    String keyTypeStr = request.getExtDataInString(CONFIG_TYPE);
                    String keyType = "RSA";
                    int keySize = 2048;
                    curveName = "nistp256";
                    if (keyTypeStr != null && !keyTypeStr.isEmpty()) {
                        logger.debug("ServerKeygenUserKeyDefault: populate: keyType in request: " + keyTypeStr);
                        keyType = keyTypeStr;
                    } else {
                        logger.debug("ServerKeygenUserKeyDefault: populate: keyType in request null; default to RSA");
                    }
                    boolean isEC = false;
                    String keySizeCurveStr = request.getExtDataInString(CONFIG_LEN);
                    if (keyType.contentEquals("RSA")) {
                        if (keySizeCurveStr != null && !keySizeCurveStr.isEmpty()) {
                            logger.debug("ServerKeygenUserKeyDefault: populate: keySize in request: " + keySizeCurveStr);
                            keySize = Integer.parseInt(keySizeCurveStr);
                        } else {
                            logger.debug("ServerKeygenUserKeyDefault: populate: keySize in request null;  default to" + keySize);
                        }
                    } else if (keyType.contentEquals("EC")) {
                        isEC = true;
                        if (keySizeCurveStr != null && !keySizeCurveStr.isEmpty()) {
                            logger.debug("ServerKeygenUserKeyDefault: populate: keyCurve in request: " + keySizeCurveStr);
                            curveName = keySizeCurveStr;
                        } else {
                            logger.debug("ServerKeygenUserKeyDefault: populate: keySize in request null;  default to" + curveName);
                        }
                    } else {
                        throw new Exception("Unsupported keyType: " + keyType);
                    }
                    request.setExtData("keyGenAlgorithm", keyType);
                    if (keyType.contentEquals("RSA")) {
                        request.setExtData("keyGenSize", Integer.valueOf(keySize));
                    } else if (keyType.contentEquals("EC")) {
                        request.setExtData("keyGenSize", curveName);
                    }
                    pubKeyStr = "";
                    if (isEC) break block39;
                    switch (keySize) {
                        case 1024: {
                            pubKeyStr = TEMP_PUBKEY_RSA_1024;
                            break block40;
                        }
                        case 2048: {
                            pubKeyStr = TEMP_PUBKEY_RSA_2048;
                            break block40;
                        }
                        case 3072: {
                            pubKeyStr = TEMP_PUBKEY_RSA_3072;
                            break block40;
                        }
                        case 4096: {
                            pubKeyStr = TEMP_PUBKEY_RSA_4096;
                            break block40;
                        }
                        default: {
                            errmsg = "unsupported keySize: " + keySize;
                            logger.debug("ServerKeygenUserKeyDefault: populate: " + (String)errmsg);
                            throw new EProfileException((String)errmsg);
                        }
                    }
                }
                switch (curveName) {
                    case "nistp256": {
                        pubKeyStr = TEMP_PUBKEY_EC_NISTP256;
                        break;
                    }
                    case "nistp384": {
                        pubKeyStr = TEMP_PUBKEY_EC_NISTP384;
                        break;
                    }
                    case "nistp521": {
                        pubKeyStr = TEMP_PUBKEY_EC_NISTP521;
                        break;
                    }
                    default: {
                        errmsg = "unsupported cureveName: " + curveName;
                        logger.debug("ServerKeygenUserKeyDefault: populate: " + (String)errmsg);
                        throw new EProfileException((String)errmsg);
                    }
                }
            }
            byte[] certKeyData = CryptoUtil.base64Decode((String)pubKeyStr);
            if (certKeyData != null) {
                certKey = new CertificateX509Key((InputStream)new ByteArrayInputStream(certKeyData));
            } else {
                logger.debug("ServerKeygenUserKeyDefault: populate: serverKeygen to be implemented ");
            }
            boolean enableArchival = this.getConfigBoolean(CONFIG_ENABLE_ARCHIVAL);
            request.setExtData("serverSideKeygenEnrollEnableArchival", enableArchival ? "true" : "false");
            info.set("key", (Object)certKey);
        }
        catch (Exception e) {
            logger.debug("ServerKeygenUserKeyDefault: populate " + e.toString());
            throw new EProfileException(e.getMessage());
        }
    }
}

