/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPoint;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.FreshestCRLExtension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreshestCRLExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(FreshestCRLExtDefault.class);
    public static final String CONFIG_CRITICAL = "freshestCRLCritical";
    public static final String CONFIG_NUM_POINTS = "freshestCRLPointNum";
    public static final String CONFIG_POINT_TYPE = "freshestCRLPointType_";
    public static final String CONFIG_POINT_NAME = "freshestCRLPointName_";
    public static final String CONFIG_ISSUER_TYPE = "freshestCRLPointIssuerType_";
    public static final String CONFIG_ISSUER_NAME = "freshestCRLPointIssuerName_";
    public static final String CONFIG_ENABLE = "freshestCRLPointEnable_";
    public static final String VAL_CRITICAL = "freshestCRLCritical";
    public static final String VAL_CRL_DISTRIBUTION_POINTS = "freshestCRLPointsValue";
    private static final String POINT_TYPE = "Point Type";
    private static final String POINT_NAME = "Point Name";
    private static final String ISSUER_TYPE = "Issuer Type";
    private static final String ISSUER_NAME = "Issuer Name";
    private static final String ENABLE = "Enable";
    private static final int DEF_NUM_POINTS = 1;
    private static final int MAX_NUM_POINTS = 100;

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    protected int getNumPoints() {
        int num = 1;
        String val = this.getConfig(CONFIG_NUM_POINTS);
        if (val != null) {
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(CONFIG_NUM_POINTS)) {
            try {
                num = Integer.parseInt(value);
                if (num >= 100 || num < 0) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_POINTS}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_POINTS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName("freshestCRLCritical");
        this.addValueName(VAL_CRL_DISTRIBUTION_POINTS);
        this.addConfigName("freshestCRLCritical");
        int num = this.getNumPoints();
        this.addConfigName(CONFIG_NUM_POINTS);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_POINT_TYPE + i);
            this.addConfigName(CONFIG_POINT_NAME + i);
            this.addConfigName(CONFIG_ISSUER_TYPE + i);
            this.addConfigName(CONFIG_ISSUER_NAME + i);
            this.addConfigName(CONFIG_ENABLE + i);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("freshestCRLCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_POINT_TYPE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POINT_TYPE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_POINT_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_POINT_NAME", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ISSUER_TYPE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_TYPE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ISSUER_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_NAME", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_ENABLE)) {
            return new Descriptor("boolean", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_POINTS)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_DIST_POINTS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("freshestCRLCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_CRL_DISTRIBUTION_POINTS)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRL_DISTRIBUTION_POINTS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            FreshestCRLExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (FreshestCRLExtension)this.getExtension("2.5.29.46", info);
            if (ext == null) {
                this.populate(locale, info);
            }
            if (name.equals("freshestCRLCritical")) {
                ext = (FreshestCRLExtension)this.getExtension("2.5.29.46", info);
                boolean val = Boolean.valueOf(value);
                ext.setCritical(val);
            } else if (name.equals(VAL_CRL_DISTRIBUTION_POINTS)) {
                ext = (FreshestCRLExtension)this.getExtension("2.5.29.46", info);
                Vector<NameValuePairs> v = this.parseRecords(value);
                int size = v.size();
                boolean critical = ext.isCritical();
                for (int i = 0; i < size; ++i) {
                    NameValuePairs nvps = v.elementAt(i);
                    String pointType = null;
                    String pointValue = null;
                    String issuerType = null;
                    String issuerValue = null;
                    String enable = null;
                    CRLDistributionPoint cdp = new CRLDistributionPoint();
                    for (String name1 : nvps.keySet()) {
                        if (name1.equals(POINT_TYPE)) {
                            pointType = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(POINT_NAME)) {
                            pointValue = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(ISSUER_TYPE)) {
                            issuerType = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (name1.equals(ISSUER_NAME)) {
                            issuerValue = (String)nvps.get((Object)name1);
                            continue;
                        }
                        if (!name1.equals(ENABLE)) continue;
                        enable = (String)nvps.get((Object)name1);
                    }
                    if (enable == null || !enable.equals("true")) continue;
                    if (pointType != null) {
                        this.addCRLPoint(locale, cdp, pointType, pointValue);
                    }
                    if (issuerType != null) {
                        this.addIssuer(locale, cdp, issuerType, issuerValue);
                    }
                    if (i == 0) {
                        ext = new FreshestCRLExtension(cdp);
                        ext.setCritical(critical);
                        continue;
                    }
                    ext.addPoint(cdp);
                }
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.FreshestCRL_Id.toString(), (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.error("FreshestCRLExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    private void addCRLPoint(Locale locale, CRLDistributionPoint cdp, String type, String value) throws EPropertyException {
        try {
            if (value == null || value.length() == 0) {
                return;
            }
            if (!this.isGeneralNameType(type)) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
            }
            GeneralNames gen = new GeneralNames();
            gen.addElement((Object)this.parseGeneralName(type, value));
            cdp.setFullName(gen);
        }
        catch (IOException e) {
            logger.error("FreshestCRLExtDefault: addCRLPoint " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
        }
        catch (GeneralNamesException e) {
            logger.error("FreshestCRLExtDefault: addCRLPoint " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
        }
    }

    private void addIssuer(Locale locale, CRLDistributionPoint cdp, String type, String value) throws EPropertyException {
        if (value == null || value.length() == 0) {
            return;
        }
        try {
            if (!this.isGeneralNameType(type)) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{type}));
            }
            GeneralNames gen = new GeneralNames();
            gen.addElement((Object)this.parseGeneralName(type, value));
            cdp.setCRLIssuer(gen);
        }
        catch (IOException e) {
            logger.warn("FreshestCRLExtDefault: addIssuer " + e.getMessage(), (Throwable)e);
        }
        catch (GeneralNamesException e) {
            logger.warn("FreshestCRLExtDefault: addIssuer " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        FreshestCRLExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext = (FreshestCRLExtension)this.getExtension("2.5.29.46", info);
        if (ext == null) {
            try {
                this.populate(locale, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("freshestCRLCritical")) {
            ext = (FreshestCRLExtension)this.getExtension("2.5.29.46", info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_CRL_DISTRIBUTION_POINTS)) {
            ext = (FreshestCRLExtension)this.getExtension("2.5.29.46", info);
            if (ext == null) {
                return "";
            }
            Vector<NameValuePairs> recs = new Vector<NameValuePairs>();
            int num = this.getNumPoints();
            for (int i = 0; i < num; ++i) {
                NameValuePairs pairs = null;
                if (i < ext.getNumPoints()) {
                    CRLDistributionPoint p = ext.getPointAt(i);
                    GeneralNames gns = p.getFullName();
                    pairs = this.buildGeneralNames(gns, p);
                } else {
                    pairs = this.buildEmptyGeneralNames();
                }
                recs.addElement(pairs);
            }
            return FreshestCRLExtDefault.buildRecords(recs);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    protected NameValuePairs buildEmptyGeneralNames() {
        NameValuePairs pairs = new NameValuePairs();
        pairs.put((Object)POINT_TYPE, (Object)"");
        pairs.put((Object)POINT_NAME, (Object)"");
        pairs.put((Object)ISSUER_TYPE, (Object)"");
        pairs.put((Object)ISSUER_NAME, (Object)"");
        pairs.put((Object)ENABLE, (Object)"false");
        return pairs;
    }

    protected NameValuePairs buildGeneralNames(GeneralNames gns, CRLDistributionPoint p) throws EPropertyException {
        GeneralName gn;
        NameValuePairs pairs = new NameValuePairs();
        boolean hasFullName = false;
        pairs.put((Object)ENABLE, (Object)"true");
        if (gns == null) {
            pairs.put((Object)POINT_TYPE, (Object)"");
            pairs.put((Object)POINT_NAME, (Object)"");
        } else {
            gn = (GeneralName)gns.elementAt(0);
            if (gn != null) {
                hasFullName = true;
                pairs.put((Object)POINT_TYPE, (Object)FreshestCRLExtDefault.getGeneralNameType(gn));
                pairs.put((Object)POINT_NAME, (Object)FreshestCRLExtDefault.getGeneralNameValue(gn));
            }
        }
        if (!hasFullName) {
            pairs.put((Object)POINT_TYPE, (Object)"DirectoryName");
            pairs.put((Object)POINT_NAME, (Object)"");
        }
        if ((gns = p.getCRLIssuer()) == null) {
            pairs.put((Object)ISSUER_TYPE, (Object)"DirectoryName");
            pairs.put((Object)ISSUER_NAME, (Object)"");
        } else {
            gn = (GeneralName)gns.elementAt(0);
            if (gn != null) {
                hasFullName = true;
                pairs.put((Object)ISSUER_TYPE, (Object)FreshestCRLExtDefault.getGeneralNameType(gn));
                pairs.put((Object)ISSUER_NAME, (Object)FreshestCRLExtDefault.getGeneralNameValue(gn));
            }
        }
        return pairs;
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        int num = this.getNumPoints();
        for (int i = 0; i < num; ++i) {
            sb.append("Record #");
            sb.append(i);
            sb.append("{");
            sb.append("Point Type:");
            sb.append(this.getConfig(CONFIG_POINT_TYPE + i));
            sb.append(",");
            sb.append("Point Name:");
            sb.append(this.getConfig(CONFIG_POINT_NAME + i));
            sb.append(",");
            sb.append("Issuer Type:");
            sb.append(this.getConfig(CONFIG_ISSUER_TYPE + i));
            sb.append(",");
            sb.append("Issuer Name:");
            sb.append(this.getConfig(CONFIG_ISSUER_NAME + i));
            sb.append(",");
            sb.append("Enable:");
            sb.append(this.getConfig(CONFIG_ENABLE + i));
            sb.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_FRESHEST_CRL_EXT", (String[])new String[]{this.getConfig("freshestCRLCritical"), sb.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        FreshestCRLExtension ext = this.createExtension(request);
        if (ext == null) {
            return;
        }
        this.addExtension("2.5.29.46", (Extension)ext, info);
    }

    public FreshestCRLExtension createExtension(Request request) {
        FreshestCRLExtension ext = new FreshestCRLExtension();
        int num = 0;
        try {
            boolean critical = this.getConfigBoolean("freshestCRLCritical");
            ext.setCritical(critical);
            num = this.getNumPoints();
            for (int i = 0; i < num; ++i) {
                CRLDistributionPoint cdp = new CRLDistributionPoint();
                String enable = this.getConfig(CONFIG_ENABLE + i);
                String pointType = this.getConfig(CONFIG_POINT_TYPE + i);
                String pointName = this.getConfig(CONFIG_POINT_NAME + i);
                String issuerType = this.getConfig(CONFIG_ISSUER_TYPE + i);
                String issuerName = this.getConfig(CONFIG_ISSUER_NAME + i);
                if (enable == null || !enable.equals("true")) continue;
                if (pointType != null) {
                    this.addCRLPoint(this.getLocale(request), cdp, pointType, pointName);
                }
                if (issuerType != null) {
                    this.addIssuer(this.getLocale(request), cdp, issuerType, issuerName);
                }
                ext.addPoint(cdp);
            }
        }
        catch (Exception e) {
            logger.warn("FreshestCRLExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }

    private void populate(Locale locale, X509CertInfo info) throws EProfileException {
        FreshestCRLExtension ext = this.createExtension(locale);
        if (ext == null) {
            return;
        }
        this.addExtension("2.5.29.46", (Extension)ext, info);
    }

    public FreshestCRLExtension createExtension(Locale locale) {
        FreshestCRLExtension ext = new FreshestCRLExtension();
        int num = 0;
        try {
            boolean critical = this.getConfigBoolean("freshestCRLCritical");
            ext.setCritical(critical);
            num = this.getNumPoints();
            for (int i = 0; i < num; ++i) {
                CRLDistributionPoint cdp = new CRLDistributionPoint();
                String enable = this.getConfig(CONFIG_ENABLE + i);
                String pointType = this.getConfig(CONFIG_POINT_TYPE + i);
                String pointName = this.getConfig(CONFIG_POINT_NAME + i);
                String issuerType = this.getConfig(CONFIG_ISSUER_TYPE + i);
                String issuerName = this.getConfig(CONFIG_ISSUER_NAME + i);
                if (enable == null || !enable.equals("true")) continue;
                if (pointType != null) {
                    this.addCRLPoint(locale, cdp, pointType, pointName);
                }
                if (issuerType != null) {
                    this.addIssuer(locale, cdp, issuerType, issuerName);
                }
                ext.addPoint(cdp);
            }
        }
        catch (Exception e) {
            logger.warn("FreshestCRLExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

