/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonNameToSANDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(CommonNameToSANDefault.class);
    private static final String LOG_PREFIX = "CommonNameToSANDefault: ";

    @Override
    public void populate(Request _req, X509CertInfo info) throws EProfileException {
        List cns;
        X500Name sdn;
        CertificateSubjectName subjectName;
        try {
            subjectName = (CertificateSubjectName)info.get("subject");
        }
        catch (IOException | CertificateException e) {
            logger.error("CommonNameToSANDefault: failed to read Subject DN: " + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            sdn = (X500Name)subjectName.get("dname");
        }
        catch (IOException e) {
            logger.error("CommonNameToSANDefault: failed to retrieve SDN X500Name: " + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            cns = sdn.getAttributesForOid(X500Name.commonName_oid);
        }
        catch (IOException e) {
            logger.error("CommonNameToSANDefault: failed to decode CN: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (cns.size() < 1) {
            logger.debug("CommonNameToSANDefault: No CN in Subject DN; done");
            return;
        }
        String cn = (String)cns.get(cns.size() - 1);
        logger.debug("CommonNameToSANDefault: Examining CN: " + cn);
        if (!CommonNameToSANDefault.isValidDNSName(cn)) {
            logger.debug("CommonNameToSANDefault: CN is not a DNS name; done");
            return;
        }
        SubjectAlternativeNameExtension san = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
        if (san != null) {
            GeneralNames gns = san.getGeneralNames();
            for (GeneralNameInterface gn : gns) {
                String dnsName;
                if (gn instanceof GeneralName) {
                    gn = ((GeneralName)gn).unwrap();
                }
                if (!(gn instanceof DNSName) || !cn.equalsIgnoreCase(dnsName = ((DNSName)gn).getValue())) continue;
                logger.debug("CommonNameToSANDefault: CN already has corresponding SAN dNSName; done");
                return;
            }
            gns.add((Object)new DNSName(cn));
            san.setGeneralNames(gns);
            logger.debug("CommonNameToSANDefault: added CN to SAN; done");
        } else {
            GeneralNames gns = new GeneralNames();
            gns.add((Object)new DNSName(cn));
            try {
                san = new SubjectAlternativeNameExtension(gns);
                this.addExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), (Extension)san, info);
            }
            catch (IOException e) {
                logger.error("CommonNameToSANDefault: failed to construct SAN ext: " + e.getMessage(), (Throwable)e);
                return;
            }
            logger.debug("CommonNameToSANDefault: added SAN extension containing CN; done");
        }
    }

    @Override
    public String getText(Locale locale) {
        return "This default add the Subject DN Common Name to the Subject Alternative Name extension, if it looks like a DNS name.";
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) {
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) {
    }

    public static boolean isValidDNSName(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() < 1 || s.length() > 255) {
            return false;
        }
        String[] parts = s.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            char[] cs = parts[i].toCharArray();
            if (cs.length < 1 || cs.length > 63) {
                return false;
            }
            if (!CommonNameToSANDefault.isLetDig(cs[0])) {
                return false;
            }
            if (!CommonNameToSANDefault.isLetDig(cs[cs.length - 1])) {
                return false;
            }
            for (int j = 0; j < cs.length; ++j) {
                if (CommonNameToSANDefault.isLetDigHyp(cs[j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLetDig(char c) {
        return CommonNameToSANDefault.isLetter(c) || CommonNameToSANDefault.isDigit(c);
    }

    public static boolean isLetDigHyp(char c) {
        return CommonNameToSANDefault.isLetDig(c) || c == '-';
    }
}

